/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Distance;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DistanceLineLineStressTest
extends TestCase {
    static Random randGen = new Random(123456L);

    public static void main(String[] args) {
        TestRunner.run(DistanceLineLineStressTest.class);
    }

    public DistanceLineLineStressTest(String name) {
        super(name);
    }

    public void testRandomDisjointCollinearSegments() throws Exception {
        int n = 1000000;
        int failCount = 0;
        for (int i = 0; i < n; ++i) {
            Coordinate[] seg = DistanceLineLineStressTest.randomDisjointCollinearSegments();
            if (0.0 != Distance.segmentToSegment((Coordinate)seg[0], (Coordinate)seg[1], (Coordinate)seg[2], (Coordinate)seg[3])) continue;
            ++failCount;
        }
        System.out.println("# failed = " + failCount + " out of " + n);
    }

    private static Coordinate[] randomDisjointCollinearSegments() {
        double slope = randGen.nextDouble();
        Coordinate[] seg = new Coordinate[4];
        double gap = 1.0;
        double x1 = 10.0;
        double x2 = x1 + gap;
        double x3 = x1 + gap + 10.0;
        seg[0] = new Coordinate(0.0, 0.0);
        seg[1] = new Coordinate(x1, slope * x1);
        seg[2] = new Coordinate(x2, slope * x2);
        seg[3] = new Coordinate(x3, slope * x3);
        return seg;
    }
}

