/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.row;

import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.SqlCustomClass;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HeapRowTest
extends CoreSqlTestSupport {
    @Test
    public void testHeapRow() {
        Object[] values = new Object[]{new Object(), new Object()};
        HeapRow row = new HeapRow(values);
        Assert.assertEquals((long)2L, (long)row.getColumnCount());
        Assert.assertSame((Object)values[0], (Object)row.get(0));
        Assert.assertSame((Object)values[1], (Object)row.get(1));
        row = new HeapRow(2);
        row.set(0, values[0]);
        row.set(1, values[1]);
        Assert.assertEquals((long)2L, (long)row.getColumnCount());
        Assert.assertSame((Object)values[0], (Object)row.get(0));
        Assert.assertSame((Object)values[1], (Object)row.get(1));
    }

    @Test
    public void testEquals() {
        HeapRowTest.checkEquals(new HeapRow(2), new HeapRow(2), true);
        HeapRowTest.checkEquals(new HeapRow(2), new HeapRow(3), false);
        HeapRow row1 = new HeapRow(2);
        HeapRow row2 = new HeapRow(2);
        HeapRow row3 = new HeapRow(2);
        Object value1 = new Object();
        Object value2 = new Object();
        Object value3 = new Object();
        row1.set(0, value1);
        row2.set(0, value1);
        row3.set(0, value1);
        row1.set(1, value2);
        row2.set(1, value2);
        row3.set(1, value3);
        HeapRowTest.checkEquals(row1, row2, true);
        HeapRowTest.checkEquals(row1, row3, false);
    }

    @Test
    public void testSerialization() {
        HeapRow original = new HeapRow(2);
        original.set(0, (Object)1);
        original.set(1, (Object)new SqlCustomClass(1));
        HeapRow restored = (HeapRow)HeapRowTest.serializeAndCheck(original, 82);
        HeapRowTest.checkEquals(original, restored, true);
    }
}

