/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j.basicTests;

import com.hazelcast.shaded.org.slf4j.IMarkerFactory;
import com.hazelcast.shaded.org.slf4j.Marker;
import com.hazelcast.shaded.org.slf4j.basicTests.Differentiator;
import com.hazelcast.shaded.org.slf4j.helpers.BasicMarkerFactory;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class BasicMarkerTest {
    static final String BLUE_STR = "BLUE";
    static final String RED_STR = "RED";
    static final String GREEN_STR = "GREEN";
    static final String COMP_STR = "COMP";
    static final String MULTI_COMP_STR = "MULTI_COMP";
    static final String PARENT_MARKER_STR = "PARENT_MARKER";
    static final String CHILD_MARKER_STR = "CHILD_MARKER";
    static final String NOT_CONTAINED_MARKER_STR = "NOT_CONTAINED";
    final IMarkerFactory factory;
    final Marker blue;
    final Marker red;
    final Marker green;
    final Marker comp;
    final Marker multiComp;
    short diff = Differentiator.getDiffentiator();

    public BasicMarkerTest() {
        this.factory = new BasicMarkerFactory();
        this.blue = this.factory.getMarker(BLUE_STR);
        this.red = this.factory.getMarker(RED_STR);
        this.green = this.factory.getMarker(GREEN_STR);
        this.comp = this.factory.getMarker(COMP_STR);
        this.comp.add(this.blue);
        this.multiComp = this.factory.getMarker(MULTI_COMP_STR);
        this.multiComp.add(this.green);
        this.multiComp.add(this.comp);
    }

    @Test
    public void testPrimitive() {
        Assert.assertEquals((Object)BLUE_STR, (Object)this.blue.getName());
        Assert.assertTrue((boolean)this.blue.contains(this.blue));
        Marker blue2 = this.factory.getMarker(BLUE_STR);
        Assert.assertEquals((Object)BLUE_STR, (Object)blue2.getName());
        Assert.assertEquals((Object)this.blue, (Object)blue2);
        Assert.assertTrue((boolean)this.blue.contains(blue2));
        Assert.assertTrue((boolean)blue2.contains(this.blue));
    }

    @Test
    public void testPrimitiveByName() {
        Assert.assertTrue((boolean)this.blue.contains(BLUE_STR));
    }

    @Test
    public void testComposite() {
        Assert.assertTrue((boolean)this.comp.contains(this.comp));
        Assert.assertTrue((boolean)this.comp.contains(this.blue));
    }

    @Test
    public void testCompositeByName() {
        Assert.assertTrue((boolean)this.comp.contains(COMP_STR));
        Assert.assertTrue((boolean)this.comp.contains(BLUE_STR));
    }

    @Test
    public void testMultiComposite() {
        Assert.assertTrue((boolean)this.multiComp.contains(this.comp));
        Assert.assertTrue((boolean)this.multiComp.contains(this.blue));
        Assert.assertTrue((boolean)this.multiComp.contains(this.green));
        Assert.assertFalse((boolean)this.multiComp.contains(this.red));
    }

    @Test
    public void testMultiCompositeByName() {
        Assert.assertTrue((boolean)this.multiComp.contains(COMP_STR));
        Assert.assertTrue((boolean)this.multiComp.contains(BLUE_STR));
        Assert.assertTrue((boolean)this.multiComp.contains(GREEN_STR));
        Assert.assertFalse((boolean)this.multiComp.contains(RED_STR));
    }

    @Test
    public void testMultiAdd() {
        Marker parent = this.factory.getMarker(PARENT_MARKER_STR);
        Marker child = this.factory.getMarker(CHILD_MARKER_STR);
        for (int i = 0; i < 10; ++i) {
            parent.add(child);
        }
        Iterator iterator = parent.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)CHILD_MARKER_STR, (Object)((Marker)iterator.next()).toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testAddRemove() {
        String NEW_PREFIX = "NEW_";
        Marker parent = this.factory.getMarker("NEW_PARENT_MARKER");
        Marker child = this.factory.getMarker("NEW_CHILD_MARKER");
        Assert.assertFalse((boolean)parent.contains(child));
        Assert.assertFalse((boolean)parent.contains("NEW_CHILD_MARKER"));
        Assert.assertFalse((boolean)parent.remove(child));
        parent.add(child);
        Assert.assertTrue((boolean)parent.contains(child));
        Assert.assertTrue((boolean)parent.contains("NEW_CHILD_MARKER"));
        Assert.assertTrue((boolean)parent.remove(child));
        Assert.assertFalse((boolean)parent.contains(child));
        Assert.assertFalse((boolean)parent.contains("NEW_CHILD_MARKER"));
        Assert.assertFalse((boolean)parent.remove(child));
    }

    @Test
    public void testSelfRecursion() {
        String diffPrefix = "NEW_" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String NOT_CONTAINED_NAME = diffPrefix + NOT_CONTAINED_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker notContained = this.factory.getMarker(NOT_CONTAINED_NAME);
        parent.add(parent);
        Assert.assertTrue((boolean)parent.contains(parent));
        Assert.assertTrue((boolean)parent.contains(PARENT_NAME));
        Assert.assertFalse((boolean)parent.contains(notContained));
        Assert.assertFalse((boolean)parent.contains(NOT_CONTAINED_MARKER_STR));
    }

    @Test
    public void testIndirectRecursion() {
        String diffPrefix = "NEW_" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String CHILD_NAME = diffPrefix + CHILD_MARKER_STR;
        String NOT_CONTAINED_NAME = diffPrefix + NOT_CONTAINED_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker child = this.factory.getMarker(CHILD_NAME);
        Marker notContained = this.factory.getMarker(NOT_CONTAINED_NAME);
        parent.add(child);
        child.add(parent);
        Assert.assertTrue((boolean)parent.contains(parent));
        Assert.assertTrue((boolean)parent.contains(child));
        Assert.assertTrue((boolean)parent.contains(PARENT_NAME));
        Assert.assertTrue((boolean)parent.contains(CHILD_NAME));
        Assert.assertFalse((boolean)parent.contains(notContained));
        Assert.assertFalse((boolean)parent.contains(NOT_CONTAINED_MARKER_STR));
    }

    @Test
    public void testHomonyms() {
        String diffPrefix = "homonym" + this.diff;
        String PARENT_NAME = diffPrefix + PARENT_MARKER_STR;
        String CHILD_NAME = diffPrefix + CHILD_MARKER_STR;
        Marker parent = this.factory.getMarker(PARENT_NAME);
        Marker child = this.factory.getMarker(CHILD_NAME);
        parent.add(child);
        BasicMarkerFactory otherFactory = new BasicMarkerFactory();
        Marker otherParent = otherFactory.getMarker(PARENT_NAME);
        Marker otherChild = otherFactory.getMarker(CHILD_NAME);
        Assert.assertTrue((boolean)parent.contains(otherParent));
        Assert.assertTrue((boolean)parent.contains(otherChild));
        Assert.assertTrue((boolean)parent.remove(otherChild));
    }
}

