/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.IsValidOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.TopologyValidationError;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class ValidSelfTouchingRingTest
extends GeometryTestCase {
    public ValidSelfTouchingRingTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ValidSelfTouchingRingTest.class);
    }

    public void testShellAndHoleSelfTouch() {
        String wkt = "POLYGON ((0 0, 0 340, 320 340, 320 0, 120 0, 180 100, 60 100, 120 0, 0 0),   (80 300, 80 180, 200 180, 200 240, 280 200, 280 280, 200 240, 200 300, 80 300))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, false);
    }

    public void testShellTouchAtHole() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 50 50, 80 50, 80 80, 10 10, 10 90), (40 80, 20 60, 50 50, 40 80))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, false);
    }

    public void testShellTouchInChain() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90, 20 70, 30 70, 30 50, 40 50, 40 70, 30 70, 30 80, 10 90))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, false);
    }

    public void testHoleTouchInChain() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 20, 80 20, 80 50, 70 20, 70 50, 60 20, 60 50, 50 20, 50 50, 40 20, 40 50, 30 20, 30 50, 20 20))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, false);
    }

    public void testShellHoleAndHoleHoleTouch() {
        String wkt = "POLYGON ((0 0, 0 340, 320 340, 320 0, 120 0, 0 0),   (120 0, 180 100, 60 100, 120 0),   (80 300, 80 180, 200 180, 200 240, 200 300, 80 300),  (200 240, 280 200, 280 280, 200 240))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, true);
    }

    public void testShellSelfTouchHoleOverlappingHole() {
        String wkt = "POLYGON ((0 0, 220 0, 220 200, 120 200, 140 100, 80 100, 120 200, 0 200, 0 0),   (200 80, 20 80, 120 200, 200 80))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testDisconnectedInteriorShellSelfTouchAtNonVertex() {
        String wkt = "POLYGON ((40 180, 40 60, 240 60, 240 180, 140 60, 40 180))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testDisconnectedInteriorShellSelfTouchAtVertex() {
        String wkt = "POLYGON ((20 20, 20 100, 140 100, 140 180, 260 180, 260 100, 140 100, 140 20, 20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testDisconnectedInteriorShellTouchAtVertices() {
        String wkt = "POLYGON ((10 10, 90 10, 50 50, 80 70, 90 10, 90 90, 10 90, 10 10, 50 50, 20 70, 10 10))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testDisconnectedInteriorHoleTouch() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 20, 20 80, 80 80, 80 30, 30 30, 70 40, 70 70, 20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testShellCross() {
        String wkt = "POLYGON ((20 20, 120 20, 120 220, 240 220, 240 120, 20 120, 20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testShellCrossAndSTR() {
        String wkt = "POLYGON ((20 20, 120 20, 120 220, 180 220, 140 160, 200 160, 180 220, 240 220, 240 120, 20 120,  20 20))";
        this.checkIsValidSTR(wkt, false);
        this.checkIsValidOGC(wkt, false);
    }

    public void testExvertedHoleStarTouchHoleCycle() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 80, 50 30, 80 80, 80 30, 20 30, 20 80), (40 70, 50 70, 50 30, 40 70), (40 20, 60 20, 50 30, 40 20), (40 80, 20 80, 40 70, 40 80))";
        this.checkInvalidSTR(wkt, 4);
    }

    public void testExvertedHoleStarTouch() {
        String wkt = "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 80, 50 30, 80 80, 80 30, 20 30, 20 80), (40 70, 50 70, 50 30, 40 70), (40 20, 60 20, 50 30, 40 20))";
        this.checkIsValidSTR(wkt, true);
        this.checkIsValidOGC(wkt, false);
    }

    private void checkInvalidSTR(String wkt, int exepctedErrType) {
        Geometry geom = this.read(wkt);
        IsValidOp validOp = new IsValidOp(geom);
        validOp.setSelfTouchingRingFormingHoleValid(true);
        TopologyValidationError err = validOp.getValidationError();
        ValidSelfTouchingRingTest.assertEquals((int)exepctedErrType, (int)err.getErrorType());
    }

    private void checkIsValidOGC(String wkt, boolean expected) {
        Geometry geom = this.read(wkt);
        IsValidOp validator = new IsValidOp(geom);
        boolean isValid = validator.isValid();
        ValidSelfTouchingRingTest.assertTrue((isValid == expected ? 1 : 0) != 0);
    }

    private void checkIsValidSTR(String wkt, boolean expected) {
        Geometry geom = this.read(wkt);
        IsValidOp validator = new IsValidOp(geom);
        validator.setSelfTouchingRingFormingHoleValid(true);
        boolean isValid = validator.isValid();
        ValidSelfTouchingRingTest.assertTrue((isValid == expected ? 1 : 0) != 0);
    }
}

