/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.math;

import com.hazelcast.shaded.org.locationtech.jts.math.DD;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DDComputeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(DDComputeTest.class);
    }

    public DDComputeTest(String name) {
        super(name);
    }

    public void testEByTaylorSeries() {
        DD testE = this.computeEByTaylorSeries();
        double err = Math.abs(testE.subtract(DD.E).doubleValue());
        DDComputeTest.assertTrue((err < 7.888609052210112E-31 ? 1 : 0) != 0);
    }

    private DD computeEByTaylorSeries() {
        DD s = DD.valueOf((double)2.0);
        DD t = DD.valueOf((double)1.0);
        double n = 1.0;
        int i = 0;
        while (t.doubleValue() > 1.23259516440783E-32) {
            ++i;
            t = t.divide(DD.valueOf((double)(n += 1.0)));
            s = s.add(t);
        }
        return s;
    }

    public void testPiByMachin() {
        DD testE = this.computePiByMachin();
        double err = Math.abs(testE.subtract(DD.PI).doubleValue());
        DDComputeTest.assertTrue((err < 9.86076131526264E-32 ? 1 : 0) != 0);
    }

    private DD computePiByMachin() {
        DD t1 = DD.valueOf((double)1.0).divide(DD.valueOf((double)5.0));
        DD t2 = DD.valueOf((double)1.0).divide(DD.valueOf((double)239.0));
        DD pi4 = DD.valueOf((double)4.0).multiply(this.arctan(t1)).subtract(this.arctan(t2));
        DD pi = DD.valueOf((double)4.0).multiply(pi4);
        return pi;
    }

    private DD arctan(DD x) {
        DD t = x;
        DD t2 = t.sqr();
        DD at = new DD(0.0);
        DD two = new DD(2.0);
        int k = 0;
        DD d = new DD(1.0);
        int sign = 1;
        while (t.doubleValue() > 1.23259516440783E-32) {
            ++k;
            at = sign < 0 ? at.subtract(t.divide(d)) : at.add(t.divide(d));
            d = d.add(two);
            t = t.multiply(t2);
            sign = -sign;
        }
        return at;
    }
}

