/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.hprtree;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.SpatialIndex;
import com.hazelcast.shaded.org.locationtech.jts.index.SpatialIndexTester;
import com.hazelcast.shaded.org.locationtech.jts.index.hprtree.HPRtree;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class HPRtreeTest
extends TestCase {
    private GeometryFactory factory = new GeometryFactory();

    public HPRtreeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{HPRtreeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testEmptyTreeUsingListQuery() {
        HPRtree tree = new HPRtree();
        List list = tree.query(new Envelope(0.0, 0.0, 1.0, 1.0));
        HPRtreeTest.assertTrue((boolean)list.isEmpty());
    }

    public void testEmptyTreeUsingItemVisitorQuery() {
        HPRtree tree = new HPRtree(0);
        tree.query(new Envelope(0.0, 0.0, 1.0, 1.0), new ItemVisitor(){

            public void visitItem(Object item) {
                TestCase.assertTrue((String)"Should never reach here", (boolean)true);
            }
        });
    }

    public void testSpatialIndex() throws Exception {
        SpatialIndexTester tester = new SpatialIndexTester();
        tester.setSpatialIndex((SpatialIndex)new HPRtree());
        tester.init();
        tester.run();
        HPRtreeTest.assertTrue((boolean)tester.isSuccess());
    }

    public void testDisallowedInserts() {
        HPRtree t = new HPRtree(3);
        t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
        t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
        t.query(new Envelope());
        try {
            t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
            HPRtreeTest.assertTrue((boolean)false);
        }
        catch (IllegalStateException e) {
            HPRtreeTest.assertTrue((boolean)true);
        }
    }

    public void testQuery() throws Throwable {
        ArrayList<LineString> geometries = new ArrayList<LineString>();
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)}));
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(30.0, 30.0)}));
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(30.0, 30.0)}));
        HPRtree t = new HPRtree(3);
        for (Geometry geometry : geometries) {
            t.insert(geometry.getEnvelopeInternal(), new Object());
        }
        t.query(new Envelope(5.0, 6.0, 5.0, 6.0));
        HPRtreeTest.assertEquals((int)1, (int)t.query(new Envelope(5.0, 6.0, 5.0, 6.0)).size());
        HPRtreeTest.assertEquals((int)0, (int)t.query(new Envelope(20.0, 30.0, 0.0, 10.0)).size());
        HPRtreeTest.assertEquals((int)2, (int)t.query(new Envelope(25.0, 26.0, 25.0, 26.0)).size());
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(0.0, 100.0, 0.0, 100.0)).size());
    }

    public void testQuery3() throws Throwable {
        HPRtree t = new HPRtree();
        for (int i = 0; i < 3; ++i) {
            t.insert(new Envelope((double)i, (double)(i + 1), (double)i, (double)(i + 1)), (Object)i);
        }
        t.query(new Envelope(0.0, 1.0, 0.0, 1.0));
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(1.0, 2.0, 1.0, 2.0)).size());
        HPRtreeTest.assertEquals((int)0, (int)t.query(new Envelope(9.0, 10.0, 9.0, 10.0)).size());
    }

    public void testQuery10() throws Throwable {
        HPRtree t = new HPRtree();
        for (int i = 0; i < 10; ++i) {
            t.insert(new Envelope((double)i, (double)(i + 1), (double)i, (double)(i + 1)), (Object)i);
        }
        t.query(new Envelope(0.0, 1.0, 0.0, 1.0));
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(5.0, 6.0, 5.0, 6.0)).size());
        HPRtreeTest.assertEquals((int)2, (int)t.query(new Envelope(9.0, 10.0, 9.0, 10.0)).size());
        HPRtreeTest.assertEquals((int)0, (int)t.query(new Envelope(25.0, 26.0, 25.0, 26.0)).size());
        HPRtreeTest.assertEquals((int)10, (int)t.query(new Envelope(0.0, 10.0, 0.0, 10.0)).size());
    }

    public void testQuery100() throws Throwable {
        this.queryGrid(100, new HPRtree());
    }

    public void testQuery100cap8() throws Throwable {
        this.queryGrid(100, new HPRtree(8));
    }

    public void testQuery100cap2() throws Throwable {
        this.queryGrid(100, new HPRtree(2));
    }

    private void queryGrid(int size, HPRtree t) {
        for (int i = 0; i < size; ++i) {
            t.insert(new Envelope((double)i, (double)(i + 1), (double)i, (double)(i + 1)), (Object)i);
        }
        t.query(new Envelope(0.0, 1.0, 0.0, 1.0));
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(5.0, 6.0, 5.0, 6.0)).size());
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(9.0, 10.0, 9.0, 10.0)).size());
        HPRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(25.0, 26.0, 25.0, 26.0)).size());
        HPRtreeTest.assertEquals((int)11, (int)t.query(new Envelope(0.0, 10.0, 0.0, 10.0)).size());
    }
}

