/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom.impl;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public abstract class CoordinateSequenceTestBase
extends TestCase {
    public static final int SIZE = 100;

    public static void main(String[] args) {
        TestRunner.run(CoordinateSequenceTestBase.class);
    }

    public CoordinateSequenceTestBase(String name) {
        super(name);
    }

    abstract CoordinateSequenceFactory getCSFactory();

    public void testZeroLength() {
        CoordinateSequence seq = this.getCSFactory().create(0, 3);
        CoordinateSequenceTestBase.assertTrue((seq.size() == 0 ? 1 : 0) != 0);
        CoordinateSequence seq2 = this.getCSFactory().create((Coordinate[])null);
        CoordinateSequenceTestBase.assertTrue((seq2.size() == 0 ? 1 : 0) != 0);
    }

    public void testCreateBySizeAndModify() {
        Coordinate[] coords = this.createArray(100);
        CoordinateSequence seq = this.getCSFactory().create(100, 3);
        for (int i = 0; i < seq.size(); ++i) {
            seq.setOrdinate(i, 0, coords[i].x);
            seq.setOrdinate(i, 1, coords[i].y);
            seq.setOrdinate(i, 2, coords[i].getZ());
        }
        CoordinateSequenceTestBase.assertTrue((boolean)this.isEqual(seq, coords));
    }

    public void test2DZOrdinate() {
        int i;
        Coordinate[] coords = this.createArray(100);
        CoordinateSequence seq = this.getCSFactory().create(100, 2);
        for (i = 0; i < seq.size(); ++i) {
            seq.setOrdinate(i, 0, coords[i].x);
            seq.setOrdinate(i, 1, coords[i].y);
        }
        for (i = 0; i < seq.size(); ++i) {
            Coordinate p = seq.getCoordinate(i);
            CoordinateSequenceTestBase.assertTrue((boolean)Double.isNaN(p.getZ()));
        }
    }

    public void testCreateByInit() {
        Coordinate[] coords = this.createArray(100);
        CoordinateSequence seq = this.getCSFactory().create(coords);
        CoordinateSequenceTestBase.assertTrue((boolean)this.isEqual(seq, coords));
    }

    public void testCreateByInitAndCopy() {
        Coordinate[] coords = this.createArray(100);
        CoordinateSequence seq = this.getCSFactory().create(coords);
        CoordinateSequence seq2 = this.getCSFactory().create(seq);
        CoordinateSequenceTestBase.assertTrue((boolean)this.isEqual(seq2, coords));
    }

    public void testSerializable() throws IOException, ClassNotFoundException {
        Coordinate[] coords = this.createArray(100);
        CoordinateSequence seq = this.getCSFactory().create(coords);
        byte[] data = CoordinateSequenceTestBase.serialize(seq);
        CoordinateSequence seq2 = CoordinateSequenceTestBase.deserialize(data);
        CoordinateSequenceTestBase.assertTrue((boolean)this.isEqual(seq2, coords));
    }

    private static byte[] serialize(CoordinateSequence seq) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(seq);
        oos.close();
        return bos.toByteArray();
    }

    private static CoordinateSequence deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return (CoordinateSequence)o;
    }

    Coordinate[] createArray(int size) {
        Coordinate[] coords = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            double base = 2.0;
            coords[i] = new Coordinate(base, base + 1.0, base + 2.0);
        }
        return coords;
    }

    boolean isAllCoordsEqual(CoordinateSequence seq, Coordinate coord) {
        for (int i = 0; i < seq.size(); ++i) {
            if (!coord.equals((Object)seq.getCoordinate(i))) {
                return false;
            }
            if (coord.x != seq.getOrdinate(i, 0)) {
                return false;
            }
            if (coord.y != seq.getOrdinate(i, 1)) {
                return false;
            }
            if (seq.hasZ() && coord.getZ() != seq.getZ(i)) {
                return false;
            }
            if (seq.hasM() && coord.getM() != seq.getM(i)) {
                return false;
            }
            if (seq.getDimension() > 2 && coord.getOrdinate(2) != seq.getOrdinate(i, 2)) {
                return false;
            }
            if (seq.getDimension() <= 3 || coord.getOrdinate(3) == seq.getOrdinate(i, 3)) continue;
            return false;
        }
        return true;
    }

    boolean isEqual(CoordinateSequence seq, Coordinate[] coords) {
        if (seq.size() != coords.length) {
            return false;
        }
        Coordinate p = seq.createCoordinate();
        for (int i = 0; i < seq.size(); ++i) {
            if (!coords[i].equals((Object)seq.getCoordinate(i))) {
                return false;
            }
            if (!this.isEqual(coords[i].x, seq.getX(i))) {
                return false;
            }
            if (!this.isEqual(coords[i].y, seq.getY(i))) {
                return false;
            }
            if (seq.hasZ() && !this.isEqual(coords[i].getZ(), seq.getZ(i))) {
                return false;
            }
            if (seq.hasM() && !this.isEqual(coords[i].getM(), seq.getM(i))) {
                return false;
            }
            if (!this.isEqual(coords[i].x, seq.getOrdinate(i, 0))) {
                return false;
            }
            if (!this.isEqual(coords[i].y, seq.getOrdinate(i, 1))) {
                return false;
            }
            if (seq.getDimension() > 2 && !this.isEqual(coords[i].getOrdinate(2), seq.getOrdinate(i, 2))) {
                return false;
            }
            if (seq.getDimension() > 3 && !this.isEqual(coords[i].getOrdinate(3), seq.getOrdinate(i, 3))) {
                return false;
            }
            seq.getCoordinate(i, p);
            if (!this.isEqual(coords[i].x, p.x)) {
                return false;
            }
            if (!this.isEqual(coords[i].y, p.y)) {
                return false;
            }
            if (seq.hasZ() && !this.isEqual(coords[i].getZ(), p.getZ())) {
                return false;
            }
            if (!seq.hasM() || this.isEqual(coords[i].getM(), p.getM())) continue;
            return false;
        }
        return true;
    }

    boolean isEqual(double expected, double actual) {
        return expected == actual || Double.isNaN(expected) && Double.isNaN(actual);
    }
}

