/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PrecisionModelTest
extends TestCase {
    public PrecisionModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PrecisionModelTest.class);
    }

    public void testParameterlessConstructor() {
        PrecisionModel p = new PrecisionModel();
        PrecisionModelTest.assertEquals((double)0.0, (double)p.getScale(), (double)1.0E-10);
    }

    public void testGetMaximumSignificantDigits() {
        PrecisionModelTest.assertEquals((int)16, (int)new PrecisionModel(PrecisionModel.FLOATING).getMaximumSignificantDigits());
        PrecisionModelTest.assertEquals((int)6, (int)new PrecisionModel(PrecisionModel.FLOATING_SINGLE).getMaximumSignificantDigits());
        PrecisionModelTest.assertEquals((int)1, (int)new PrecisionModel(PrecisionModel.FIXED).getMaximumSignificantDigits());
        PrecisionModelTest.assertEquals((int)4, (int)new PrecisionModel(1000.0).getMaximumSignificantDigits());
    }

    public void testMakePrecise() {
        PrecisionModel pm_10 = new PrecisionModel(0.1);
        this.preciseCoordinateTester(pm_10, 1200.4, 1240.4, 1200.0, 1240.0);
        this.preciseCoordinateTester(pm_10, 1209.4, 1240.4, 1210.0, 1240.0);
    }

    private void preciseCoordinateTester(PrecisionModel pm, double x1, double y1, double x2, double y2) {
        Coordinate p = new Coordinate(x1, y1);
        pm.makePrecise(p);
        Coordinate pPrecise = new Coordinate(x2, y2);
        PrecisionModelTest.assertTrue((boolean)p.equals2D(pPrecise));
    }
}

