/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class IsRectangleTest
extends TestCase {
    WKTReader rdr = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(IsRectangleTest.class);
    }

    public IsRectangleTest(String name) {
        super(name);
    }

    public void testValidRectangle() throws Exception {
        IsRectangleTest.assertTrue((boolean)this.isRectangle("POLYGON ((0 0, 0 100, 100 100, 100 0, 0 0))"));
    }

    public void testValidRectangle2() throws Exception {
        IsRectangleTest.assertTrue((boolean)this.isRectangle("POLYGON ((0 0, 0 200, 100 200, 100 0, 0 0))"));
    }

    public void testRectangleWithHole() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("POLYGON ((0 0, 0 100, 100 100, 100 0, 0 0), (10 10, 10 90, 90 90, 90 10, 10 10) ))") ? 1 : 0) != 0);
    }

    public void testNotRectilinear() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("POLYGON ((0 0, 0 100, 99 100, 100 0, 0 0))") ? 1 : 0) != 0);
    }

    public void testTooManyPoints() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("POLYGON ((0 0, 0 100, 100 50, 100 100, 100 0, 0 0))") ? 1 : 0) != 0);
    }

    public void testTooFewPoints() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("POLYGON ((0 0, 0 100, 100 0, 0 0))") ? 1 : 0) != 0);
    }

    public void testRectangularLinestring() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("LINESTRING (0 0, 0 100, 100 100, 100 0, 0 0)") ? 1 : 0) != 0);
    }

    public void testPointsInWrongOrder() throws Exception {
        IsRectangleTest.assertTrue((!this.isRectangle("POLYGON ((0 0, 0 100, 100 0, 100 100, 0 0))") ? 1 : 0) != 0);
    }

    public boolean isRectangle(String wkt) throws Exception {
        Geometry a = this.rdr.read(wkt);
        return a.isRectangle();
    }
}

