/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;
import test.jts.GeometryTestData;

public class GeometryCopyTest
extends GeometryTestCase {
    public static void main(String[] args) throws Exception {
        TestRunner.run(GeometryCopyTest.class);
    }

    public GeometryCopyTest(String name) {
        super(name);
    }

    public void testCopy() {
        this.checkCopy(this.read(GeometryTestData.WKT_POINT));
        this.checkCopy(this.read(GeometryTestData.WKT_LINESTRING));
        this.checkCopy(this.read(GeometryTestData.WKT_LINEARRING));
        this.checkCopy(this.read(GeometryTestData.WKT_POLY));
        this.checkCopy(this.read(GeometryTestData.WKT_MULTIPOINT));
        this.checkCopy(this.read(GeometryTestData.WKT_MULTILINESTRING));
        this.checkCopy(this.read(GeometryTestData.WKT_MULTIPOLYGON));
        this.checkCopy(this.read(GeometryTestData.WKT_GC));
    }

    private void checkCopy(Geometry g) {
        int SRID = 123;
        g.setSRID(SRID);
        Integer DATA = new Integer(999);
        g.setUserData((Object)DATA);
        Geometry copy = g.copy();
        GeometryCopyTest.assertEquals((int)g.getSRID(), (int)copy.getSRID());
        GeometryCopyTest.assertEquals((Object)g.getUserData(), (Object)copy.getUserData());
        GeometryCopyTest.assertTrue((boolean)g.equalsExact(copy));
    }
}

