/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class AreaLengthTest
extends TestCase {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(AreaLengthTest.class);
    }

    public AreaLengthTest(String name) {
        super(name);
    }

    public void testLength() throws Exception {
        this.checkLength("MULTIPOINT (220 140, 180 280)", 0.0);
        this.checkLength("LINESTRING (220 140, 180 280)", 145.6021977);
        this.checkLength("LINESTRING (0 0, 100 100)", 141.4213562373095);
        this.checkLength("POLYGON ((20 20, 40 20, 40 40, 20 40, 20 20))", 80.0);
        this.checkLength("POLYGON ((20 20, 40 20, 40 40, 20 40, 20 20), (25 35, 35 35, 35 25, 25 25, 25 35))", 120.0);
    }

    public void testArea() throws Exception {
        this.checkArea("MULTIPOINT (220 140, 180 280)", 0.0);
        this.checkArea("LINESTRING (220 140, 180 280)", 0.0);
        this.checkArea("POLYGON ((20 20, 40 20, 40 40, 20 40, 20 20))", 400.0);
        this.checkArea("POLYGON ((20 20, 40 20, 40 40, 20 40, 20 20), (25 35, 35 35, 35 25, 25 25, 25 35))", 300.0);
    }

    public void checkLength(String wkt, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        double len = g.getLength();
        AreaLengthTest.assertEquals((double)expectedValue, (double)len, (double)1.0E-5);
    }

    public void checkArea(String wkt, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        AreaLengthTest.assertEquals((double)expectedValue, (double)g.getArea(), (double)1.0E-5);
    }
}

