/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.DefaultTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.util.NumberTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.util.TransformerMap;
import org.junit.Assert;
import org.junit.Test;

public class TransformerMapTest {
    @Test
    public void testPutTransformer() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertEquals((Object)expected, (Object)map.getTransformer(TransformerMapTest.class));
    }

    @Test
    public void testContainsClass() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.containsClass(TransformerMapTest.class));
    }

    @Test
    public void testContainsTransformer() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.containsTransformer((NumberTransformer)expected));
    }

    @Test
    public void testRemoveTransformer() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.containsClass(TransformerMapTest.class));
        Assert.assertTrue((boolean)map.containsTransformer((NumberTransformer)expected));
        map.removeTransformer(TransformerMapTest.class);
        Assert.assertFalse((boolean)map.containsClass(TransformerMapTest.class));
        Assert.assertFalse((boolean)map.containsTransformer((NumberTransformer)expected));
    }

    @Test
    public void testClear() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.containsClass(TransformerMapTest.class));
        map.clear();
        Assert.assertFalse((boolean)map.containsClass(TransformerMapTest.class));
    }

    @Test
    public void testClasses() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.classes().contains(TransformerMapTest.class));
    }

    @Test
    public void testTransformers() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertTrue((boolean)map.transformers().contains(expected));
    }

    @Test
    public void testSerial() {
        DefaultTransformer expected = new DefaultTransformer();
        TransformerMap map = new TransformerMap();
        map.putTransformer(TransformerMapTest.class, (NumberTransformer)expected);
        Assert.assertEquals((Object)map, (Object)TestUtils.serializeAndRecover(map));
    }
}

