/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformIntegerDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.util.DoubleArrayAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import com.hazelcast.shaded.org.apache.commons.math3.util.ResizableDoubleArray;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResizableDoubleArrayTest
extends DoubleArrayAbstractTest {
    @After
    public void tearDown() throws Exception {
        this.da = null;
        this.ra = null;
    }

    @Before
    public void setUp() throws Exception {
        this.da = new ResizableDoubleArray();
        this.ra = new ResizableDoubleArray();
    }

    @Test
    public void testConstructors() {
        float defaultExpansionFactor = 2.0f;
        double defaultContractionCriteria = 2.5;
        int defaultMode = 0;
        ResizableDoubleArray testDa = new ResizableDoubleArray(2);
        Assert.assertEquals((long)0L, (long)testDa.getNumElements());
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        Assert.assertEquals((float)defaultExpansionFactor, (float)testDa.getExpansionFactor(), (float)0.0f);
        Assert.assertEquals((double)defaultContractionCriteria, (double)testDa.getContractionCriterion(), (double)0.0);
        Assert.assertEquals((long)defaultMode, (long)testDa.getExpansionMode());
        try {
            this.da = new ResizableDoubleArray(-1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        testDa = new ResizableDoubleArray((double[])null);
        Assert.assertEquals((long)0L, (long)testDa.getNumElements());
        double[] initialArray = new double[]{0.0, 1.0, 2.0};
        testDa = new ResizableDoubleArray(initialArray);
        Assert.assertEquals((long)3L, (long)testDa.getNumElements());
        testDa = new ResizableDoubleArray(2, 2.0);
        Assert.assertEquals((long)0L, (long)testDa.getNumElements());
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        Assert.assertEquals((float)defaultExpansionFactor, (float)testDa.getExpansionFactor(), (float)0.0f);
        Assert.assertEquals((double)defaultContractionCriteria, (double)testDa.getContractionCriterion(), (double)0.0);
        Assert.assertEquals((long)defaultMode, (long)testDa.getExpansionMode());
        try {
            this.da = new ResizableDoubleArray(2, 0.5);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        testDa = new ResizableDoubleArray(2, 3.0);
        Assert.assertEquals((float)3.0f, (float)testDa.getExpansionFactor(), (float)0.0f);
        Assert.assertEquals((double)3.5, (double)testDa.getContractionCriterion(), (double)0.0);
        testDa = new ResizableDoubleArray(2, 2.0, 3.0);
        Assert.assertEquals((long)0L, (long)testDa.getNumElements());
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        Assert.assertEquals((float)defaultExpansionFactor, (float)testDa.getExpansionFactor(), (float)0.0f);
        Assert.assertEquals((double)3.0, (double)testDa.getContractionCriterion(), (double)0.0);
        Assert.assertEquals((long)defaultMode, (long)testDa.getExpansionMode());
        try {
            this.da = new ResizableDoubleArray(2, 2.0, 1.5);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        testDa = new ResizableDoubleArray(2, 2.0, 3.0, ResizableDoubleArray.ExpansionMode.ADDITIVE, new double[0]);
        Assert.assertEquals((long)0L, (long)testDa.getNumElements());
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        Assert.assertEquals((float)defaultExpansionFactor, (float)testDa.getExpansionFactor(), (float)0.0f);
        Assert.assertEquals((double)3.0, (double)testDa.getContractionCriterion(), (double)0.0);
        Assert.assertEquals((long)1L, (long)testDa.getExpansionMode());
        try {
            this.da = new ResizableDoubleArray(2, 2.0f, 2.5f, -1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        testDa = new ResizableDoubleArray(2, 2.0, 3.0, ResizableDoubleArray.ExpansionMode.ADDITIVE, new double[0]);
        testDa.addElement(2.0);
        testDa.addElement(3.2);
        ResizableDoubleArray copyDa = new ResizableDoubleArray(testDa);
        Assert.assertEquals((Object)copyDa, (Object)testDa);
        Assert.assertEquals((Object)testDa, (Object)copyDa);
        double[] values = new double[]{1.0};
        testDa = new ResizableDoubleArray(values);
        Assert.assertArrayEquals((double[])values, (double[])testDa.getElements(), (double)0.0);
        Assert.assertEquals((long)1L, (long)testDa.getNumElements());
        Assert.assertEquals((double)1.0, (double)testDa.getElement(0), (double)0.0);
    }

    @Test
    public void testSetElementArbitraryExpansion1() {
        this.da.addElement(2.0);
        this.da.addElement(4.0);
        this.da.addElement(6.0);
        this.da.setElement(1, 3.0);
        this.da.setElement(1000, 3.4);
        Assert.assertEquals((String)"The number of elements should now be 1001, it isn't", (long)this.da.getNumElements(), (long)1001L);
        Assert.assertEquals((String)"Uninitialized Elements are default value of 0.0, index 766 wasn't", (double)0.0, (double)this.da.getElement(760), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"The 1000th index should be 3.4, it isn't", (double)3.4, (double)this.da.getElement(1000), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"The 0th index should be 2.0, it isn't", (double)2.0, (double)this.da.getElement(0), (double)Double.MIN_VALUE);
    }

    @Test
    public void testSetElementArbitraryExpansion2() {
        this.da.addElement(2.0);
        this.da.addElement(4.0);
        this.da.addElement(6.0);
        Assert.assertEquals((long)16L, (long)((ResizableDoubleArray)this.da).getCapacity());
        Assert.assertEquals((long)3L, (long)this.da.getNumElements());
        this.da.setElement(3, 7.0);
        Assert.assertEquals((long)16L, (long)((ResizableDoubleArray)this.da).getCapacity());
        Assert.assertEquals((long)4L, (long)this.da.getNumElements());
        this.da.setElement(10, 10.0);
        Assert.assertEquals((long)16L, (long)((ResizableDoubleArray)this.da).getCapacity());
        Assert.assertEquals((long)11L, (long)this.da.getNumElements());
        this.da.setElement(9, 10.0);
        Assert.assertEquals((long)16L, (long)((ResizableDoubleArray)this.da).getCapacity());
        Assert.assertEquals((long)11L, (long)this.da.getNumElements());
        try {
            this.da.setElement(-2, 3.0);
            Assert.fail((String)"Expecting ArrayIndexOutOfBoundsException for negative index");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        ResizableDoubleArray testDa = new ResizableDoubleArray(2, 2.0, 3.0, ResizableDoubleArray.ExpansionMode.ADDITIVE, new double[0]);
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        testDa.addElement(1.0);
        testDa.addElement(1.0);
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        testDa.addElement(1.0);
        Assert.assertEquals((long)4L, (long)testDa.getCapacity());
    }

    @Test
    public void testAdd1000() {
        super.testAdd1000();
        Assert.assertEquals((String)"Internal Storage length should be 1024 if we started out with initial capacity of 16 and an expansion factor of 2.0", (long)1024L, (long)((ResizableDoubleArray)this.da).getCapacity());
    }

    @Test
    public void testAddElements() {
        ResizableDoubleArray testDa = new ResizableDoubleArray();
        testDa.addElements(new double[]{4.0, 5.0, 6.0});
        Assert.assertEquals((float)3.0f, (float)testDa.getNumElements(), (float)0.0f);
        Assert.assertEquals((double)4.0, (double)testDa.getElement(0), (double)0.0);
        Assert.assertEquals((double)5.0, (double)testDa.getElement(1), (double)0.0);
        Assert.assertEquals((double)6.0, (double)testDa.getElement(2), (double)0.0);
        testDa.addElements(new double[]{4.0, 5.0, 6.0});
        Assert.assertEquals((long)6L, (long)testDa.getNumElements());
        testDa = new ResizableDoubleArray(2, 2.0, 2.5, ResizableDoubleArray.ExpansionMode.ADDITIVE, new double[0]);
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        testDa.addElements(new double[]{1.0});
        testDa.addElements(new double[]{2.0});
        testDa.addElements(new double[]{3.0});
        Assert.assertEquals((double)1.0, (double)testDa.getElement(0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)testDa.getElement(1), (double)0.0);
        Assert.assertEquals((double)3.0, (double)testDa.getElement(2), (double)0.0);
        Assert.assertEquals((long)4L, (long)testDa.getCapacity());
        Assert.assertEquals((long)3L, (long)testDa.getNumElements());
    }

    @Test
    public void testAddElementRolling() {
        super.testAddElementRolling();
        this.da.clear();
        this.da.addElement(1.0);
        this.da.addElement(2.0);
        this.da.addElementRolling(3.0);
        Assert.assertEquals((double)3.0, (double)this.da.getElement(1), (double)0.0);
        this.da.addElementRolling(4.0);
        Assert.assertEquals((double)3.0, (double)this.da.getElement(0), (double)0.0);
        Assert.assertEquals((double)4.0, (double)this.da.getElement(1), (double)0.0);
        this.da.addElement(5.0);
        Assert.assertEquals((double)5.0, (double)this.da.getElement(2), (double)0.0);
        this.da.addElementRolling(6.0);
        Assert.assertEquals((double)4.0, (double)this.da.getElement(0), (double)0.0);
        Assert.assertEquals((double)5.0, (double)this.da.getElement(1), (double)0.0);
        Assert.assertEquals((double)6.0, (double)this.da.getElement(2), (double)0.0);
        ResizableDoubleArray testDa = new ResizableDoubleArray(2, 2.0, 2.5, ResizableDoubleArray.ExpansionMode.ADDITIVE, new double[0]);
        Assert.assertEquals((long)2L, (long)testDa.getCapacity());
        testDa.addElement(1.0);
        testDa.addElement(2.0);
        testDa.addElement(3.0);
        Assert.assertEquals((double)1.0, (double)testDa.getElement(0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)testDa.getElement(1), (double)0.0);
        Assert.assertEquals((double)3.0, (double)testDa.getElement(2), (double)0.0);
        Assert.assertEquals((long)4L, (long)testDa.getCapacity());
        Assert.assertEquals((long)3L, (long)testDa.getNumElements());
        testDa.addElementRolling(4.0);
        Assert.assertEquals((double)2.0, (double)testDa.getElement(0), (double)0.0);
        Assert.assertEquals((double)3.0, (double)testDa.getElement(1), (double)0.0);
        Assert.assertEquals((double)4.0, (double)testDa.getElement(2), (double)0.0);
        Assert.assertEquals((long)4L, (long)testDa.getCapacity());
        Assert.assertEquals((long)3L, (long)testDa.getNumElements());
        testDa.addElementRolling(5.0);
        Assert.assertEquals((double)3.0, (double)testDa.getElement(0), (double)0.0);
        Assert.assertEquals((double)4.0, (double)testDa.getElement(1), (double)0.0);
        Assert.assertEquals((double)5.0, (double)testDa.getElement(2), (double)0.0);
        Assert.assertEquals((long)4L, (long)testDa.getCapacity());
        Assert.assertEquals((long)3L, (long)testDa.getNumElements());
        try {
            testDa.getElement(4);
            Assert.fail((String)"Expecting ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            testDa.getElement(-1);
            Assert.fail((String)"Expecting ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSetNumberOfElements() {
        this.da.addElement(1.0);
        this.da.addElement(1.0);
        this.da.addElement(1.0);
        this.da.addElement(1.0);
        this.da.addElement(1.0);
        this.da.addElement(1.0);
        Assert.assertEquals((String)"Number of elements should equal 6", (long)this.da.getNumElements(), (long)6L);
        ((ResizableDoubleArray)this.da).setNumElements(3);
        Assert.assertEquals((String)"Number of elements should equal 3", (long)this.da.getNumElements(), (long)3L);
        try {
            ((ResizableDoubleArray)this.da).setNumElements(-3);
            Assert.fail((String)"Setting number of elements to negative should've thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((ResizableDoubleArray)this.da).setNumElements(1024);
        Assert.assertEquals((String)"Number of elements should now be 1024", (long)this.da.getNumElements(), (long)1024L);
        Assert.assertEquals((String)"Element 453 should be a default double", (double)this.da.getElement(453), (double)0.0, (double)Double.MIN_VALUE);
    }

    @Test
    public void testWithInitialCapacity() {
        ResizableDoubleArray eDA2 = new ResizableDoubleArray(2);
        Assert.assertEquals((String)"Initial number of elements should be 0", (long)0L, (long)eDA2.getNumElements());
        UniformIntegerDistribution randomData = new UniformIntegerDistribution(100, 1000);
        int iterations = randomData.sample();
        for (int i = 0; i < iterations; ++i) {
            eDA2.addElement((double)i);
        }
        Assert.assertEquals((String)("Number of elements should be equal to " + iterations), (long)iterations, (long)eDA2.getNumElements());
        eDA2.addElement(2.0);
        Assert.assertEquals((String)("Number of elements should be equals to " + (iterations + 1)), (long)(iterations + 1), (long)eDA2.getNumElements());
    }

    @Test
    public void testWithInitialCapacityAndExpansionFactor() {
        ResizableDoubleArray eDA3 = new ResizableDoubleArray(3, 3.0, 3.5);
        Assert.assertEquals((String)"Initial number of elements should be 0", (long)0L, (long)eDA3.getNumElements());
        UniformIntegerDistribution randomData = new UniformIntegerDistribution(100, 3000);
        int iterations = randomData.sample();
        for (int i = 0; i < iterations; ++i) {
            eDA3.addElement((double)i);
        }
        Assert.assertEquals((String)("Number of elements should be equal to " + iterations), (long)iterations, (long)eDA3.getNumElements());
        eDA3.addElement(2.0);
        Assert.assertEquals((String)("Number of elements should be equals to " + (iterations + 1)), (long)(iterations + 1), (long)eDA3.getNumElements());
        Assert.assertEquals((String)"Expansion factor should equal 3.0", (double)3.0, (double)eDA3.getExpansionFactor(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testDiscard() {
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        Assert.assertEquals((String)"Number of elements should be 11", (long)11L, (long)this.da.getNumElements());
        ((ResizableDoubleArray)this.da).discardFrontElements(5);
        Assert.assertEquals((String)"Number of elements should be 6", (long)6L, (long)this.da.getNumElements());
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        Assert.assertEquals((String)"Number of elements should be 10", (long)10L, (long)this.da.getNumElements());
        ((ResizableDoubleArray)this.da).discardMostRecentElements(2);
        Assert.assertEquals((String)"Number of elements should be 8", (long)8L, (long)this.da.getNumElements());
        try {
            ((ResizableDoubleArray)this.da).discardFrontElements(-1);
            Assert.fail((String)"Trying to discard a negative number of element is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ResizableDoubleArray)this.da).discardMostRecentElements(-1);
            Assert.fail((String)"Trying to discard a negative number of element is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ResizableDoubleArray)this.da).discardFrontElements(10000);
            Assert.fail((String)"You can't discard more elements than the array contains");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ResizableDoubleArray)this.da).discardMostRecentElements(10000);
            Assert.fail((String)"You can't discard more elements than the array contains");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSubstitute() {
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        this.da.addElement(2.0);
        Assert.assertEquals((String)"Number of elements should be 11", (long)11L, (long)this.da.getNumElements());
        ((ResizableDoubleArray)this.da).substituteMostRecentElement(24.0);
        Assert.assertEquals((String)"Number of elements should be 11", (long)11L, (long)this.da.getNumElements());
        try {
            ((ResizableDoubleArray)this.da).discardMostRecentElements(10);
        }
        catch (Exception e) {
            Assert.fail((String)"Trying to discard a negative number of element is not allowed");
        }
        ((ResizableDoubleArray)this.da).substituteMostRecentElement(24.0);
        Assert.assertEquals((String)"Number of elements should be 1", (long)1L, (long)this.da.getNumElements());
    }

    @Test
    public void testMutators() {
        ((ResizableDoubleArray)this.da).setContractionCriteria(10.0f);
        Assert.assertEquals((double)10.0, (double)((ResizableDoubleArray)this.da).getContractionCriterion(), (double)0.0);
        ((ResizableDoubleArray)this.da).setExpansionFactor(8.0f);
        Assert.assertEquals((float)8.0f, (float)((ResizableDoubleArray)this.da).getExpansionFactor(), (float)0.0f);
        try {
            ((ResizableDoubleArray)this.da).setExpansionFactor(11.0f);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((ResizableDoubleArray)this.da).setExpansionMode(1);
        Assert.assertEquals((long)1L, (long)((ResizableDoubleArray)this.da).getExpansionMode());
        try {
            ((ResizableDoubleArray)this.da).setExpansionMode(-1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        ResizableDoubleArray first = new ResizableDoubleArray();
        Double other = new Double(2.0);
        Assert.assertFalse((boolean)first.equals((Object)other));
        other = null;
        Assert.assertFalse((boolean)first.equals((Object)other));
        Assert.assertTrue((boolean)first.equals((Object)first));
        ResizableDoubleArray second = new ResizableDoubleArray();
        this.verifyEquality(first, second);
        ResizableDoubleArray third = new ResizableDoubleArray(3, 2.0, 2.0);
        this.verifyInequality(third, first);
        ResizableDoubleArray fourth = new ResizableDoubleArray(3, 2.0, 2.0);
        ResizableDoubleArray fifth = new ResizableDoubleArray(2, 2.0, 2.0);
        this.verifyEquality(third, fourth);
        this.verifyInequality(third, fifth);
        third.addElement(4.1);
        third.addElement(4.2);
        third.addElement(4.3);
        fourth.addElement(4.1);
        fourth.addElement(4.2);
        fourth.addElement(4.3);
        this.verifyEquality(third, fourth);
        fourth.addElement(4.4);
        this.verifyInequality(third, fourth);
        third.addElement(4.4);
        this.verifyEquality(third, fourth);
        fourth.addElement(4.4);
        this.verifyInequality(third, fourth);
        third.addElement(4.4);
        this.verifyEquality(third, fourth);
        fourth.addElementRolling(4.5);
        third.addElementRolling(4.5);
        this.verifyEquality(third, fourth);
        third.discardFrontElements(1);
        this.verifyInequality(third, fourth);
        fourth.discardFrontElements(1);
        this.verifyEquality(third, fourth);
        third.discardMostRecentElements(2);
        fourth.discardMostRecentElements(2);
        this.verifyEquality(third, fourth);
        third.addElement(18.0);
        fourth.addElement(17.0);
        third.addElement(17.0);
        fourth.addElement(18.0);
        this.verifyInequality(third, fourth);
        ResizableDoubleArray.copy((ResizableDoubleArray)fourth, (ResizableDoubleArray)fifth);
        this.verifyEquality(fourth, fifth);
        this.verifyEquality(fourth, new ResizableDoubleArray(fourth));
        this.verifyEquality(fourth, fourth.copy());
    }

    @Test
    public void testGetArrayRef() {
        ResizableDoubleArray a = new ResizableDoubleArray();
        int index = 20;
        double v1 = 1.2;
        a.setElement(20, 1.2);
        double v2 = 4.6;
        double[] aInternalArray = a.getArrayRef();
        aInternalArray[a.getStartIndex() + 20] = 4.6;
        Assert.assertEquals((double)4.6, (double)a.getElement(20), (double)0.0);
    }

    @Test
    public void testCompute() {
        ResizableDoubleArray a = new ResizableDoubleArray();
        int max = 20;
        for (int i = 1; i <= 20; ++i) {
            a.setElement(i, (double)i);
        }
        MathArrays.Function add = new MathArrays.Function(){

            public double evaluate(double[] a, int index, int num) {
                double sum = 0.0;
                int max = index + num;
                for (int i = index; i < max; ++i) {
                    sum += a[i];
                }
                return sum;
            }

            public double evaluate(double[] a) {
                return this.evaluate(a, 0, a.length);
            }
        };
        double sum = a.compute(add);
        Assert.assertEquals((double)210.0, (double)sum, (double)0.0);
    }

    private void verifyEquality(ResizableDoubleArray a, ResizableDoubleArray b) {
        Assert.assertTrue((boolean)b.equals((Object)a));
        Assert.assertTrue((boolean)a.equals((Object)b));
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
    }

    private void verifyInequality(ResizableDoubleArray a, ResizableDoubleArray b) {
        Assert.assertFalse((boolean)b.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }
}

