/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.transform;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinc;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.transform.DctNormalization;
import com.hazelcast.shaded.org.apache.commons.math3.transform.FastCosineTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.RealTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.RealTransformerAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformType;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public final class FastCosineTransformerTest
extends RealTransformerAbstractTest {
    private DctNormalization normalization;
    private final int[] invalidDataSize;
    private final double[] relativeTolerance;
    private final int[] validDataSize;

    public FastCosineTransformerTest(DctNormalization normalization) {
        this.normalization = normalization;
        this.validDataSize = new int[]{2, 3, 5, 9, 17, 33, 65, 129};
        this.invalidDataSize = new int[]{128};
        this.relativeTolerance = new double[]{1.0E-15, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10};
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        DctNormalization[] normalization = DctNormalization.values();
        DctNormalization[][] data = new DctNormalization[normalization.length][1];
        for (int i = 0; i < normalization.length; ++i) {
            data[i][0] = normalization[i];
        }
        return Arrays.asList(data);
    }

    @Override
    RealTransformer createRealTransformer() {
        return new FastCosineTransformer(this.normalization);
    }

    @Override
    int getInvalidDataSize(int i) {
        return this.invalidDataSize[i];
    }

    @Override
    int getNumberOfInvalidDataSizes() {
        return this.invalidDataSize.length;
    }

    @Override
    int getNumberOfValidDataSizes() {
        return this.validDataSize.length;
    }

    @Override
    double getRelativeTolerance(int i) {
        return this.relativeTolerance[i];
    }

    @Override
    int getValidDataSize(int i) {
        return this.validDataSize[i];
    }

    @Override
    UnivariateFunction getValidFunction() {
        return new Sinc();
    }

    @Override
    double getValidLowerBound() {
        return 0.0;
    }

    @Override
    double getValidUpperBound() {
        return Math.PI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    double[] transform(double[] x, TransformType type) {
        double s;
        int n = x.length;
        double[] y = new double[n];
        double[] cos = new double[2 * (n - 1)];
        for (int i = 0; i < cos.length; ++i) {
            cos[i] = FastMath.cos((double)(Math.PI * (double)i / ((double)n - 1.0)));
        }
        int sgn = 1;
        for (int j = 0; j < n; ++j) {
            double yj = 0.5 * (x[0] + (double)sgn * x[n - 1]);
            for (int i = 1; i < n - 1; ++i) {
                yj += x[i] * cos[i * j % cos.length];
            }
            y[j] = yj;
            sgn *= -1;
        }
        if (type == TransformType.FORWARD) {
            if (this.normalization == DctNormalization.STANDARD_DCT_I) {
                s = 1.0;
            } else {
                if (this.normalization != DctNormalization.ORTHOGONAL_DCT_I) throw new MathIllegalStateException();
                s = FastMath.sqrt((double)(2.0 / ((double)n - 1.0)));
            }
        } else {
            if (type != TransformType.INVERSE) throw new MathIllegalStateException();
            if (this.normalization == DctNormalization.STANDARD_DCT_I) {
                s = 2.0 / ((double)n - 1.0);
            } else {
                if (this.normalization != DctNormalization.ORTHOGONAL_DCT_I) throw new MathIllegalStateException();
                s = FastMath.sqrt((double)(2.0 / ((double)n - 1.0)));
            }
        }
        TransformUtils.scaleArray((double[])y, (double)s);
        return y;
    }

    @Test
    public void testAdHocData() {
        int i;
        FastCosineTransformer transformer = new FastCosineTransformer(DctNormalization.STANDARD_DCT_I);
        double tolerance = 1.0E-12;
        double[] x = new double[]{0.0, 1.0, 4.0, 9.0, 16.0, 25.0, 36.0, 49.0, 64.0};
        double[] y = new double[]{172.0, -105.096569476353, 27.3137084989848, -12.9593152353742, 8.0, -5.78585076868676, 4.68629150101524, -4.15826451958632, 4.0};
        double[] result = transformer.transform(x, TransformType.FORWARD);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)y[i], (double)result[i], (double)tolerance);
        }
        result = transformer.transform(y, TransformType.INVERSE);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)x[i], (double)result[i], (double)tolerance);
        }
        TransformUtils.scaleArray((double[])x, (double)FastMath.sqrt((double)(0.5 * (double)(x.length - 1))));
        transformer = new FastCosineTransformer(DctNormalization.ORTHOGONAL_DCT_I);
        result = transformer.transform(y, TransformType.FORWARD);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)x[i], (double)result[i], (double)tolerance);
        }
        result = transformer.transform(x, TransformType.INVERSE);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)y[i], (double)result[i], (double)tolerance);
        }
    }

    @Test
    public void testParameters() throws Exception {
        Sin f = new Sin();
        FastCosineTransformer transformer = new FastCosineTransformer(DctNormalization.STANDARD_DCT_I);
        try {
            transformer.transform((UnivariateFunction)f, 1.0, -1.0, 65, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformer.transform((UnivariateFunction)f, -1.0, 1.0, 1, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad samples number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformer.transform((UnivariateFunction)f, -1.0, 1.0, 64, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad samples number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSinFunction() {
        int i;
        Sin f = new Sin();
        FastCosineTransformer transformer = new FastCosineTransformer(DctNormalization.STANDARD_DCT_I);
        double tolerance = 1.0E-12;
        int N = 9;
        double[] expected = new double[]{0.0, 3.26197262739567, 0.0, -2.17958042710327, 0.0, -0.648846697642915, 0.0, -0.433545502649478, 0.0};
        double min = 0.0;
        double max = Math.PI * 2 * (double)N / (double)(N - 1);
        double[] result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.FORWARD);
        for (i = 0; i < N; ++i) {
            Assert.assertEquals((double)expected[i], (double)result[i], (double)tolerance);
        }
        min = -Math.PI;
        max = Math.PI * (double)(N + 1) / (double)(N - 1);
        result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.FORWARD);
        for (i = 0; i < N; ++i) {
            Assert.assertEquals((double)(-expected[i]), (double)result[i], (double)tolerance);
        }
    }
}

