/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomDataGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomDataGeneratorTest;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.stat.Frequency;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RandomGeneratorAbstractTest
extends RandomDataGeneratorTest {
    protected RandomGenerator generator = this.makeGenerator();

    protected abstract RandomGenerator makeGenerator();

    public RandomGeneratorAbstractTest() {
        this.randomData = new RandomDataGenerator(this.generator);
    }

    @Before
    public void setUp() {
        this.generator = this.makeGenerator();
    }

    public void testNextSecureLongIAE() {
    }

    public void testNextSecureLongNegativeToPositiveRange() {
    }

    public void testNextSecureLongNegativeRange() {
    }

    public void testNextSecureLongPositiveRange() {
    }

    public void testNextSecureIntIAE() {
    }

    public void testNextSecureIntNegativeToPositiveRange() {
    }

    public void testNextSecureIntNegativeRange() {
    }

    public void testNextSecureIntPositiveRange() {
    }

    public void testNextSecureHex() {
    }

    @Test
    public void testNextIntDirect() {
        int[] testValues = new int[]{4, 10, 12, 32, 100, 10000, 0, 0, 0, 0};
        for (int i = 6; i < 10; ++i) {
            int val = this.generator.nextInt();
            testValues[i] = val < 0 ? -val : val + 1;
        }
        int numTests = 1000;
        for (int i = 0; i < testValues.length; ++i) {
            int[] binUpperBounds;
            int n = testValues[i];
            if (n < 32) {
                binUpperBounds = new int[n];
                for (int k = 0; k < n; ++k) {
                    binUpperBounds[k] = k;
                }
            } else {
                binUpperBounds = new int[10];
                int step = n / 10;
                for (int k = 0; k < 9; ++k) {
                    binUpperBounds[k] = (k + 1) * step;
                }
                binUpperBounds[9] = n - 1;
            }
            int numFailures = 0;
            int binCount = binUpperBounds.length;
            long[] observed = new long[binCount];
            double[] expected = new double[binCount];
            expected[0] = binUpperBounds[0] == 0 ? 1000.0 / (double)n : (double)((long)(binUpperBounds[0] + 1) * 1000L) / (double)n;
            for (int k = 1; k < binCount; ++k) {
                expected[k] = 1000.0 * (double)(binUpperBounds[k] - binUpperBounds[k - 1]) / (double)n;
            }
            for (int j = 0; j < 1000; ++j) {
                Arrays.fill(observed, 0L);
                int k = 0;
                while ((long)k < 1000L) {
                    int value = this.generator.nextInt(n);
                    Assert.assertTrue((String)"nextInt range", (value >= 0 && value < n ? 1 : 0) != 0);
                    for (int l = 0; l < binCount; ++l) {
                        if (binUpperBounds[l] < value) continue;
                        int n2 = l;
                        observed[n2] = observed[n2] + 1L;
                        break;
                    }
                    ++k;
                }
                if (!(this.testStatistic.chiSquareTest(expected, observed) < 0.01)) continue;
                ++numFailures;
            }
            if (!((double)numFailures / 1000.0 > 0.02)) continue;
            Assert.fail((String)("Too many failures for n = " + n + " " + numFailures + " out of " + 1000 + " tests failed."));
        }
    }

    @Test
    public void testNextIntIAE2() {
        try {
            this.generator.nextInt(-1);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.generator.nextInt(0);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNextLongDirect() {
        long q1 = 0x1FFFFFFFFFFFFFFFL;
        long q2 = 2L * q1;
        long q3 = 3L * q1;
        Frequency freq = new Frequency();
        long val = 0L;
        int value = 0;
        int i = 0;
        while ((long)i < 1000L) {
            val = this.generator.nextLong();
            long l = val = val < 0L ? -val : val;
            value = val < q1 ? 0 : (val < q2 ? 1 : (val < q3 ? 2 : 3));
            freq.addValue(value);
            ++i;
        }
        long[] observed = new long[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            observed[i2] = freq.getCount(i2);
        }
        Assert.assertTrue((String)"chi-square test -- will fail about 1 in 1000 times", (this.testStatistic.chiSquare(this.expected, observed) < 16.27 ? 1 : 0) != 0);
    }

    @Test
    public void testNextBooleanDirect() {
        long halfSampleSize = 500L;
        double[] expected = new double[]{halfSampleSize, halfSampleSize};
        long[] observed = new long[2];
        int i = 0;
        while ((long)i < 1000L) {
            if (this.generator.nextBoolean()) {
                observed[0] = observed[0] + 1L;
            } else {
                observed[1] = observed[1] + 1L;
            }
            ++i;
        }
        Assert.assertTrue((String)"chi-square test -- will fail about 1 in 1000 times", (this.testStatistic.chiSquare(expected, observed) < 10.828 ? 1 : 0) != 0);
    }

    @Test
    public void testNextFloatDirect() {
        Frequency freq = new Frequency();
        float val = 0.0f;
        int value = 0;
        int i = 0;
        while ((long)i < 1000L) {
            val = this.generator.nextFloat();
            value = (double)val < 0.25 ? 0 : ((double)val < 0.5 ? 1 : ((double)val < 0.75 ? 2 : 3));
            freq.addValue(value);
            ++i;
        }
        long[] observed = new long[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            observed[i2] = freq.getCount(i2);
        }
        Assert.assertTrue((String)"chi-square test -- will fail about 1 in 1000 times", (this.testStatistic.chiSquare(this.expected, observed) < 16.27 ? 1 : 0) != 0);
    }

    @Test
    public void testNextDouble() {
        double[] sample = new double[10000];
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = this.generator.nextDouble();
        }
        UniformRealDistribution uniformDistribution = new UniformRealDistribution(0.0, 1.0);
        KolmogorovSmirnovTest ks = new KolmogorovSmirnovTest();
        Assert.assertFalse((boolean)ks.kolmogorovSmirnovTest((RealDistribution)uniformDistribution, sample, 0.01));
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNextIntNeg() {
        this.generator.nextInt(-1);
    }

    @Test
    public void testNextInt2() {
        int walk = 0;
        int N = 10000;
        for (int k = 0; k < 10000; ++k) {
            if (this.generator.nextInt() >= 0) {
                ++walk;
                continue;
            }
            --walk;
        }
        Assert.assertTrue((String)("Walked too far astray: " + walk + "\nNote: This " + "test will fail randomly about 1 in 100 times."), ((double)FastMath.abs((int)walk) < FastMath.sqrt((double)10000.0) * 2.576 ? 1 : 0) != 0);
    }

    @Test
    public void testNextLong2() {
        int walk = 0;
        int N = 1000;
        for (int k = 0; k < 1000; ++k) {
            if (this.generator.nextLong() >= 0L) {
                ++walk;
                continue;
            }
            --walk;
        }
        Assert.assertTrue((String)("Walked too far astray: " + walk + "\nNote: This " + "test will fail randomly about 1 in 100 times."), ((double)FastMath.abs((int)walk) < FastMath.sqrt((double)1000.0) * 2.576 ? 1 : 0) != 0);
    }

    @Test
    public void testNexBoolean2() {
        int walk = 0;
        int N = 10000;
        for (int k = 0; k < 10000; ++k) {
            if (this.generator.nextBoolean()) {
                ++walk;
                continue;
            }
            --walk;
        }
        Assert.assertTrue((String)("Walked too far astray: " + walk + "\nNote: This " + "test will fail randomly about 1 in 100 times."), ((double)FastMath.abs((int)walk) < FastMath.sqrt((double)10000.0) * 2.576 ? 1 : 0) != 0);
    }

    @Test
    public void testNexBytes() {
        long[] count = new long[256];
        byte[] bytes = new byte[10];
        double[] expected = new double[256];
        int sampleSize = 100000;
        for (int i = 0; i < 256; ++i) {
            expected[i] = 377.35849056603774;
        }
        for (int k = 0; k < 100000; ++k) {
            this.generator.nextBytes(bytes);
            for (byte b : bytes) {
                int n = b + 128;
                count[n] = count[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(expected, count, 0.001);
    }

    @Test
    public void testSeeding() {
        RandomGenerator gen = this.makeGenerator();
        RandomGenerator gen1 = this.makeGenerator();
        this.checkSameSequence(gen, gen1);
        gen.setSeed(100);
        gen1 = this.makeGenerator();
        gen1.setSeed(100);
        this.checkSameSequence(gen, gen1);
    }

    private void checkSameSequence(RandomGenerator gen1, RandomGenerator gen2) {
        int i;
        int len = 11;
        double[][] values = new double[2][11];
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextDouble();
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextDouble();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextFloat();
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextFloat();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextInt();
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextInt();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextLong();
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextLong();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextInt(11);
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextInt(11);
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextBoolean() ? 1.0 : 0.0;
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextBoolean() ? 1.0 : 0.0;
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
        for (i = 0; i < 11; ++i) {
            values[0][i] = gen1.nextGaussian();
        }
        for (i = 0; i < 11; ++i) {
            values[1][i] = gen2.nextGaussian();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
    }
}

