/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.general;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.StatisticalReferenceDataset;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

@Deprecated
public class StatisticalReferenceDatasetFactory {
    private StatisticalReferenceDatasetFactory() {
    }

    public static BufferedReader createBufferedReaderFromResource(String name) throws IOException {
        InputStream resourceAsStream = StatisticalReferenceDatasetFactory.class.getResourceAsStream(name);
        if (resourceAsStream == null) {
            throw new IOException("could not find resource " + name);
        }
        return new BufferedReader(new InputStreamReader(resourceAsStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createKirby2() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Kirby2.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public DerivativeStructure getModelValue(double x, DerivativeStructure[] a) {
                    DerivativeStructure p = a[0].add(a[1].add(a[2].multiply(x)).multiply(x));
                    DerivativeStructure q = a[3].add(a[4].multiply(x)).multiply(x).add(1.0);
                    return p.divide(q);
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createHahn1() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Hahn1.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public DerivativeStructure getModelValue(double x, DerivativeStructure[] a) {
                    DerivativeStructure p = a[0].add(a[1].add(a[2].add(a[3].multiply(x)).multiply(x)).multiply(x));
                    DerivativeStructure q = a[4].add(a[5].add(a[6].multiply(x)).multiply(x)).multiply(x).add(1.0);
                    return p.divide(q);
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createMGH17() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("MGH17.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public DerivativeStructure getModelValue(double x, DerivativeStructure[] a) {
                    return a[0].add(a[1].multiply(a[3].multiply(-x).exp())).add(a[2].multiply(a[4].multiply(-x).exp()));
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createLanczos1() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Lanczos1.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public DerivativeStructure getModelValue(double x, DerivativeStructure[] a) {
                    return a[0].multiply(a[3].multiply(-x).exp()).add(a[1].multiply(a[4].multiply(-x).exp())).add(a[2].multiply(a[5].multiply(-x).exp()));
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    public StatisticalReferenceDataset[] createAll() throws IOException {
        return new StatisticalReferenceDataset[]{StatisticalReferenceDatasetFactory.createKirby2(), StatisticalReferenceDatasetFactory.createMGH17()};
    }
}

