/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.general;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.BrentSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.SimpleValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.CircleScalar;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.ConjugateGradientFormula;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.NonLinearConjugateGradientOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.Preconditioner;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class NonLinearConjugateGradientOptimizerTest {
    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0});
        Assert.assertEquals((double)1.5, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testColumnsPermutation() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, -1.0}, {0.0, 2.0}, {1.0, -2.0}}, new double[]{4.0, 6.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0, 0.0});
        Assert.assertEquals((double)7.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testNoDependency() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 2.0}}, new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        for (int i = 0; i < problem.target.length; ++i) {
            Assert.assertEquals((double)(0.55 * (double)i), (double)optimum.getPoint()[i], (double)1.0E-10);
        }
    }

    @Test
    public void testOneSet() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}}, new double[]{1.0, 1.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0, 0.0, 0.0});
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[2], (double)1.0E-10);
    }

    @Test
    public void testTwoSets() {
        double epsilon = 1.0E-7;
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 1.0, 0.0, 4.0, 0.0, 0.0}, {-4.0, -2.0, 3.0, -7.0, 0.0, 0.0}, {4.0, 1.0, -2.0, 8.0, 0.0, 0.0}, {0.0, -3.0, -12.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0E-7, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0}}, new double[]{2.0, -9.0, 2.0, 2.0, 1.00000000000001, 2.0});
        Preconditioner preconditioner = new Preconditioner(){

            public double[] precondition(double[] point, double[] r) {
                double[] d = (double[])r.clone();
                d[0] = d[0] / 72.0;
                d[1] = d[1] / 30.0;
                d[2] = d[2] / 314.0;
                d[3] = d[3] / 260.0;
                d[4] = d[4] / 2.00000000000002;
                d[5] = d[5] / 4.0;
                return d;
            }
        };
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13), (UnivariateSolver)new BrentSolver(), preconditioner);
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)optimum.getPoint()[2], (double)1.0E-10);
        Assert.assertEquals((double)-2.0, (double)optimum.getPoint()[3], (double)1.0E-10);
        Assert.assertEquals((double)1.0000001, (double)optimum.getPoint()[4], (double)1.0E-10);
        Assert.assertEquals((double)0.9999999, (double)optimum.getPoint()[5], (double)1.0E-10);
    }

    @Test
    public void testNonInversible() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{0.0, 0.0, 0.0});
        Assert.assertTrue(((Double)optimum.getValue() > 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testIllConditioned() {
        LinearProblem problem1 = new LinearProblem(new double[][]{{10.0, 7.0, 8.0, 7.0}, {7.0, 5.0, 6.0, 5.0}, {8.0, 6.0, 10.0, 9.0}, {7.0, 5.0, 9.0, 10.0}}, new double[]{32.0, 23.0, 33.0, 31.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13), (UnivariateSolver)new BrentSolver(1.0E-15, 1.0E-15));
        PointValuePair optimum1 = optimizer.optimize(200, (MultivariateDifferentiableFunction)problem1, GoalType.MINIMIZE, new double[]{0.0, 1.0, 2.0, 3.0});
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[0], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[1], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[2], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[3], (double)1.0E-4);
        LinearProblem problem2 = new LinearProblem(new double[][]{{10.0, 7.0, 8.1, 7.2}, {7.08, 5.04, 6.0, 5.0}, {8.0, 5.98, 9.89, 9.0}, {6.99, 4.99, 9.0, 9.98}}, new double[]{32.0, 23.0, 33.0, 31.0});
        PointValuePair optimum2 = optimizer.optimize(200, (MultivariateDifferentiableFunction)problem2, GoalType.MINIMIZE, new double[]{0.0, 1.0, 2.0, 3.0});
        Assert.assertEquals((double)-81.0, (double)optimum2.getPoint()[0], (double)0.1);
        Assert.assertEquals((double)137.0, (double)optimum2.getPoint()[1], (double)0.1);
        Assert.assertEquals((double)-34.0, (double)optimum2.getPoint()[2], (double)0.1);
        Assert.assertEquals((double)22.0, (double)optimum2.getPoint()[3], (double)0.1);
    }

    @Test
    public void testMoreEstimatedParametersSimple() {
        LinearProblem problem = new LinearProblem(new double[][]{{3.0, 2.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 1.0}, {2.0, 0.0, 1.0, 0.0}}, new double[]{7.0, 3.0, 5.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{7.0, 6.0, 5.0, 4.0});
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testMoreEstimatedParametersUnsorted() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, -1.0}, {0.0, 0.0, -1.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, -1.0, 1.0, 0.0}}, new double[]{3.0, 12.0, -1.0, 7.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0});
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testRedundantEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 5.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{1.0, 1.0});
        Assert.assertEquals((double)2.0, (double)optimum.getPoint()[0], (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[1], (double)1.0E-8);
    }

    @Test
    public void testInconsistentEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 4.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)problem, GoalType.MINIMIZE, new double[]{1.0, 1.0});
        Assert.assertTrue(((Double)optimum.getValue() > 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testCircleFitting() {
        CircleScalar circle = new CircleScalar();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-30, 1.0E-30), (UnivariateSolver)new BrentSolver(1.0E-15, 1.0E-13));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableFunction)circle, GoalType.MINIMIZE, new double[]{98.68, 47.345});
        Vector2D center = new Vector2D(optimum.getPointRef()[0], optimum.getPointRef()[1]);
        Assert.assertEquals((double)69.960161753, (double)circle.getRadius(center), (double)1.0E-8);
        Assert.assertEquals((double)96.075902096, (double)center.getX(), (double)1.0E-8);
        Assert.assertEquals((double)48.135167894, (double)center.getY(), (double)1.0E-8);
    }

    private static class LinearProblem
    implements MultivariateDifferentiableFunction,
    Serializable {
        private static final long serialVersionUID = 703247177355019415L;
        final RealMatrix factors;
        final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public double value(double[] variables) {
            double[] y = this.factors.operate(variables);
            double sum = 0.0;
            for (int i = 0; i < y.length; ++i) {
                double ri = y[i] - this.target[i];
                sum += ri * ri;
            }
            return sum;
        }

        public DerivativeStructure value(DerivativeStructure[] variables) {
            DerivativeStructure[] y = new DerivativeStructure[this.factors.getRowDimension()];
            for (int i = 0; i < y.length; ++i) {
                y[i] = (DerivativeStructure)variables[0].getField().getZero();
                for (int j = 0; j < this.factors.getColumnDimension(); ++j) {
                    y[i] = y[i].add(variables[j].multiply(this.factors.getEntry(i, j)));
                }
            }
            DerivativeStructure sum = (DerivativeStructure)variables[0].getField().getZero();
            for (int i = 0; i < y.length; ++i) {
                DerivativeStructure ri = y[i].subtract(this.target[i]);
                sum = sum.add(ri.multiply(ri));
            }
            return sum;
        }
    }
}

