/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ODEIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem4;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem5;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class DormandPrince54IntegratorTest {
    @Test(expected=DimensionMismatchException.class)
    public void testDimensionCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        DormandPrince54Integrator integrator = new DormandPrince54Integrator(0.0, 1.0, 1.0E-10, 1.0E-10);
        integrator.integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension() + 10], 1.0, new double[pb.getDimension() + 10]);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double minStep = 0.1 * (pb.getFinalTime() - pb.getInitialTime());
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double[] vecAbsoluteTolerance = new double[]{1.0E-15, 1.0E-16};
        double[] vecRelativeTolerance = new double[]{1.0E-15, 1.0E-16};
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.fail((String)"an exception should have been thrown");
    }

    @Test
    public void testSmallLastStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double minStep = 1.25;
        double maxStep = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime()));
        double scalAbsoluteTolerance = 6.0E-4;
        double scalRelativeTolerance = 6.0E-4;
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        DP54SmallLastHandler handler = new DP54SmallLastHandler(minStep);
        integ.addStepHandler((StepHandler)handler);
        integ.setInitialStepSize(1.7);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((boolean)handler.wasLastSeen());
        Assert.assertEquals((Object)"Dormand-Prince 5(4)", (Object)integ.getName());
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 2.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 2.0E-7 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Dormand-Prince 5(4)", (Object)integ.getName());
    }

    @Test
    public void testIncreasingTolerance() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -2; ++i) {
            TestProblem1 pb = new TestProblem1();
            double minStep = 0.0;
            double maxStep = pb.getFinalTime() - pb.getInitialTime();
            double scalAbsoluteTolerance = FastMath.pow((double)10.0, (int)i);
            double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
            DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
            TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
            integ.setSafety(0.8);
            integ.setMaxGrowth(5.0);
            integ.setMinReduction(0.3);
            integ.addStepHandler((StepHandler)handler);
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.assertEquals((double)0.8, (double)integ.getSafety(), (double)1.0E-12);
            Assert.assertEquals((double)5.0, (double)integ.getMaxGrowth(), (double)1.0E-12);
            Assert.assertEquals((double)0.3, (double)integ.getMinReduction(), (double)1.0E-12);
            Assert.assertTrue((handler.getMaximalValueError() < 0.7 * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test
    public void testEvents() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem4 pb = new TestProblem4();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        EventHandler[] functions = pb.getEventsHandlers();
        double convergence = 1.0E-8 * maxStep;
        for (int l = 0; l < functions.length; ++l) {
            integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, convergence, 1000);
        }
        Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getMaximalValueError() < 5.0E-6 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)convergence);
        Assert.assertEquals((double)12.0, (double)handler.getLastTime(), (double)convergence);
        integ.clearEventHandlers();
        Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
    }

    @Test
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double scalAbsoluteTolerance;
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalRelativeTolerance = scalAbsoluteTolerance = 1.0E-8;
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        integ.addStepHandler((StepHandler)new KeplerHandler(pb));
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertEquals((long)integ.getEvaluations(), (long)pb.getCalls());
        Assert.assertTrue((pb.getCalls() < 2800 ? 1 : 0) != 0);
    }

    @Test
    public void testVariableSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double scalAbsoluteTolerance;
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalRelativeTolerance = scalAbsoluteTolerance = 1.0E-8;
        DormandPrince54Integrator integ = new DormandPrince54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        integ.addStepHandler((StepHandler)new VariableHandler());
        double stopTime = integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertEquals((double)pb.getFinalTime(), (double)stopTime, (double)1.0E-10);
    }

    private static class VariableHandler
    implements StepHandler {
        private boolean firstTime = true;
        private double minStep = 0.0;
        private double maxStep = 0.0;

        public void init(double t0, double[] y0, double t) {
            this.firstTime = true;
            this.minStep = 0.0;
            this.maxStep = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            double step = FastMath.abs((double)(interpolator.getCurrentTime() - interpolator.getPreviousTime()));
            if (this.firstTime) {
                this.maxStep = this.minStep = FastMath.abs((double)step);
                this.firstTime = false;
            } else {
                if (step < this.minStep) {
                    this.minStep = step;
                }
                if (step > this.maxStep) {
                    this.maxStep = step;
                }
            }
            if (isLast) {
                Assert.assertTrue((this.minStep < 0.0022222222222222222 ? 1 : 0) != 0);
                Assert.assertTrue((this.maxStep > 0.23809523809523808 ? 1 : 0) != 0);
            }
        }
    }

    private static class KeplerHandler
    implements StepHandler {
        private int nbSteps;
        private double maxError;
        private TestProblem3 pb;

        public KeplerHandler(TestProblem3 pb) {
            this.pb = pb;
        }

        public void init(double t0, double[] y0, double t) {
            this.nbSteps = 0;
            this.maxError = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
            ++this.nbSteps;
            for (int a = 1; a < 10; ++a) {
                double prev = interpolator.getPreviousTime();
                double curr = interpolator.getCurrentTime();
                double interp = ((double)(10 - a) * prev + (double)a * curr) / 10.0;
                interpolator.setInterpolatedTime(interp);
                double[] interpolatedY = interpolator.getInterpolatedState();
                double[] theoreticalY = this.pb.computeTheoreticalState(interpolator.getInterpolatedTime());
                double dx = interpolatedY[0] - theoreticalY[0];
                double dy = interpolatedY[1] - theoreticalY[1];
                double error = dx * dx + dy * dy;
                if (!(error > this.maxError)) continue;
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertTrue((this.maxError < 7.0E-10 ? 1 : 0) != 0);
                Assert.assertTrue((this.nbSteps < 400 ? 1 : 0) != 0);
            }
        }
    }

    private static class DP54SmallLastHandler
    implements StepHandler {
        private boolean lastSeen = false;
        private double minStep;

        public DP54SmallLastHandler(double minStep) {
            this.minStep = minStep;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            if (isLast) {
                this.lastSeen = true;
                double h = interpolator.getCurrentTime() - interpolator.getPreviousTime();
                Assert.assertTrue((FastMath.abs((double)h) < this.minStep ? 1 : 0) != 0);
            }
        }

        public boolean wasLastSeen() {
            return this.lastSeen;
        }
    }
}

