/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.AdamsBashforthFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.AdamsFieldIntegratorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Decimal64Field;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsBashforthFieldIntegratorTest
extends AdamsFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> AdamsFieldIntegrator<T> createIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        return new AdamsBashforthFieldIntegrator(field, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    @Override
    protected <T extends RealFieldElement<T>> AdamsFieldIntegrator<T> createIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        return new AdamsBashforthFieldIntegrator(field, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    @Test(expected=NumberIsTooSmallException.class)
    public void testMinStep() {
        this.doDimensionCheck(Decimal64Field.getInstance());
    }

    @Override
    @Test
    public void testIncreasingTolerance() {
        this.doTestIncreasingTolerance(Decimal64Field.getInstance(), 2.6, 122.0);
    }

    @Override
    @Test(expected=MaxCountExceededException.class)
    public void exceedMaxEvaluations() {
        this.doExceedMaxEvaluations(Decimal64Field.getInstance(), 650);
    }

    @Override
    @Test
    public void backward() {
        this.doBackward(Decimal64Field.getInstance(), 4.3E-8, 4.3E-8, 1.0E-16, "Adams-Bashforth");
    }

    @Override
    @Test
    public void polynomial() {
        this.doPolynomial(Decimal64Field.getInstance(), 5, 0.004, 6.0E-10);
    }

    @Override
    @Test(expected=MathIllegalStateException.class)
    public void testStartFailure() {
        this.doTestStartFailure(Decimal64Field.getInstance());
    }
}

