/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.events;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.PegasusSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerIntegrator;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ReappearingEventTest {
    @Test
    public void testDormandPrince() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double tEnd = this.test(1);
        Assert.assertEquals((double)10.0, (double)tEnd, (double)1.0E-7);
    }

    @Test
    public void testGragg() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double tEnd = this.test(2);
        Assert.assertEquals((double)10.0, (double)tEnd, (double)1.0E-7);
    }

    public double test(int integratorType) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = integratorType == 1 ? new DormandPrince853Integrator(e, 100.0, 1.0E-7, 1.0E-7) : new GraggBulirschStoerIntegrator(e, 100.0, 1.0E-7, 1.0E-7);
        PegasusSolver rootSolver = new PegasusSolver(e, e);
        integrator.addEventHandler((EventHandler)new Event(), 0.1, e, 1000, (UnivariateSolver)rootSolver);
        double t0 = 6.0;
        double tEnd = 10.0;
        double[] y = new double[]{2.0, 2.0, 2.0, 4.0, 2.0, 7.0, 15.0};
        return integrator.integrate((FirstOrderDifferentialEquations)new Ode(), t0, y, tEnd, y);
    }

    protected static class Event
    implements EventHandler {
        protected Event() {
        }

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return y[6] - 15.0;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            return EventHandler.Action.STOP;
        }

        public void resetState(double t, double[] y) {
        }
    }

    private static class Ode
    implements FirstOrderDifferentialEquations {
        private Ode() {
        }

        public int getDimension() {
            return 7;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            Arrays.fill(yDot, 1.0);
        }
    }
}

