/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Abs;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Acos;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Asin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Atan;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cbrt;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Ceil;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cos;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cosh;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Exp;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Expm1;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Floor;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Inverse;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Log;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Log10;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Log1p;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Power;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Rint;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Signum;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinh;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sqrt;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Tan;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Tanh;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Ulp;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public abstract class RealVectorAbstractTest {
    private final double[] values;

    public abstract RealVector create(double[] var1);

    public RealVector createAlien(double[] data) {
        return new RealVectorTestImpl(data);
    }

    public double getPreferredEntryValue() {
        return 0.0;
    }

    public RealVectorAbstractTest() {
        double x = this.getPreferredEntryValue();
        double y = x + 1.0;
        double z = y + 1.0;
        this.values = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, -0.0, x, y, z, 2.0 * x, -x, 1.0 / x, x * x, x + y, x - y, y - x};
    }

    @Test
    public void testGetDimension() {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, x, x, x};
        Assert.assertEquals((long)data1.length, (long)this.create(data1).getDimension());
        double y = x + 1.0;
        double[] data2 = new double[]{y, y, y, y};
        Assert.assertEquals((long)data2.length, (long)this.create(data2).getDimension());
    }

    @Test
    public void testGetEntry() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, 1.0, 2.0, x, x};
        RealVector v = this.create(data);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (double)data[i], (double)v.getEntry(i), (double)0.0);
        }
    }

    @Test(expected=OutOfRangeException.class)
    public void testGetEntryInvalidIndex1() {
        this.create(new double[4]).getEntry(-1);
    }

    @Test(expected=OutOfRangeException.class)
    public void testGetEntryInvalidIndex2() {
        this.create(new double[4]).getEntry(4);
    }

    @Test
    public void testSetEntry() {
        double newValue;
        double oldValue;
        int i;
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, 1.0, 2.0, x, x};
        double[] expected = MathArrays.copyOf((double[])data);
        RealVector actual = this.create(data);
        for (i = 0; i < data.length; ++i) {
            oldValue = data[i];
            expected[i] = newValue = oldValue + 1.0;
            actual.setEntry(i, newValue);
            TestUtils.assertEquals("while setting entry #" + i, expected, actual, 0.0);
            expected[i] = oldValue;
            actual.setEntry(i, oldValue);
        }
        for (i = 0; i < data.length; ++i) {
            oldValue = data[i];
            expected[i] = newValue = x;
            actual.setEntry(i, newValue);
            TestUtils.assertEquals("while setting entry #" + i, expected, actual, 0.0);
            expected[i] = oldValue;
            actual.setEntry(i, oldValue);
        }
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetEntryInvalidIndex1() {
        this.create(new double[4]).setEntry(-1, this.getPreferredEntryValue());
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetEntryInvalidIndex2() {
        this.create(new double[4]).setEntry(4, this.getPreferredEntryValue());
    }

    @Test
    public void testAddToEntry() {
        double oldValue;
        int i;
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, 1.0, 2.0, x, x};
        double[] expected = MathArrays.copyOf((double[])data1);
        RealVector actual = this.create(data1);
        double increment = 1.0;
        for (i = 0; i < data1.length; ++i) {
            oldValue = data1[i];
            int n = i;
            expected[n] = expected[n] + increment;
            actual.addToEntry(i, increment);
            TestUtils.assertEquals("while incrementing entry #" + i, expected, actual, 0.0);
            expected[i] = oldValue;
            actual.setEntry(i, oldValue);
        }
        for (i = 0; i < data1.length; ++i) {
            oldValue = data1[i];
            increment = x - oldValue;
            expected[i] = x;
            actual.addToEntry(i, increment);
            TestUtils.assertEquals("while incrementing entry #" + i, expected, actual, 0.0);
            expected[i] = oldValue;
            actual.setEntry(i, oldValue);
        }
    }

    @Test(expected=OutOfRangeException.class)
    public void testAddToEntryInvalidIndex1() {
        this.create(new double[3]).addToEntry(-1, this.getPreferredEntryValue());
    }

    @Test(expected=OutOfRangeException.class)
    public void testAddToEntryInvalidIndex2() {
        this.create(new double[3]).addToEntry(4, this.getPreferredEntryValue());
    }

    private void doTestAppendVector(String message, RealVector v1, RealVector v2, double delta) {
        String msg;
        int i;
        int n1 = v1.getDimension();
        int n2 = v2.getDimension();
        RealVector v = v1.append(v2);
        Assert.assertEquals((String)message, (long)(n1 + n2), (long)v.getDimension());
        for (i = 0; i < n1; ++i) {
            msg = message + ", entry #" + i;
            Assert.assertEquals((String)msg, (double)v1.getEntry(i), (double)v.getEntry(i), (double)delta);
        }
        for (i = 0; i < n2; ++i) {
            msg = message + ", entry #" + (n1 + i);
            Assert.assertEquals((String)msg, (double)v2.getEntry(i), (double)v.getEntry(n1 + i), (double)delta);
        }
    }

    @Test
    public void testAppendVector() {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, 1.0, 2.0, x, x};
        double[] data2 = new double[]{x, x, 3.0, x, 4.0, x};
        this.doTestAppendVector("same type", this.create(data1), this.create(data2), 0.0);
        this.doTestAppendVector("mixed types", this.create(data1), this.createAlien(data2), 0.0);
    }

    private void doTestAppendScalar(String message, RealVector v, double d, double delta) {
        int n = v.getDimension();
        RealVector w = v.append(d);
        Assert.assertEquals((String)message, (long)(n + 1), (long)w.getDimension());
        for (int i = 0; i < n; ++i) {
            String msg = message + ", entry #" + i;
            Assert.assertEquals((String)msg, (double)v.getEntry(i), (double)w.getEntry(i), (double)delta);
        }
        String msg = message + ", entry #" + n;
        Assert.assertEquals((String)msg, (double)d, (double)w.getEntry(n), (double)delta);
    }

    @Test
    public void testAppendScalar() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, 1.0, 2.0, x, x};
        this.doTestAppendScalar("", this.create(data), 1.0, 0.0);
        this.doTestAppendScalar("", this.create(data), x, 0.0);
    }

    @Test
    public void testGetSubVector() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, x, x, 1.0, x, 2.0, x, x, 3.0, x, x, x, 4.0, x, x, x};
        boolean index = true;
        int n = data.length - 5;
        RealVector actual = this.create(data).getSubVector(1, n);
        double[] expected = new double[n];
        System.arraycopy(data, 1, expected, 0, n);
        TestUtils.assertEquals("", expected, actual, 0.0);
    }

    @Test(expected=OutOfRangeException.class)
    public void testGetSubVectorInvalidIndex1() {
        int n = 10;
        this.create(new double[10]).getSubVector(-1, 2);
    }

    @Test(expected=OutOfRangeException.class)
    public void testGetSubVectorInvalidIndex2() {
        int n = 10;
        this.create(new double[10]).getSubVector(10, 2);
    }

    @Test(expected=OutOfRangeException.class)
    public void testGetSubVectorInvalidIndex3() {
        int n = 10;
        this.create(new double[10]).getSubVector(0, 11);
    }

    @Test(expected=NotPositiveException.class)
    public void testGetSubVectorInvalidIndex4() {
        int n = 10;
        this.create(new double[10]).getSubVector(3, -2);
    }

    @Test
    public void testSetSubVectorSameType() {
        double x = this.getPreferredEntryValue();
        double[] expected = new double[]{x, x, x, 1.0, x, 2.0, x, x, 3.0, x, x, x, 4.0, x, x, x};
        double[] sub = new double[]{5.0, x, 6.0, 7.0, 8.0};
        RealVector actual = this.create(expected);
        int index = 2;
        actual.setSubVector(2, this.create(sub));
        for (int i = 0; i < sub.length; ++i) {
            expected[2 + i] = sub[i];
        }
        TestUtils.assertEquals("", expected, actual, 0.0);
    }

    @Test
    public void testSetSubVectorMixedType() {
        double x = this.getPreferredEntryValue();
        double[] expected = new double[]{x, x, x, 1.0, x, 2.0, x, x, 3.0, x, x, x, 4.0, x, x, x};
        double[] sub = new double[]{5.0, x, 6.0, 7.0, 8.0};
        RealVector actual = this.create(expected);
        int index = 2;
        actual.setSubVector(2, this.createAlien(sub));
        for (int i = 0; i < sub.length; ++i) {
            expected[2 + i] = sub[i];
        }
        TestUtils.assertEquals("", expected, actual, 0.0);
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetSubVectorInvalidIndex1() {
        this.create(new double[10]).setSubVector(-1, this.create(new double[2]));
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetSubVectorInvalidIndex2() {
        this.create(new double[10]).setSubVector(10, this.create(new double[2]));
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetSubVectorInvalidIndex3() {
        this.create(new double[10]).setSubVector(9, this.create(new double[2]));
    }

    @Test
    public void testIsNaN() {
        RealVector v = this.create(new double[]{0.0, 1.0, 2.0});
        Assert.assertFalse((boolean)v.isNaN());
        v.setEntry(1, Double.NaN);
        Assert.assertTrue((boolean)v.isNaN());
    }

    @Test
    public void testIsInfinite() {
        RealVector v = this.create(new double[]{0.0, 1.0, 2.0});
        Assert.assertFalse((boolean)v.isInfinite());
        v.setEntry(0, Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)v.isInfinite());
        v.setEntry(1, Double.NaN);
        Assert.assertFalse((boolean)v.isInfinite());
    }

    protected void doTestEbeBinaryOperation(BinaryOperation op, boolean mixed, boolean ignoreSpecial) {
        int i;
        RealVector actual;
        double[] data1 = new double[this.values.length * this.values.length];
        double[] data2 = new double[this.values.length * this.values.length];
        int k = 0;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            for (int j = 0; j < this.values.length; ++j) {
                data1[k] = this.values[i2];
                data2[k] = this.values[j];
                ++k;
            }
        }
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        switch (op) {
            case ADD: {
                actual = v1.add(v2);
                break;
            }
            case SUB: {
                actual = v1.subtract(v2);
                break;
            }
            case MUL: {
                actual = v1.ebeMultiply(v2);
                break;
            }
            case DIV: {
                actual = v1.ebeDivide(v2);
                break;
            }
            default: {
                throw new AssertionError((Object)"unexpected value");
            }
        }
        double[] expected = new double[data1.length];
        block14: for (i = 0; i < expected.length; ++i) {
            switch (op) {
                case ADD: {
                    expected[i] = data1[i] + data2[i];
                    continue block14;
                }
                case SUB: {
                    expected[i] = data1[i] - data2[i];
                    continue block14;
                }
                case MUL: {
                    expected[i] = data1[i] * data2[i];
                    continue block14;
                }
                case DIV: {
                    expected[i] = data1[i] / data2[i];
                    continue block14;
                }
                default: {
                    throw new AssertionError((Object)"unexpected value");
                }
            }
        }
        for (i = 0; i < expected.length; ++i) {
            boolean isSpecial;
            boolean bl = isSpecial = Double.isNaN(expected[i]) || Double.isInfinite(expected[i]);
            if (isSpecial && ignoreSpecial) continue;
            String msg = "entry #" + i + ", left = " + data1[i] + ", right = " + data2[i];
            Assert.assertEquals((String)msg, (double)expected[i], (double)actual.getEntry(i), (double)0.0);
        }
    }

    private void doTestEbeBinaryOperationDimensionMismatch(BinaryOperation op) {
        int n = 10;
        switch (op) {
            case ADD: {
                this.create(new double[10]).add(this.create(new double[11]));
                break;
            }
            case SUB: {
                this.create(new double[10]).subtract(this.create(new double[11]));
                break;
            }
            case MUL: {
                this.create(new double[10]).ebeMultiply(this.create(new double[11]));
                break;
            }
            case DIV: {
                this.create(new double[10]).ebeDivide(this.create(new double[11]));
                break;
            }
            default: {
                throw new AssertionError((Object)"unexpected value");
            }
        }
    }

    @Test
    public void testAddSameType() {
        this.doTestEbeBinaryOperation(BinaryOperation.ADD, false, false);
    }

    @Test
    public void testAddMixedTypes() {
        this.doTestEbeBinaryOperation(BinaryOperation.ADD, true, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testAddDimensionMismatch() {
        this.doTestEbeBinaryOperationDimensionMismatch(BinaryOperation.ADD);
    }

    @Test
    public void testSubtractSameType() {
        this.doTestEbeBinaryOperation(BinaryOperation.SUB, false, false);
    }

    @Test
    public void testSubtractMixedTypes() {
        this.doTestEbeBinaryOperation(BinaryOperation.SUB, true, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testSubtractDimensionMismatch() {
        this.doTestEbeBinaryOperationDimensionMismatch(BinaryOperation.SUB);
    }

    @Test
    public void testEbeMultiplySameType() {
        this.doTestEbeBinaryOperation(BinaryOperation.MUL, false, false);
    }

    @Test
    public void testEbeMultiplyMixedTypes() {
        this.doTestEbeBinaryOperation(BinaryOperation.MUL, true, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeMultiplyDimensionMismatch() {
        this.doTestEbeBinaryOperationDimensionMismatch(BinaryOperation.MUL);
    }

    @Test
    public void testEbeDivideSameType() {
        this.doTestEbeBinaryOperation(BinaryOperation.DIV, false, false);
    }

    @Test
    public void testEbeDivideMixedTypes() {
        this.doTestEbeBinaryOperation(BinaryOperation.DIV, true, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeDivideDimensionMismatch() {
        this.doTestEbeBinaryOperationDimensionMismatch(BinaryOperation.DIV);
    }

    private void doTestGetDistance(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        double[] data2 = new double[]{4.0, x, x, 5.0, 6.0, 7.0, x, x, 8.0};
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double actual = v1.getDistance(v2);
        double expected = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            double delta = data2[i] - data1[i];
            expected += delta * delta;
        }
        expected = FastMath.sqrt((double)expected);
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testGetDistanceSameType() {
        this.doTestGetDistance(false);
    }

    @Test
    public void testGetDistanceMixedTypes() {
        this.doTestGetDistance(true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testGetDistanceDimensionMismatch() {
        this.create(new double[4]).getDistance(this.createAlien(new double[5]));
    }

    @Test
    public void testGetNorm() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        RealVector v = this.create(data);
        double actual = v.getNorm();
        double expected = 0.0;
        for (int i = 0; i < data.length; ++i) {
            expected += data[i] * data[i];
        }
        expected = FastMath.sqrt((double)expected);
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    private void doTestGetL1Distance(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        double[] data2 = new double[]{4.0, x, x, 5.0, 6.0, 7.0, x, x, 8.0};
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double actual = v1.getL1Distance(v2);
        double expected = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            double delta = data2[i] - data1[i];
            expected += FastMath.abs((double)delta);
        }
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testGetL1DistanceSameType() {
        this.doTestGetL1Distance(false);
    }

    @Test
    public void testGetL1DistanceMixedTypes() {
        this.doTestGetL1Distance(true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testGetL1DistanceDimensionMismatch() {
        this.create(new double[4]).getL1Distance(this.createAlien(new double[5]));
    }

    @Test
    public void testGetL1Norm() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        RealVector v = this.create(data);
        double actual = v.getL1Norm();
        double expected = 0.0;
        for (int i = 0; i < data.length; ++i) {
            expected += FastMath.abs((double)data[i]);
        }
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    private void doTestGetLInfDistance(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        double[] data2 = new double[]{4.0, x, x, 5.0, 6.0, 7.0, x, x, 8.0};
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double actual = v1.getLInfDistance(v2);
        double expected = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            double delta = data2[i] - data1[i];
            expected = FastMath.max((double)expected, (double)FastMath.abs((double)delta));
        }
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testGetLInfDistanceSameType() {
        this.doTestGetLInfDistance(false);
    }

    @Test
    public void testGetLInfDistanceMixedTypes() {
        this.doTestGetLInfDistance(true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testGetLInfDistanceDimensionMismatch() {
        this.create(new double[4]).getLInfDistance(this.createAlien(new double[5]));
    }

    @Test
    public void testGetLInfNorm() {
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, x, 1.0, x, 2.0, x, x, 3.0, x};
        RealVector v = this.create(data);
        double actual = v.getLInfNorm();
        double expected = 0.0;
        for (int i = 0; i < data.length; ++i) {
            expected = FastMath.max((double)expected, (double)FastMath.abs((double)data[i]));
        }
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    private void doTestMapBinaryOperation(BinaryOperation op, boolean inPlace) {
        double[] expected = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            RealVector actual;
            double d;
            block21: {
                RealVector v;
                block20: {
                    d = this.values[i];
                    block19: for (int j = 0; j < expected.length; ++j) {
                        switch (op) {
                            case ADD: {
                                expected[j] = this.values[j] + d;
                                continue block19;
                            }
                            case SUB: {
                                expected[j] = this.values[j] - d;
                                continue block19;
                            }
                            case MUL: {
                                expected[j] = this.values[j] * d;
                                continue block19;
                            }
                            case DIV: {
                                expected[j] = this.values[j] / d;
                                continue block19;
                            }
                            default: {
                                throw new AssertionError((Object)"unexpected value");
                            }
                        }
                    }
                    v = this.create(this.values);
                    if (!inPlace) break block20;
                    switch (op) {
                        case ADD: {
                            actual = v.mapAddToSelf(d);
                            break block21;
                        }
                        case SUB: {
                            actual = v.mapSubtractToSelf(d);
                            break block21;
                        }
                        case MUL: {
                            actual = v.mapMultiplyToSelf(d);
                            break block21;
                        }
                        case DIV: {
                            actual = v.mapDivideToSelf(d);
                            break block21;
                        }
                        default: {
                            throw new AssertionError((Object)"unexpected value");
                        }
                    }
                }
                switch (op) {
                    case ADD: {
                        actual = v.mapAdd(d);
                        break;
                    }
                    case SUB: {
                        actual = v.mapSubtract(d);
                        break;
                    }
                    case MUL: {
                        actual = v.mapMultiply(d);
                        break;
                    }
                    case DIV: {
                        actual = v.mapDivide(d);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"unexpected value");
                    }
                }
            }
            TestUtils.assertEquals(Double.toString(d), expected, actual, 0.0);
        }
    }

    @Test
    public void testMapAdd() {
        this.doTestMapBinaryOperation(BinaryOperation.ADD, false);
    }

    @Test
    public void testMapAddToSelf() {
        this.doTestMapBinaryOperation(BinaryOperation.ADD, true);
    }

    @Test
    public void testMapSubtract() {
        this.doTestMapBinaryOperation(BinaryOperation.SUB, false);
    }

    @Test
    public void testMapSubtractToSelf() {
        this.doTestMapBinaryOperation(BinaryOperation.SUB, true);
    }

    @Test
    public void testMapMultiply() {
        this.doTestMapBinaryOperation(BinaryOperation.MUL, false);
    }

    @Test
    public void testMapMultiplyToSelf() {
        this.doTestMapBinaryOperation(BinaryOperation.MUL, true);
    }

    @Test
    public void testMapDivide() {
        this.doTestMapBinaryOperation(BinaryOperation.DIV, false);
    }

    @Test
    public void testMapDivideToSelf() {
        this.doTestMapBinaryOperation(BinaryOperation.DIV, true);
    }

    private void doTestMapFunction(UnivariateFunction f, boolean inPlace) {
        RealVector actual;
        double[] data = new double[this.values.length + 6];
        System.arraycopy(this.values, 0, data, 0, this.values.length);
        data[this.values.length + 0] = 1.5707963267948966;
        data[this.values.length + 1] = -1.5707963267948966;
        data[this.values.length + 2] = Math.E;
        data[this.values.length + 3] = -2.718281828459045;
        data[this.values.length + 4] = 1.0;
        data[this.values.length + 5] = -1.0;
        double[] expected = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            expected[i] = f.value(data[i]);
        }
        RealVector v = this.create(data);
        if (inPlace) {
            actual = v.mapToSelf(f);
            Assert.assertSame((Object)v, (Object)actual);
        } else {
            actual = v.map(f);
        }
        TestUtils.assertEquals(f.getClass().getSimpleName(), expected, actual, 1.0E-16);
    }

    protected UnivariateFunction[] createFunctions() {
        return new UnivariateFunction[]{new Power(2.0), new Exp(), new Expm1(), new Log(), new Log10(), new Log1p(), new Cosh(), new Sinh(), new Tanh(), new Cos(), new Sin(), new Tan(), new Acos(), new Asin(), new Atan(), new Inverse(), new Abs(), new Sqrt(), new Cbrt(), new Ceil(), new Floor(), new Rint(), new Signum(), new Ulp()};
    }

    @Test
    public void testMap() {
        UnivariateFunction[] functions;
        for (UnivariateFunction f : functions = this.createFunctions()) {
            this.doTestMapFunction(f, false);
        }
    }

    @Test
    public void testMapToSelf() {
        UnivariateFunction[] functions;
        for (UnivariateFunction f : functions = this.createFunctions()) {
            this.doTestMapFunction(f, true);
        }
    }

    private void doTestOuterProduct(boolean mixed) {
        double[] dataU = this.values;
        RealVector u = this.create(dataU);
        double[] dataV = new double[this.values.length + 3];
        System.arraycopy(this.values, 0, dataV, 0, this.values.length);
        dataV[this.values.length] = 1.0;
        dataV[this.values.length] = -2.0;
        dataV[this.values.length] = 3.0;
        RealVector v = mixed ? this.createAlien(dataV) : this.create(dataV);
        RealMatrix uv = u.outerProduct(v);
        Assert.assertEquals((String)"number of rows", (long)dataU.length, (long)uv.getRowDimension());
        Assert.assertEquals((String)"number of columns", (long)dataV.length, (long)uv.getColumnDimension());
        for (int i = 0; i < dataU.length; ++i) {
            for (int j = 0; j < dataV.length; ++j) {
                double expected = dataU[i] * dataV[j];
                double actual = uv.getEntry(i, j);
                Assert.assertEquals((String)(dataU[i] + " * " + dataV[j]), (double)expected, (double)actual, (double)0.0);
            }
        }
    }

    @Test
    public void testOuterProductSameType() {
        this.doTestOuterProduct(false);
    }

    @Test
    public void testOuterProductMixedTypes() {
        this.doTestOuterProduct(true);
    }

    private void doTestProjection(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, 1.0, x, x, 2.0, x, x, x, 3.0, x, x, x, x};
        double[] data2 = new double[]{5.0, -6.0, 7.0, x, x, -8.0, -9.0, 10.0, 11.0, x, 12.0, 13.0, -15.0};
        double dotProduct = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            dotProduct += data1[i] * data2[i];
            norm2 += data2[i] * data2[i];
        }
        double s = dotProduct / norm2;
        double[] expected = new double[data1.length];
        for (int i = 0; i < data2.length; ++i) {
            expected[i] = s * data2[i];
        }
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        RealVector actual = v1.projection(v2);
        TestUtils.assertEquals("", expected, actual, 0.0);
    }

    @Test
    public void testProjectionSameType() {
        this.doTestProjection(false);
    }

    @Test
    public void testProjectionMixedTypes() {
        this.doTestProjection(true);
    }

    @Test(expected=MathArithmeticException.class)
    public void testProjectionNullVector() {
        this.create(new double[4]).projection(this.create(new double[4]));
    }

    @Test(expected=DimensionMismatchException.class)
    public void testProjectionDimensionMismatch() {
        RealVector v1 = this.create(new double[4]);
        RealVector v2 = this.create(new double[5]);
        v2.set(1.0);
        v1.projection(v2);
    }

    @Test
    public void testSet() {
        for (int i = 0; i < this.values.length; ++i) {
            double expected = this.values[i];
            RealVector v = this.create(this.values);
            v.set(expected);
            for (int j = 0; j < this.values.length; ++j) {
                Assert.assertEquals((String)("entry #" + j), (double)expected, (double)v.getEntry(j), (double)0.0);
            }
        }
    }

    @Test
    public void testToArray() {
        double[] data = this.create(this.values).toArray();
        Assert.assertNotSame((Object)this.values, (Object)data);
        for (int i = 0; i < this.values.length; ++i) {
            Assert.assertEquals((String)("entry #" + i), (double)this.values[i], (double)data[i], (double)0.0);
        }
    }

    private void doTestUnitVector(boolean inPlace) {
        RealVector actual;
        double x = this.getPreferredEntryValue();
        double[] data = new double[]{x, 1.0, x, x, 2.0, x, x, x, 3.0, x, x, x, x};
        double norm = 0.0;
        for (int i = 0; i < data.length; ++i) {
            norm += data[i] * data[i];
        }
        norm = FastMath.sqrt((double)norm);
        double[] expected = new double[data.length];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = data[i] / norm;
        }
        RealVector v = this.create(data);
        if (inPlace) {
            v.unitize();
            actual = v;
        } else {
            actual = v.unitVector();
            Assert.assertNotSame((Object)v, (Object)actual);
        }
        TestUtils.assertEquals("", expected, actual, 0.0);
    }

    @Test
    public void testUnitVector() {
        this.doTestUnitVector(false);
    }

    @Test
    public void testUnitize() {
        this.doTestUnitVector(true);
    }

    private void doTestUnitVectorNullVector(boolean inPlace) {
        double[] data = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        if (inPlace) {
            this.create(data).unitize();
        } else {
            this.create(data).unitVector();
        }
    }

    @Test(expected=ArithmeticException.class)
    public void testUnitVectorNullVector() {
        this.doTestUnitVectorNullVector(false);
    }

    @Test(expected=ArithmeticException.class)
    public void testUnitizeNullVector() {
        this.doTestUnitVectorNullVector(true);
    }

    @Test
    public void testIterator() {
        RealVector v = this.create(this.values);
        Iterator it = v.iterator();
        for (int i = 0; i < this.values.length; ++i) {
            Assert.assertTrue((String)("entry #" + i), (boolean)it.hasNext());
            RealVector.Entry e = (RealVector.Entry)it.next();
            Assert.assertEquals((String)"", (long)i, (long)e.getIndex());
            Assert.assertEquals((String)"", (double)this.values[i], (double)e.getValue(), (double)0.0);
            try {
                it.remove();
                Assert.fail((String)"UnsupportedOperationException should have been thrown");
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException should have been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void doTestCombine(boolean inPlace, boolean mixed) {
        int n = this.values.length * this.values.length;
        double[] data1 = new double[n];
        double[] data2 = new double[n];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values.length; ++j) {
                int index = this.values.length * i + j;
                data1[index] = this.values[i];
                data2[index] = this.values[j];
            }
        }
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double[] expected = new double[n];
        for (int i = 0; i < this.values.length; ++i) {
            double a1 = this.values[i];
            for (int j = 0; j < this.values.length; ++j) {
                RealVector actual;
                double a2 = this.values[j];
                for (int k = 0; k < n; ++k) {
                    expected[k] = a1 * data1[k] + a2 * data2[k];
                }
                if (inPlace) {
                    RealVector v1bis = v1.copy();
                    actual = v1bis.combineToSelf(a1, a2, v2);
                    Assert.assertSame((Object)v1bis, (Object)actual);
                } else {
                    actual = v1.combine(a1, a2, v2);
                }
                TestUtils.assertEquals("a1 = " + a1 + ", a2 = " + a2, expected, actual, 0.0);
            }
        }
    }

    private void doTestCombineDimensionMismatch(boolean inPlace, boolean mixed) {
        RealVector v1 = this.create(new double[10]);
        RealVector v2 = mixed ? this.createAlien(new double[15]) : this.create(new double[15]);
        if (inPlace) {
            v1.combineToSelf(1.0, 1.0, v2);
        } else {
            v1.combine(1.0, 1.0, v2);
        }
    }

    @Test
    public void testCombineSameType() {
        this.doTestCombine(false, false);
    }

    @Test
    public void testCombineMixedTypes() {
        this.doTestCombine(false, true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCombineDimensionMismatchSameType() {
        this.doTestCombineDimensionMismatch(false, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCombineDimensionMismatchMixedTypes() {
        this.doTestCombineDimensionMismatch(false, true);
    }

    @Test
    public void testCombineToSelfSameType() {
        this.doTestCombine(true, false);
    }

    @Test
    public void testCombineToSelfMixedTypes() {
        this.doTestCombine(true, true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCombineToSelfDimensionMismatchSameType() {
        this.doTestCombineDimensionMismatch(true, false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCombineToSelfDimensionMismatchMixedTypes() {
        this.doTestCombineDimensionMismatch(true, true);
    }

    @Test
    public void testCopy() {
        RealVector v = this.create(this.values);
        RealVector w = v.copy();
        Assert.assertNotSame((Object)v, (Object)w);
        TestUtils.assertEquals("", this.values, w, 0.0);
    }

    private void doTestDotProductRegularValues(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, 1.0, x, x, 2.0, x, x, x, 3.0, x, x, x, x};
        double[] data2 = new double[]{5.0, -6.0, 7.0, x, x, -8.0, -9.0, 10.0, 11.0, x, 12.0, 13.0, -15.0};
        double expected = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            expected += data1[i] * data2[i];
        }
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double actual = v1.dotProduct(v2);
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    private void doTestDotProductSpecialValues(boolean mixed) {
        for (int i = 0; i < this.values.length; ++i) {
            double[] data1 = new double[]{this.values[i]};
            RealVector v1 = this.create(data1);
            for (int j = 0; j < this.values.length; ++j) {
                double[] data2 = new double[]{this.values[j]};
                RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
                double expected = data1[0] * data2[0];
                double actual = v1.dotProduct(v2);
                Assert.assertEquals((String)(data1[0] + " * " + data2[0]), (double)expected, (double)actual, (double)0.0);
            }
        }
    }

    private void doTestDotProductDimensionMismatch(boolean mixed) {
        double[] data1 = new double[10];
        double[] data2 = new double[data1.length + 1];
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        v1.dotProduct(v2);
    }

    @Test
    public void testDotProductSameType() {
        this.doTestDotProductRegularValues(false);
        this.doTestDotProductSpecialValues(false);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDotProductDimensionMismatchSameType() {
        this.doTestDotProductDimensionMismatch(false);
    }

    @Test
    public void testDotProductMixedTypes() {
        this.doTestDotProductRegularValues(true);
        this.doTestDotProductSpecialValues(true);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDotProductDimensionMismatchMixedTypes() {
        this.doTestDotProductDimensionMismatch(true);
    }

    private void doTestCosine(boolean mixed) {
        double x = this.getPreferredEntryValue();
        double[] data1 = new double[]{x, 1.0, x, x, 2.0, x, x, x, 3.0, x, x, x, x};
        double[] data2 = new double[]{5.0, -6.0, 7.0, x, x, -8.0, -9.0, 10.0, 11.0, x, 12.0, 13.0, -15.0};
        double norm1 = 0.0;
        double norm2 = 0.0;
        double dotProduct = 0.0;
        for (int i = 0; i < data1.length; ++i) {
            norm1 += data1[i] * data1[i];
            norm2 += data2[i] * data2[i];
            dotProduct += data1[i] * data2[i];
        }
        norm1 = FastMath.sqrt((double)norm1);
        norm2 = FastMath.sqrt((double)norm2);
        double expected = dotProduct / (norm1 * norm2);
        RealVector v1 = this.create(data1);
        RealVector v2 = mixed ? this.createAlien(data2) : this.create(data2);
        double actual = v1.cosine(v2);
        Assert.assertEquals((String)"", (double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testCosineSameType() {
        this.doTestCosine(false);
    }

    @Test
    public void testCosineMixedTypes() {
        this.doTestCosine(true);
    }

    @Test(expected=MathArithmeticException.class)
    public void testCosineLeftNullVector() {
        RealVector v = this.create(new double[]{0.0, 0.0, 0.0});
        RealVector w = this.create(new double[]{1.0, 0.0, 0.0});
        v.cosine(w);
    }

    @Test(expected=MathArithmeticException.class)
    public void testCosineRightNullVector() {
        RealVector v = this.create(new double[]{0.0, 0.0, 0.0});
        RealVector w = this.create(new double[]{1.0, 0.0, 0.0});
        w.cosine(v);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCosineDimensionMismatch() {
        RealVector v = this.create(new double[]{1.0, 2.0, 3.0});
        RealVector w = this.create(new double[]{1.0, 2.0, 3.0, 4.0});
        v.cosine(w);
    }

    @Test
    public void testEquals() {
        RealVector v = this.create(new double[]{0.0, 1.0, 2.0});
        Assert.assertTrue((boolean)v.equals((Object)v));
        Assert.assertTrue((boolean)v.equals((Object)v.copy()));
        Assert.assertFalse((boolean)v.equals(null));
        Assert.assertFalse((boolean)v.equals((Object)v.getSubVector(0, v.getDimension() - 1)));
        Assert.assertTrue((boolean)v.equals((Object)v.getSubVector(0, v.getDimension())));
    }

    @Test
    public void testSerial() {
        RealVector v = this.create(new double[]{0.0, 1.0, 2.0});
        Assert.assertEquals((Object)v, (Object)TestUtils.serializeAndRecover(v));
    }

    @Test
    public void testMinMax() {
        RealVector v1 = this.create(new double[]{0.0, -6.0, 4.0, 12.0, 7.0});
        Assert.assertEquals((long)1L, (long)v1.getMinIndex());
        Assert.assertEquals((double)-6.0, (double)v1.getMinValue(), (double)1.0E-12);
        Assert.assertEquals((long)3L, (long)v1.getMaxIndex());
        Assert.assertEquals((double)12.0, (double)v1.getMaxValue(), (double)1.0E-12);
        RealVector v2 = this.create(new double[]{Double.NaN, 3.0, Double.NaN, -2.0});
        Assert.assertEquals((long)3L, (long)v2.getMinIndex());
        Assert.assertEquals((double)-2.0, (double)v2.getMinValue(), (double)1.0E-12);
        Assert.assertEquals((long)1L, (long)v2.getMaxIndex());
        Assert.assertEquals((double)3.0, (double)v2.getMaxValue(), (double)1.0E-12);
        RealVector v3 = this.create(new double[]{Double.NaN, Double.NaN});
        Assert.assertEquals((long)-1L, (long)v3.getMinIndex());
        Assert.assertTrue((boolean)Double.isNaN(v3.getMinValue()));
        Assert.assertEquals((long)-1L, (long)v3.getMaxIndex());
        Assert.assertTrue((boolean)Double.isNaN(v3.getMaxValue()));
        RealVector v4 = this.create(new double[0]);
        Assert.assertEquals((long)-1L, (long)v4.getMinIndex());
        Assert.assertTrue((boolean)Double.isNaN(v4.getMinValue()));
        Assert.assertEquals((long)-1L, (long)v4.getMaxIndex());
        Assert.assertTrue((boolean)Double.isNaN(v4.getMaxValue()));
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor1() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        RealVector v = this.create(data);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){
            private int expectedIndex;

            public void visit(int actualIndex, double actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public double end() {
                return 0.0;
            }
        };
        v.walkInDefaultOrder(visitor);
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor2() {
        RealVector v = this.create(new double[5]);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){

            public void visit(int index, double value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public double end() {
                return 0.0;
            }
        };
        try {
            v.walkInDefaultOrder(visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor3() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        int expectedStart = 2;
        int expectedEnd = 7;
        RealVector v = this.create(data);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){
            private int expectedIndex;

            public void visit(int actualIndex, double actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public double end() {
                return 0.0;
            }
        };
        v.walkInDefaultOrder(visitor, 2, 7);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor1() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        RealVector v = this.create(data);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, double actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public double end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return 0.0;
            }
        };
        v.walkInOptimizedOrder(visitor);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor2() {
        RealVector v = this.create(new double[5]);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){

            public void visit(int index, double value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public double end() {
                return 0.0;
            }
        };
        try {
            v.walkInOptimizedOrder(visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor3() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        int expectedStart = 2;
        int expectedEnd = 7;
        RealVector v = this.create(data);
        RealVectorPreservingVisitor visitor = new RealVectorPreservingVisitor(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, double actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                this.visited[actualIndex] = true;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public double end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return 0.0;
            }
        };
        v.walkInOptimizedOrder(visitor, 2, 7);
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor1() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        RealVector v = this.create(data);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){
            private int expectedIndex;

            public double visit(int actualIndex, double actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                ++this.expectedIndex;
                return (double)actualIndex + actualValue;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public double end() {
                return 0.0;
            }
        };
        v.walkInDefaultOrder(visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (double)((double)i + data[i]), (double)v.getEntry(i), (double)0.0);
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor2() {
        RealVector v = this.create(new double[5]);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){

            public double visit(int index, double value) {
                return 0.0;
            }

            public void start(int dimension, int start, int end) {
            }

            public double end() {
                return 0.0;
            }
        };
        try {
            v.walkInDefaultOrder(visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder(visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor3() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        int expectedStart = 2;
        int expectedEnd = 7;
        RealVector v = this.create(data);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){
            private int expectedIndex;

            public double visit(int actualIndex, double actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                ++this.expectedIndex;
                return (double)actualIndex + actualValue;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public double end() {
                return 0.0;
            }
        };
        v.walkInDefaultOrder(visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (double)((double)i + data[i]), (double)v.getEntry(i), (double)0.0);
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor1() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        RealVector v = this.create(data);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public double visit(int actualIndex, double actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                return (double)actualIndex + actualValue;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public double end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return 0.0;
            }
        };
        v.walkInOptimizedOrder(visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (double)((double)i + data[i]), (double)v.getEntry(i), (double)0.0);
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor2() {
        RealVector v = this.create(new double[5]);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){

            public double visit(int index, double value) {
                return 0.0;
            }

            public void start(int dimension, int start, int end) {
            }

            public double end() {
                return 0.0;
            }
        };
        try {
            v.walkInOptimizedOrder(visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder(visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor3() {
        final double[] data = new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        int expectedStart = 2;
        int expectedEnd = 7;
        RealVector v = this.create(data);
        RealVectorChangingVisitor visitor = new RealVectorChangingVisitor(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public double visit(int actualIndex, double actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (double)data[actualIndex], (double)actualValue, (double)0.0);
                this.visited[actualIndex] = true;
                return (double)actualIndex + actualValue;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public double end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return 0.0;
            }
        };
        v.walkInOptimizedOrder(visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (double)((double)i + data[i]), (double)v.getEntry(i), (double)0.0);
        }
    }

    public static class RealVectorTestImpl
    extends RealVector
    implements Serializable {
        private static final long serialVersionUID = 20120706L;
        protected double[] data;

        public RealVectorTestImpl(double[] d) {
            this.data = (double[])d.clone();
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Not supported, unneeded for test purposes");
        }

        public RealVector copy() {
            return new RealVectorTestImpl(this.data);
        }

        public RealVector ebeMultiply(RealVector v) {
            throw this.unsupported();
        }

        public RealVector ebeDivide(RealVector v) {
            throw this.unsupported();
        }

        public double getEntry(int index) {
            this.checkIndex(index);
            return this.data[index];
        }

        public int getDimension() {
            return this.data.length;
        }

        public RealVector append(RealVector v) {
            throw this.unsupported();
        }

        public RealVector append(double d) {
            throw this.unsupported();
        }

        public RealVector getSubVector(int index, int n) {
            throw this.unsupported();
        }

        public void setEntry(int index, double value) {
            this.checkIndex(index);
            this.data[index] = value;
        }

        public void setSubVector(int index, RealVector v) {
            throw this.unsupported();
        }

        public boolean isNaN() {
            throw this.unsupported();
        }

        public boolean isInfinite() {
            throw this.unsupported();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BinaryOperation {
        ADD,
        SUB,
        MUL,
        DIV;

    }
}

