/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.QRDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularMatrixException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class QRDecompositionTest {
    private double[][] testData3x3NonSingular = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}};
    private double[][] testData3x3Singular = new double[][]{{1.0, 4.0, 7.0}, {2.0, 5.0, 8.0}, {3.0, 6.0, 9.0}};
    private double[][] testData3x4 = new double[][]{{12.0, -51.0, 4.0, 1.0}, {6.0, 167.0, -68.0, 2.0}, {-4.0, 24.0, -41.0, 3.0}};
    private double[][] testData4x3 = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}, {-5.0, 34.0, 7.0}};
    private static final double entryTolerance = 1.0E-15;
    private static final double normTolerance = 1.0E-13;

    @Test
    public void testDimensions() {
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkDimension(this.createTestMatrix(r, p, q));
        this.checkDimension(this.createTestMatrix(r, q, p));
    }

    private void checkDimension(RealMatrix m) {
        int rows = m.getRowDimension();
        int columns = m.getColumnDimension();
        QRDecomposition qr = new QRDecomposition(m);
        Assert.assertEquals((long)rows, (long)qr.getQ().getRowDimension());
        Assert.assertEquals((long)rows, (long)qr.getQ().getColumnDimension());
        Assert.assertEquals((long)rows, (long)qr.getR().getRowDimension());
        Assert.assertEquals((long)columns, (long)qr.getR().getColumnDimension());
    }

    @Test
    public void testAEqualQR() {
        this.checkAEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkAEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular));
        this.checkAEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        this.checkAEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkAEqualQR(this.createTestMatrix(r, p, q));
        this.checkAEqualQR(this.createTestMatrix(r, q, p));
    }

    private void checkAEqualQR(RealMatrix m) {
        QRDecomposition qr = new QRDecomposition(m);
        double norm = qr.getQ().multiply(qr.getR()).subtract(m).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testQOrthogonal() {
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkQOrthogonal(this.createTestMatrix(r, p, q));
        this.checkQOrthogonal(this.createTestMatrix(r, q, p));
    }

    private void checkQOrthogonal(RealMatrix m) {
        QRDecomposition qr = new QRDecomposition(m);
        RealMatrix eye = MatrixUtils.createRealIdentityMatrix((int)m.getRowDimension());
        double norm = qr.getQT().multiply(qr.getQ()).subtract(eye).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testRUpperTriangular() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData4x3);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        matrix = this.createTestMatrix(r, p, q);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
        matrix = this.createTestMatrix(r, p, q);
        this.checkUpperTriangular(new QRDecomposition(matrix).getR());
    }

    private void checkUpperTriangular(RealMatrix m) {
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                if (column < row) {
                    Assert.assertEquals((double)0.0, (double)value, (double)1.0E-15);
                }
            }
        });
    }

    @Test
    public void testHTrapezoidal() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData4x3);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        matrix = this.createTestMatrix(r, p, q);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
        matrix = this.createTestMatrix(r, p, q);
        this.checkTrapezoidal(new QRDecomposition(matrix).getH());
    }

    private void checkTrapezoidal(RealMatrix m) {
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                if (column > row) {
                    Assert.assertEquals((double)0.0, (double)value, (double)1.0E-15);
                }
            }
        });
    }

    @Test
    public void testMatricesValues() {
        QRDecomposition qr = new QRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        RealMatrix qRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-0.8571428571428571, 0.3942857142857143, -0.3314285714285714}, {-0.42857142857142855, -0.9028571428571428, 0.03428571428571429}, {0.2857142857142857, -0.17142857142857143, -0.9428571428571428}});
        RealMatrix rRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-14.0, -21.0, 14.0}, {0.0, -175.0, 70.0}, {0.0, 0.0, 35.0}});
        RealMatrix hRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.8571428571428572, 0.0, 0.0}, {0.42857142857142855, 1.9938461538461538, 0.0}, {-0.2857142857142857, 0.11076923076923077, 2.0}});
        RealMatrix q = qr.getQ();
        Assert.assertEquals((double)0.0, (double)q.subtract(qRef).getNorm(), (double)1.0E-13);
        RealMatrix qT = qr.getQT();
        Assert.assertEquals((double)0.0, (double)qT.subtract(qRef.transpose()).getNorm(), (double)1.0E-13);
        RealMatrix r = qr.getR();
        Assert.assertEquals((double)0.0, (double)r.subtract(rRef).getNorm(), (double)1.0E-13);
        RealMatrix h = qr.getH();
        Assert.assertEquals((double)0.0, (double)h.subtract(hRef).getNorm(), (double)1.0E-13);
        Assert.assertTrue((q == qr.getQ() ? 1 : 0) != 0);
        Assert.assertTrue((r == qr.getR() ? 1 : 0) != 0);
        Assert.assertTrue((h == qr.getH() ? 1 : 0) != 0);
    }

    @Test(expected=SingularMatrixException.class)
    public void testNonInvertible() {
        QRDecomposition qr = new QRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular));
        qr.getSolver().getInverse();
    }

    @Test
    public void testInvertTallSkinny() {
        RealMatrix a = MatrixUtils.createRealMatrix((double[][])this.testData4x3);
        RealMatrix pinv = new QRDecomposition(a).getSolver().getInverse();
        Assert.assertEquals((double)0.0, (double)pinv.multiply(a).subtract(MatrixUtils.createRealIdentityMatrix((int)3)).getNorm(), (double)1.0E-6);
    }

    @Test
    public void testInvertShortWide() {
        RealMatrix a = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        RealMatrix pinv = new QRDecomposition(a).getSolver().getInverse();
        Assert.assertEquals((double)0.0, (double)a.multiply(pinv).subtract(MatrixUtils.createRealIdentityMatrix((int)3)).getNorm(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)pinv.multiply(a).getSubMatrix(0, 2, 0, 2).subtract(MatrixUtils.createRealIdentityMatrix((int)3)).getNorm(), (double)1.0E-6);
    }

    private RealMatrix createTestMatrix(final Random r, int rows, int columns) {
        RealMatrix m = MatrixUtils.createRealMatrix((int)rows, (int)columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return 2.0 * r.nextDouble() - 1.0;
            }
        });
        return m;
    }

    @Test(expected=SingularMatrixException.class)
    public void testQRSingular() {
        RealMatrix a = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 6.0, 4.0}, {2.0, 4.0, -1.0}, {-1.0, 2.0, 5.0}});
        ArrayRealVector b = new ArrayRealVector(new double[]{5.0, 6.0, 1.0});
        new QRDecomposition(a, 1.0E-15).getSolver().solve((RealVector)b);
    }
}

