/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.Fraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionField;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayFieldVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultFieldMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldLUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldMatrixImplTest {
    protected Fraction[][] id = new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(0), new Fraction(1), new Fraction(0)}, {new Fraction(0), new Fraction(0), new Fraction(1)}};
    protected Fraction[][] testData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(1), new Fraction(0), new Fraction(8)}};
    protected Fraction[][] testDataLU = new Fraction[][]{{new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(1, 2), new Fraction(-5, 2), new Fraction(13, 2)}, {new Fraction(1, 2), new Fraction(1, 5), new Fraction(1, 5)}};
    protected Fraction[][] testDataPlus2 = new Fraction[][]{{new Fraction(3), new Fraction(4), new Fraction(5)}, {new Fraction(4), new Fraction(7), new Fraction(5)}, {new Fraction(3), new Fraction(2), new Fraction(10)}};
    protected Fraction[][] testDataMinus = new Fraction[][]{{new Fraction(-1), new Fraction(-2), new Fraction(-3)}, {new Fraction(-2), new Fraction(-5), new Fraction(-3)}, {new Fraction(-1), new Fraction(0), new Fraction(-8)}};
    protected Fraction[] testDataRow1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] testDataCol3 = new Fraction[]{new Fraction(3), new Fraction(3), new Fraction(8)};
    protected Fraction[][] testDataInv = new Fraction[][]{{new Fraction(-40), new Fraction(16), new Fraction(9)}, {new Fraction(13), new Fraction(-5), new Fraction(-3)}, {new Fraction(5), new Fraction(-2), new Fraction(-1)}};
    protected Fraction[] preMultTest = new Fraction[]{new Fraction(8), new Fraction(12), new Fraction(33)};
    protected Fraction[][] testData2 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}};
    protected Fraction[][] testData2T = new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(2), new Fraction(5)}, {new Fraction(3), new Fraction(3)}};
    protected Fraction[][] testDataPlusInv = new Fraction[][]{{new Fraction(-39), new Fraction(18), new Fraction(12)}, {new Fraction(15), new Fraction(0), new Fraction(0)}, {new Fraction(6), new Fraction(-2), new Fraction(7)}};
    protected Fraction[][] luData = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(3)}, {new Fraction(0), new Fraction(5), new Fraction(7)}, {new Fraction(6), new Fraction(9), new Fraction(8)}};
    protected Fraction[][] luDataLUDecomposition = new Fraction[][]{{new Fraction(6), new Fraction(9), new Fraction(8)}, {new Fraction(0), new Fraction(5), new Fraction(7)}, {new Fraction(1, 3), new Fraction(0), new Fraction(1, 3)}};
    protected Fraction[][] singular = new Fraction[][]{{new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(3)}};
    protected Fraction[][] bigSingular = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(2), new Fraction(5), new Fraction(3), new Fraction(4)}, {new Fraction(7), new Fraction(3), new Fraction(256), new Fraction(1930)}, {new Fraction(3), new Fraction(7), new Fraction(6), new Fraction(8)}};
    protected Fraction[][] detData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(10)}};
    protected Fraction[][] detData2 = new Fraction[][]{{new Fraction(1), new Fraction(3)}, {new Fraction(2), new Fraction(4)}};
    protected Fraction[] testVector = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] testVector2 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)};
    protected Fraction[][] subTestData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(3, 2), new Fraction(5, 2), new Fraction(7, 2), new Fraction(9, 2)}, {new Fraction(2), new Fraction(4), new Fraction(6), new Fraction(8)}, {new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7)}};
    protected Fraction[][] subRows02Cols13 = new Fraction[][]{{new Fraction(2), new Fraction(4)}, {new Fraction(4), new Fraction(8)}};
    protected Fraction[][] subRows03Cols12 = new Fraction[][]{{new Fraction(2), new Fraction(3)}, {new Fraction(5), new Fraction(6)}};
    protected Fraction[][] subRows03Cols123 = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6), new Fraction(7)}};
    protected Fraction[][] subRows20Cols123 = new Fraction[][]{{new Fraction(4), new Fraction(6), new Fraction(8)}, {new Fraction(2), new Fraction(3), new Fraction(4)}};
    protected Fraction[][] subRows31Cols31 = new Fraction[][]{{new Fraction(7), new Fraction(5)}, {new Fraction(9, 2), new Fraction(5, 2)}};
    protected Fraction[][] subRows01Cols23 = new Fraction[][]{{new Fraction(3), new Fraction(4)}, {new Fraction(7, 2), new Fraction(9, 2)}};
    protected Fraction[][] subRows23Cols00 = new Fraction[][]{{new Fraction(2)}, {new Fraction(4)}};
    protected Fraction[][] subRows00Cols33 = new Fraction[][]{{new Fraction(4)}};
    protected Fraction[][] subRow0 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}};
    protected Fraction[][] subRow3 = new Fraction[][]{{new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7)}};
    protected Fraction[][] subColumn1 = new Fraction[][]{{new Fraction(2)}, {new Fraction(5, 2)}, {new Fraction(4)}, {new Fraction(5)}};
    protected Fraction[][] subColumn3 = new Fraction[][]{{new Fraction(4)}, {new Fraction(9, 2)}, {new Fraction(8)}, {new Fraction(7)}};
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    private Fraction[][] d3 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8)}};
    private Fraction[][] d4 = new Fraction[][]{{new Fraction(1)}, {new Fraction(2)}, {new Fraction(3)}, {new Fraction(4)}};
    private Fraction[][] d5 = new Fraction[][]{{new Fraction(30)}, {new Fraction(70)}};

    @Test
    public void testDimensions() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix((FieldElement[][])this.testData2);
        Assert.assertEquals((String)"testData row dimension", (long)3L, (long)m.getRowDimension());
        Assert.assertEquals((String)"testData column dimension", (long)3L, (long)m.getColumnDimension());
        Assert.assertTrue((String)"testData is square", (boolean)m.isSquare());
        Assert.assertEquals((String)"testData2 row dimension", (long)m2.getRowDimension(), (long)2L);
        Assert.assertEquals((String)"testData2 column dimension", (long)m2.getColumnDimension(), (long)3L);
        Assert.assertTrue((String)"testData2 is not square", (!m2.isSquare() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFunctions() {
        Array2DRowFieldMatrix m1 = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix(m1.getData());
        Assert.assertEquals((Object)m2, (Object)m1);
        Array2DRowFieldMatrix m3 = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m4 = new Array2DRowFieldMatrix(m3.getData(), false);
        Assert.assertEquals((Object)m4, (Object)m3);
    }

    @Test
    public void testAdd() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix mInv = new Array2DRowFieldMatrix((FieldElement[][])this.testDataInv);
        Array2DRowFieldMatrix mPlusMInv = m.add(mInv);
        Fraction[][] sumEntries = (Fraction[][])mPlusMInv.getData();
        for (int row = 0; row < m.getRowDimension(); ++row) {
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                Assert.assertEquals((Object)this.testDataPlusInv[row][col], (Object)sumEntries[row][col]);
            }
        }
    }

    @Test
    public void testAddFail() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix((FieldElement[][])this.testData2);
        try {
            m.add(m2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPlusMinus() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix((FieldElement[][])this.testDataInv);
        TestUtils.assertEquals(m.subtract(m2), m2.scalarMultiply((FieldElement)new Fraction(-1)).add((FieldMatrix)m));
        try {
            m.subtract(new Array2DRowFieldMatrix((FieldElement[][])this.testData2));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix mInv = new Array2DRowFieldMatrix((FieldElement[][])this.testDataInv);
        Array2DRowFieldMatrix identity = new Array2DRowFieldMatrix((FieldElement[][])this.id);
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix((FieldElement[][])this.testData2);
        TestUtils.assertEquals(m.multiply(mInv), identity);
        TestUtils.assertEquals(mInv.multiply(m), identity);
        TestUtils.assertEquals(m.multiply(identity), m);
        TestUtils.assertEquals(identity.multiply(mInv), mInv);
        TestUtils.assertEquals(m2.multiply(identity), m2);
        try {
            m.multiply(new Array2DRowFieldMatrix((FieldElement[][])this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply2() {
        Array2DRowFieldMatrix m3 = new Array2DRowFieldMatrix((FieldElement[][])this.d3);
        Array2DRowFieldMatrix m4 = new Array2DRowFieldMatrix((FieldElement[][])this.d4);
        Array2DRowFieldMatrix m5 = new Array2DRowFieldMatrix((FieldElement[][])this.d5);
        TestUtils.assertEquals(m3.multiply((FieldMatrix)m4), m5);
    }

    @Test
    public void testPower() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix mInv = new Array2DRowFieldMatrix((FieldElement[][])this.testDataInv);
        Array2DRowFieldMatrix mPlusInv = new Array2DRowFieldMatrix((FieldElement[][])this.testDataPlusInv);
        Array2DRowFieldMatrix identity = new Array2DRowFieldMatrix((FieldElement[][])this.id);
        TestUtils.assertEquals(m.power(0), identity);
        TestUtils.assertEquals(mInv.power(0), identity);
        TestUtils.assertEquals(mPlusInv.power(0), identity);
        TestUtils.assertEquals(m.power(1), m);
        TestUtils.assertEquals(mInv.power(1), mInv);
        TestUtils.assertEquals(mPlusInv.power(1), mPlusInv);
        FieldMatrix C1 = m.copy();
        FieldMatrix C2 = mInv.copy();
        FieldMatrix C3 = mPlusInv.copy();
        for (int i = 2; i <= 5; ++i) {
            C1 = C1.multiply((FieldMatrix)m);
            C2 = C2.multiply((FieldMatrix)mInv);
            C3 = C3.multiply((FieldMatrix)mPlusInv);
            TestUtils.assertEquals(m.power(i), C1);
            TestUtils.assertEquals(mInv.power(i), C2);
            TestUtils.assertEquals(mPlusInv.power(i), C3);
        }
        try {
            Array2DRowFieldMatrix mNotSquare = new Array2DRowFieldMatrix((FieldElement[][])this.testData2T);
            mNotSquare.power(2);
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
        try {
            m.power(-1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTrace() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.id);
        Assert.assertEquals((String)"identity trace", (Object)new Fraction(3), (Object)m.getTrace());
        m = new Array2DRowFieldMatrix((FieldElement[][])this.testData2);
        try {
            m.getTrace();
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testScalarAdd() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        TestUtils.assertEquals(new Array2DRowFieldMatrix((FieldElement[][])this.testDataPlus2), m.scalarAdd((FieldElement)new Fraction(2)));
    }

    @Test
    public void testOperate() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.id);
        TestUtils.assertEquals((FieldElement[])this.testVector, (FieldElement[])m.operate((FieldElement[])this.testVector));
        TestUtils.assertEquals((FieldElement[])this.testVector, (FieldElement[])m.operate((FieldVector)new ArrayFieldVector((FieldElement[])this.testVector)).toArray());
        m = new Array2DRowFieldMatrix((FieldElement[][])this.bigSingular);
        try {
            m.operate((FieldElement[])this.testVector);
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMath209() {
        Array2DRowFieldMatrix a = new Array2DRowFieldMatrix((FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6)}}, false);
        Fraction[] b = (Fraction[])a.operate((FieldElement[])new Fraction[]{new Fraction(1), new Fraction(1)});
        Assert.assertEquals((long)a.getRowDimension(), (long)b.length);
        Assert.assertEquals((Object)new Fraction(3), (Object)b[0]);
        Assert.assertEquals((Object)new Fraction(7), (Object)b[1]);
        Assert.assertEquals((Object)new Fraction(11), (Object)b[2]);
    }

    @Test
    public void testTranspose() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        FieldMatrix mIT = new FieldLUDecomposition((FieldMatrix)m).getSolver().getInverse().transpose();
        FieldMatrix mTI = new FieldLUDecomposition(m.transpose()).getSolver().getInverse();
        TestUtils.assertEquals(mIT, mTI);
        m = new Array2DRowFieldMatrix((FieldElement[][])this.testData2);
        Array2DRowFieldMatrix mt = new Array2DRowFieldMatrix((FieldElement[][])this.testData2T);
        TestUtils.assertEquals(mt, m.transpose());
    }

    @Test
    public void testPremultiplyVector() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        TestUtils.assertEquals((FieldElement[])m.preMultiply((FieldElement[])this.testVector), (FieldElement[])this.preMultTest);
        TestUtils.assertEquals((FieldElement[])m.preMultiply(new ArrayFieldVector((FieldElement[])this.testVector).getData()), (FieldElement[])this.preMultTest);
        m = new Array2DRowFieldMatrix((FieldElement[][])this.bigSingular);
        try {
            m.preMultiply((FieldElement[])this.testVector);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPremultiply() {
        Array2DRowFieldMatrix m3 = new Array2DRowFieldMatrix((FieldElement[][])this.d3);
        Array2DRowFieldMatrix m4 = new Array2DRowFieldMatrix((FieldElement[][])this.d4);
        Array2DRowFieldMatrix m5 = new Array2DRowFieldMatrix((FieldElement[][])this.d5);
        TestUtils.assertEquals(m4.preMultiply((FieldMatrix)m3), m5);
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix mInv = new Array2DRowFieldMatrix((FieldElement[][])this.testDataInv);
        Array2DRowFieldMatrix identity = new Array2DRowFieldMatrix((FieldElement[][])this.id);
        TestUtils.assertEquals(m.preMultiply((FieldMatrix)mInv), identity);
        TestUtils.assertEquals(mInv.preMultiply((FieldMatrix)m), identity);
        TestUtils.assertEquals(m.preMultiply((FieldMatrix)identity), m);
        TestUtils.assertEquals(identity.preMultiply((FieldMatrix)mInv), mInv);
        try {
            m.preMultiply((FieldMatrix)new Array2DRowFieldMatrix((FieldElement[][])this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetVectors() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        TestUtils.assertEquals((FieldElement[])m.getRow(0), (FieldElement[])this.testDataRow1);
        TestUtils.assertEquals((FieldElement[])m.getColumn(2), (FieldElement[])this.testDataCol3);
        try {
            m.getRow(10);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(-1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Assert.assertEquals((String)"get entry", (Object)m.getEntry(0, 1), (Object)new Fraction(2));
        try {
            m.getEntry(10, 4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testExamples() {
        Fraction[][] matrixData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}};
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])matrixData);
        Fraction[][] matrixData2 = new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(2), new Fraction(5)}, {new Fraction(1), new Fraction(7)}};
        Array2DRowFieldMatrix n = new Array2DRowFieldMatrix((FieldElement[][])matrixData2);
        FieldMatrix p = m.multiply((FieldMatrix)n);
        Assert.assertEquals((long)2L, (long)p.getRowDimension());
        Assert.assertEquals((long)2L, (long)p.getColumnDimension());
        FieldMatrix pInverse = new FieldLUDecomposition(p).getSolver().getInverse();
        Assert.assertEquals((long)2L, (long)pInverse.getRowDimension());
        Assert.assertEquals((long)2L, (long)pInverse.getColumnDimension());
        Fraction[][] coefficientsData = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(-2)}, {new Fraction(-1), new Fraction(7), new Fraction(6)}, {new Fraction(4), new Fraction(-3), new Fraction(-5)}};
        Array2DRowFieldMatrix coefficients = new Array2DRowFieldMatrix((FieldElement[][])coefficientsData);
        Fraction[] constants = new Fraction[]{new Fraction(1), new Fraction(-2), new Fraction(1)};
        Fraction[] solution = (Fraction[])new FieldLUDecomposition((FieldMatrix)coefficients).getSolver().solve((FieldVector)new ArrayFieldVector((FieldElement[])constants, false)).toArray();
        Assert.assertEquals((Object)new Fraction(2).multiply(solution[0]).add(new Fraction(3).multiply(solution[1])).subtract(new Fraction(2).multiply(solution[2])), (Object)constants[0]);
        Assert.assertEquals((Object)new Fraction(-1).multiply(solution[0]).add(new Fraction(7).multiply(solution[1])).add(new Fraction(6).multiply(solution[2])), (Object)constants[1]);
        Assert.assertEquals((Object)new Fraction(4).multiply(solution[0]).subtract(new Fraction(3).multiply(solution[1])).subtract(new Fraction(5).multiply(solution[2])), (Object)constants[2]);
    }

    @Test
    public void testGetSubMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows23Cols00, 2, 3, 0, 0);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows00Cols33, 0, 0, 3, 3);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows01Cols23, 0, 1, 2, 3);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, 1, 0, 2, 4);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, -1, 1, 2, 2);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, 1, 0, 2, 2);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, 1, 0, 2, 4);
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, new int[0], new int[]{0});
        this.checkGetSubMatrix((FieldMatrix<Fraction>)m, null, new int[]{0}, new int[]{4});
    }

    private void checkGetSubMatrix(FieldMatrix<Fraction> m, Fraction[][] reference, int startRow, int endRow, int startColumn, int endColumn) {
        block10: {
            try {
                FieldMatrix sub = m.getSubMatrix(startRow, endRow, startColumn, endColumn);
                if (reference != null) {
                    Assert.assertEquals((Object)new Array2DRowFieldMatrix((FieldElement[][])reference), (Object)sub);
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NotStrictlyPositiveException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NotStrictlyPositiveException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block10;
                throw e;
            }
        }
    }

    private void checkGetSubMatrix(FieldMatrix<Fraction> m, Fraction[][] reference, int[] selectedRows, int[] selectedColumns) {
        block10: {
            try {
                FieldMatrix sub = m.getSubMatrix(selectedRows, selectedColumns);
                if (reference != null) {
                    Assert.assertEquals((Object)new Array2DRowFieldMatrix((FieldElement[][])reference), (Object)sub);
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NotStrictlyPositiveException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NotStrictlyPositiveException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block10;
                throw e;
            }
        }
    }

    @Test
    public void testCopySubMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows23Cols00, 2, 3, 0, 0);
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows00Cols33, 0, 0, 3, 3);
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows01Cols23, 0, 1, 2, 3);
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3});
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2});
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3});
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3});
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkCopy((FieldMatrix<Fraction>)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkCopy((FieldMatrix<Fraction>)m, null, 1, 0, 2, 4);
        this.checkCopy((FieldMatrix<Fraction>)m, null, -1, 1, 2, 2);
        this.checkCopy((FieldMatrix<Fraction>)m, null, 1, 0, 2, 2);
        this.checkCopy((FieldMatrix<Fraction>)m, null, 1, 0, 2, 4);
        this.checkCopy((FieldMatrix<Fraction>)m, null, new int[0], new int[]{0});
        this.checkCopy((FieldMatrix<Fraction>)m, null, new int[]{0}, new int[]{4});
    }

    private void checkCopy(FieldMatrix<Fraction> m, Fraction[][] reference, int startRow, int endRow, int startColumn, int endColumn) {
        block8: {
            try {
                Fraction[][] sub = reference == null ? new Fraction[1][1] : new Fraction[reference.length][reference[0].length];
                m.copySubMatrix(startRow, endRow, startColumn, endColumn, (FieldElement[][])sub);
                if (reference != null) {
                    Assert.assertEquals((Object)new Array2DRowFieldMatrix((FieldElement[][])reference), (Object)new Array2DRowFieldMatrix((FieldElement[][])sub));
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    private void checkCopy(FieldMatrix<Fraction> m, Fraction[][] reference, int[] selectedRows, int[] selectedColumns) {
        block8: {
            try {
                Fraction[][] sub = reference == null ? new Fraction[1][1] : new Fraction[reference.length][reference[0].length];
                m.copySubMatrix(selectedRows, selectedColumns, (FieldElement[][])sub);
                if (reference != null) {
                    Assert.assertEquals((Object)new Array2DRowFieldMatrix((FieldElement[][])reference), (Object)new Array2DRowFieldMatrix((FieldElement[][])sub));
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    @Test
    public void testGetRowMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Array2DRowFieldMatrix mRow0 = new Array2DRowFieldMatrix((FieldElement[][])this.subRow0);
        Array2DRowFieldMatrix mRow3 = new Array2DRowFieldMatrix((FieldElement[][])this.subRow3);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowMatrix(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowMatrix(3));
        try {
            m.getRowMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Array2DRowFieldMatrix mRow3 = new Array2DRowFieldMatrix((FieldElement[][])this.subRow3);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowMatrix(0, (FieldMatrix)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowMatrix(0));
        try {
            m.setRowMatrix(-1, (FieldMatrix)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowMatrix(0, (FieldMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Array2DRowFieldMatrix mColumn1 = new Array2DRowFieldMatrix((FieldElement[][])this.subColumn1);
        Array2DRowFieldMatrix mColumn3 = new Array2DRowFieldMatrix((FieldElement[][])this.subColumn3);
        Assert.assertEquals((String)"Column1", (Object)mColumn1, (Object)m.getColumnMatrix(1));
        Assert.assertEquals((String)"Column3", (Object)mColumn3, (Object)m.getColumnMatrix(3));
        try {
            m.getColumnMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Array2DRowFieldMatrix mColumn3 = new Array2DRowFieldMatrix((FieldElement[][])this.subColumn3);
        Assert.assertNotSame((Object)mColumn3, (Object)m.getColumnMatrix(1));
        m.setColumnMatrix(1, (FieldMatrix)mColumn3);
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnMatrix(1));
        try {
            m.setColumnMatrix(-1, (FieldMatrix)mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnMatrix(0, (FieldMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowVector() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        ArrayFieldVector mRow0 = new ArrayFieldVector((FieldElement[])this.subRow0[0]);
        ArrayFieldVector mRow3 = new ArrayFieldVector((FieldElement[])this.subRow3[0]);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowVector(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowVector(3));
        try {
            m.getRowVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowVector() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        ArrayFieldVector mRow3 = new ArrayFieldVector((FieldElement[])this.subRow3[0]);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowVector(0, (FieldVector)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowVector(0));
        try {
            m.setRowVector(-1, (FieldVector)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowVector(0, (FieldVector)new ArrayFieldVector((Field)FractionField.getInstance(), 5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnVector() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        FieldVector<Fraction> mColumn1 = this.columnToVector(this.subColumn1);
        FieldVector<Fraction> mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertEquals((String)"Column1", mColumn1, (Object)m.getColumnVector(1));
        Assert.assertEquals((String)"Column3", mColumn3, (Object)m.getColumnVector(3));
        try {
            m.getColumnVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnVector() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        FieldVector<Fraction> mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertNotSame(mColumn3, (Object)m.getColumnVector(1));
        m.setColumnVector(1, mColumn3);
        Assert.assertEquals(mColumn3, (Object)m.getColumnVector(1));
        try {
            m.setColumnVector(-1, mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnVector(0, (FieldVector)new ArrayFieldVector((Field)FractionField.getInstance(), 5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    private FieldVector<Fraction> columnToVector(Fraction[][] column) {
        Fraction[] data = new Fraction[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return new ArrayFieldVector((FieldElement[])data, false);
    }

    @Test
    public void testGetRow() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        this.checkArrays(this.subRow0[0], (Fraction[])m.getRow(0));
        this.checkArrays(this.subRow3[0], (Fraction[])m.getRow(3));
        try {
            m.getRow(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRow(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRow() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Assert.assertTrue((this.subRow3[0][0] != ((Fraction[])m.getRow(0))[0] ? 1 : 0) != 0);
        m.setRow(0, (FieldElement[])this.subRow3[0]);
        this.checkArrays(this.subRow3[0], (Fraction[])m.getRow(0));
        try {
            m.setRow(-1, (FieldElement[])this.subRow3[0]);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRow(0, (FieldElement[])new Fraction[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumn() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Fraction[] mColumn1 = this.columnToArray(this.subColumn1);
        Fraction[] mColumn3 = this.columnToArray(this.subColumn3);
        this.checkArrays(mColumn1, (Fraction[])m.getColumn(1));
        this.checkArrays(mColumn3, (Fraction[])m.getColumn(3));
        try {
            m.getColumn(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumn() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.subTestData);
        Fraction[] mColumn3 = this.columnToArray(this.subColumn3);
        Assert.assertTrue((mColumn3[0] != ((Fraction[])m.getColumn(1))[0] ? 1 : 0) != 0);
        m.setColumn(1, (FieldElement[])mColumn3);
        this.checkArrays(mColumn3, (Fraction[])m.getColumn(1));
        try {
            m.setColumn(-1, (FieldElement[])mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumn(0, (FieldElement[])new Fraction[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    private Fraction[] columnToArray(Fraction[][] column) {
        Fraction[] data = new Fraction[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return data;
    }

    private void checkArrays(Fraction[] expected, Fraction[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Array2DRowFieldMatrix m1 = (Array2DRowFieldMatrix)m.copy();
        Array2DRowFieldMatrix mt = (Array2DRowFieldMatrix)m.transpose();
        Assert.assertTrue((m.hashCode() != mt.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)m.hashCode(), (long)m1.hashCode());
        Assert.assertEquals((Object)m, (Object)m);
        Assert.assertEquals((Object)m, (Object)m1);
        Assert.assertFalse((boolean)m.equals(null));
        Assert.assertFalse((boolean)m.equals((Object)mt));
        Assert.assertFalse((boolean)m.equals((Object)new Array2DRowFieldMatrix((FieldElement[][])this.bigSingular)));
    }

    @Test
    public void testToString() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Assert.assertEquals((Object)"Array2DRowFieldMatrix{{1,2,3},{2,5,3},{1,0,8}}", (Object)m.toString());
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance());
        Assert.assertEquals((Object)"Array2DRowFieldMatrix{}", (Object)m.toString());
    }

    @Test
    public void testSetSubMatrix() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        m.setSubMatrix((FieldElement[][])this.detData2, 1, 1);
        Array2DRowFieldMatrix expected = new Array2DRowFieldMatrix((FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(1), new Fraction(3)}, {new Fraction(1), new Fraction(2), new Fraction(4)}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix((FieldElement[][])this.detData2, 0, 0);
        expected = new Array2DRowFieldMatrix((FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(3), new Fraction(3)}, {new Fraction(2), new Fraction(4), new Fraction(3)}, {new Fraction(1), new Fraction(2), new Fraction(4)}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix((FieldElement[][])this.testDataPlus2, 0, 0);
        expected = new Array2DRowFieldMatrix((FieldElement[][])new Fraction[][]{{new Fraction(3), new Fraction(4), new Fraction(5)}, {new Fraction(4), new Fraction(7), new Fraction(5)}, {new Fraction(3), new Fraction(2), new Fraction(10)}});
        Assert.assertEquals((Object)expected, (Object)m);
        try {
            m.setSubMatrix((FieldElement[][])this.testData, 1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])this.testData, -1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])this.testData, 1, -1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])null, 1, 1);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        Array2DRowFieldMatrix m2 = new Array2DRowFieldMatrix((Field)FractionField.getInstance());
        try {
            m2.setSubMatrix((FieldElement[][])this.testData, 0, 1);
            Assert.fail((String)"expecting MathIllegalStateException");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        try {
            m2.setSubMatrix((FieldElement[][])this.testData, 1, 0);
            Assert.fail((String)"expecting MathIllegalStateException");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])new Fraction[][]{{new Fraction(1)}, {new Fraction(2), new Fraction(3)}}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])new Fraction[][]{new Fraction[0]}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWalk() {
        int j;
        int i;
        int rows = 150;
        int columns = 75;
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInRowOrder((FieldMatrixChangingVisitor)new SetVisitor());
        GetVisitor getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((FieldMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInRowOrder((FieldMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((FieldMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, 0));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, columns - 1));
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(0, j));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(rows - 1, j));
        }
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInColumnOrder((FieldMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((FieldMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInColumnOrder((FieldMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((FieldMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, 0));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, columns - 1));
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(0, j));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(rows - 1, j));
        }
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInOptimizedOrder((FieldMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInRowOrder((FieldMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInOptimizedOrder((FieldMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInRowOrder((FieldMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, 0));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, columns - 1));
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(0, j));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(rows - 1, j));
        }
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInOptimizedOrder((FieldMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((FieldMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), rows, columns);
        m.walkInOptimizedOrder((FieldMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((FieldMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, 0));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(i, columns - 1));
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(0, j));
            Assert.assertEquals((Object)new Fraction(0), (Object)m.getEntry(rows - 1, j));
        }
    }

    @Test
    public void testSerial() {
        Array2DRowFieldMatrix m = new Array2DRowFieldMatrix((FieldElement[][])this.testData);
        Assert.assertEquals((Object)m, (Object)TestUtils.serializeAndRecover(m));
    }

    protected void splitLU(FieldMatrix<Fraction> lu, Fraction[][] lowerData, Fraction[][] upperData) {
        if (!lu.isSquare()) {
            throw new NonSquareMatrixException(lu.getRowDimension(), lu.getColumnDimension());
        }
        if (lowerData.length != lowerData[0].length) {
            throw new DimensionMismatchException(lowerData.length, lowerData[0].length);
        }
        if (upperData.length != upperData[0].length) {
            throw new DimensionMismatchException(upperData.length, upperData[0].length);
        }
        if (lowerData.length != upperData.length) {
            throw new DimensionMismatchException(lowerData.length, upperData.length);
        }
        if (lowerData.length != lu.getRowDimension()) {
            throw new DimensionMismatchException(lowerData.length, lu.getRowDimension());
        }
        int n = lu.getRowDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j < i) {
                    lowerData[i][j] = (Fraction)lu.getEntry(i, j);
                    upperData[i][j] = Fraction.ZERO;
                    continue;
                }
                if (i == j) {
                    lowerData[i][j] = Fraction.ONE;
                    upperData[i][j] = (Fraction)lu.getEntry(i, j);
                    continue;
                }
                lowerData[i][j] = Fraction.ZERO;
                upperData[i][j] = (Fraction)lu.getEntry(i, j);
            }
        }
    }

    protected FieldMatrix<Fraction> permuteRows(FieldMatrix<Fraction> matrix, int[] permutation) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        if (matrix.getRowDimension() != permutation.length) {
            throw new DimensionMismatchException(matrix.getRowDimension(), permutation.length);
        }
        int n = matrix.getRowDimension();
        int m = matrix.getColumnDimension();
        Fraction[][] out = new Fraction[m][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                out[i][j] = (Fraction)matrix.getEntry(permutation[i], j);
            }
        }
        return new Array2DRowFieldMatrix((FieldElement[][])out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetVisitor
    extends DefaultFieldMatrixPreservingVisitor<Fraction> {
        private int count = 0;

        public GetVisitor() {
            super((FieldElement)Fraction.ZERO);
        }

        public void visit(int i, int j, Fraction value) {
            ++this.count;
            Assert.assertEquals((Object)new Fraction(i * 1024 + j, 1024), (Object)value);
        }

        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetVisitor
    extends DefaultFieldMatrixChangingVisitor<Fraction> {
        public SetVisitor() {
            super((FieldElement)Fraction.ZERO);
        }

        public Fraction visit(int i, int j, Fraction value) {
            return new Fraction(i * 1024 + j, 1024);
        }
    }
}

