/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Point;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.S1Point;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class S1PointTest {
    @Test
    public void testS1Point() {
        for (int k = -2; k < 3; ++k) {
            S1Point p = new S1Point(1.0 + (double)k * (Math.PI * 2));
            Assert.assertEquals((double)FastMath.cos((double)1.0), (double)p.getVector().getX(), (double)1.0E-10);
            Assert.assertEquals((double)FastMath.sin((double)1.0), (double)p.getVector().getY(), (double)1.0E-10);
            Assert.assertFalse((boolean)p.isNaN());
        }
    }

    @Test
    public void testNaN() {
        Assert.assertTrue((boolean)S1Point.NaN.isNaN());
        Assert.assertTrue((boolean)S1Point.NaN.equals((Object)new S1Point(Double.NaN)));
        Assert.assertFalse((boolean)new S1Point(1.0).equals((Object)S1Point.NaN));
    }

    @Test
    public void testEquals() {
        S1Point a = new S1Point(1.0);
        S1Point b = new S1Point(1.0);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertFalse((a == b ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals((Object)b));
        Assert.assertTrue((boolean)a.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)Character.valueOf('a')));
    }

    @Test
    public void testDistance() {
        S1Point a = new S1Point(1.0);
        S1Point b = new S1Point(a.getAlpha() + 1.5707963267948966);
        Assert.assertEquals((double)1.5707963267948966, (double)a.distance((Point)b), (double)1.0E-10);
    }

    @Test
    public void testSpace() {
        S1Point a = new S1Point(1.0);
        Assert.assertTrue((boolean)(a.getSpace() instanceof Sphere1D));
        Assert.assertEquals((long)1L, (long)a.getSpace().getDimension());
        try {
            a.getSpace().getSubSpace();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathUnsupportedOperationException mathUnsupportedOperationException) {
            // empty catch block
        }
    }
}

