/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.genetics;

import com.hazelcast.shaded.org.apache.commons.math3.genetics.BinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.BinaryMutation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.CrossoverPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.DummyBinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.ElitisticListPopulation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.FixedGenerationCount;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.GeneticAlgorithm;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.MutationPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.OnePointCrossover;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Population;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.SelectionPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.StoppingCondition;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.TournamentSelection;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FitnessCachingTest {
    private static final int DIMENSION = 50;
    private static final double CROSSOVER_RATE = 1.0;
    private static final double MUTATION_RATE = 0.1;
    private static final int TOURNAMENT_ARITY = 5;
    private static final int POPULATION_SIZE = 10;
    private static final int NUM_GENERATIONS = 50;
    private static final double ELITISM_RATE = 0.2;
    private static int fitnessCalls = 0;

    @Test
    public void testFitnessCaching() {
        GeneticAlgorithm ga = new GeneticAlgorithm((CrossoverPolicy)new OnePointCrossover(), 1.0, (MutationPolicy)new BinaryMutation(), 0.1, (SelectionPolicy)new TournamentSelection(5));
        ElitisticListPopulation initial = FitnessCachingTest.randomPopulation();
        FixedGenerationCount stopCond = new FixedGenerationCount(50);
        ga.evolve((Population)initial, (StoppingCondition)stopCond);
        int neededCalls = 402;
        Assert.assertTrue((fitnessCalls <= neededCalls ? 1 : 0) != 0);
    }

    private static ElitisticListPopulation randomPopulation() {
        LinkedList<DummyCountingBinaryChromosome> popList = new LinkedList<DummyCountingBinaryChromosome>();
        for (int i = 0; i < 10; ++i) {
            DummyCountingBinaryChromosome randChrom = new DummyCountingBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)50));
            popList.add(randChrom);
        }
        return new ElitisticListPopulation(popList, popList.size(), 0.2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyCountingBinaryChromosome
    extends DummyBinaryChromosome {
        public DummyCountingBinaryChromosome(List<Integer> representation) {
            super(representation);
        }

        @Override
        public double fitness() {
            fitnessCalls++;
            return 0.0;
        }
    }
}

