/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.genetics;

import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Chromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.ElitisticListPopulation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Population;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ElitisticListPopulationTest {
    private static int counter = 0;

    @Test
    public void testNextGeneration() {
        ElitisticListPopulation pop = new ElitisticListPopulation(100, 0.203);
        for (int i = 0; i < pop.getPopulationLimit(); ++i) {
            pop.addChromosome((Chromosome)new DummyChromosome());
        }
        Population nextGeneration = pop.nextGeneration();
        Assert.assertEquals((long)20L, (long)nextGeneration.getPopulationSize());
    }

    @Test
    public void testSetElitismRate() {
        double rate = 0.25;
        ElitisticListPopulation pop = new ElitisticListPopulation(100, 0.203);
        pop.setElitismRate(0.25);
        Assert.assertEquals((double)0.25, (double)pop.getElitismRate(), (double)1.0E-6);
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetElitismRateTooLow() {
        double rate = -0.25;
        ElitisticListPopulation pop = new ElitisticListPopulation(100, 0.203);
        pop.setElitismRate(-0.25);
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetElitismRateTooHigh() {
        double rate = 1.25;
        ElitisticListPopulation pop = new ElitisticListPopulation(100, 0.203);
        pop.setElitismRate(1.25);
    }

    @Test(expected=OutOfRangeException.class)
    public void testConstructorTooLow() {
        double rate = -0.25;
        new ElitisticListPopulation(100, -0.25);
    }

    @Test(expected=OutOfRangeException.class)
    public void testConstructorTooHigh() {
        double rate = 1.25;
        new ElitisticListPopulation(100, 1.25);
    }

    @Test(expected=OutOfRangeException.class)
    public void testChromosomeListConstructorTooLow() {
        List chromosomes = Collections.emptyList();
        double rate = -0.25;
        new ElitisticListPopulation(chromosomes, 100, -0.25);
    }

    @Test(expected=OutOfRangeException.class)
    public void testChromosomeListConstructorTooHigh() {
        List chromosomes = Collections.emptyList();
        double rate = 1.25;
        new ElitisticListPopulation(chromosomes, 100, 1.25);
    }

    static /* synthetic */ int access$000() {
        return counter;
    }

    private static class DummyChromosome
    extends Chromosome {
        private final int fitness = ElitisticListPopulationTest.access$000();

        public DummyChromosome() {
            counter++;
        }

        public double fitness() {
            return this.fitness;
        }
    }
}

