/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.CircleVectorial;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.StatisticalReferenceDataset;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.StatisticalReferenceDatasetFactory;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DiagonalMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.SimpleVectorValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLeastSquaresOptimizerAbstractTest {
    public static final double TOl = 1.0E-10;
    public final LeastSquaresOptimizer optimizer = this.getOptimizer();
    private final double[][] circlePoints = new double[][]{{-0.312967, 0.072366}, {-0.339248, 0.132965}, {-0.37978, 0.202724}, {-0.390426, 0.260487}, {-0.361212, 0.328325}, {-0.346039, 0.392619}, {-0.280579, 0.444306}, {-0.216035, 0.470009}, {-0.149127, 0.493832}, {-0.075133, 0.483271}, {-0.007759, 0.45268}, {0.060071, 0.410235}, {0.103037, 0.341076}, {0.118438, 0.273884}, {0.131293, 0.192201}, {0.115869, 0.129797}, {0.072223, 0.058396}, {0.022884, 7.18E-4}, {-0.053355, -0.020405}, {-0.123584, -0.032451}, {-0.216248, -0.032862}, {-0.278592, -0.005008}, {-0.337655, 0.056658}, {-0.385899, 0.112526}, {-0.405517, 0.186957}, {-0.415374, 0.262071}, {-0.387482, 0.343398}, {-0.347322, 0.397943}, {-0.287623, 0.458425}, {-0.223502, 0.475513}, {-0.135352, 0.478186}, {-0.061221, 0.483371}, {0.003711, 0.422737}, {0.065054, 0.37583}, {0.108108, 0.297099}, {0.123882, 0.22285}, {0.117729, 0.134382}, {0.085195, 0.05682}, {0.0298, -0.019138}, {-0.02752, -0.072374}, {-0.102268, -0.091555}, {-0.200299, -0.106578}, {-0.292731, -0.091473}, {-0.356288, -0.051108}, {-0.420561, 0.014926}, {-0.471036, 0.074716}, {-0.488638, 0.182508}, {-0.48599, 0.254068}, {-0.463943, 0.338438}, {-0.406453, 0.404704}, {-0.334287, 0.466119}, {-0.254244, 0.503188}, {-0.161548, 0.495769}, {-0.075733, 0.49556}, {0.001375, 0.434937}, {0.082787, 0.385806}, {0.11549, 0.323807}, {0.141089, 0.22345}, {0.138693, 0.131703}, {0.126415, 0.049174}, {0.066518, -0.010217}, {-0.005184, -0.070647}, {-0.080985, -0.103635}, {-0.177377, -0.116887}, {-0.260628, -0.100258}, {-0.335756, -0.056251}, {-0.405195, -8.95E-4}, {-0.444937, 0.085456}, {-0.484357, 0.175597}, {-0.472453, 0.248681}, {-0.43858, 0.347463}, {-0.402304, 0.422428}, {-0.326777, 0.479438}, {-0.247797, 0.505581}, {-0.152676, 0.51938}, {-0.071754, 0.516264}, {0.015942, 0.472802}, {0.076608, 0.419077}, {0.127673, 0.330264}, {0.159951, 0.26215}, {0.15353, 0.172681}, {0.140653, 0.089229}, {0.078666, 0.024981}, {0.023807, -0.037022}, {-0.048837, -0.077056}, {-0.127729, -0.075338}, {-0.221271, -0.067526}};

    public LeastSquaresBuilder base() {
        return new LeastSquaresBuilder().checkerPair((ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6)).maxEvaluations(100).maxIterations(this.getMaxIterations());
    }

    public LeastSquaresBuilder builder(CircleVectorial c) {
        double[] weights = new double[c.getN()];
        Arrays.fill(weights, 1.0);
        return this.base().model(c.getModelFunction(), c.getModelFunctionJacobian()).target(new double[c.getN()]).weight((RealMatrix)new DiagonalMatrix(weights));
    }

    public LeastSquaresBuilder builder(StatisticalReferenceDataset dataset) {
        StatisticalReferenceDataset.LeastSquaresProblem problem = dataset.getLeastSquaresProblem();
        double[] weights = new double[dataset.getNumObservations()];
        Arrays.fill(weights, 1.0);
        return this.base().model(problem.getModelFunction(), problem.getModelFunctionJacobian()).target(dataset.getData()[1]).weight((RealMatrix)new DiagonalMatrix(weights)).start(dataset.getStartingPoint(0));
    }

    public void fail(LeastSquaresOptimizer optimizer) {
        Assert.fail((String)("Expected Exception from: " + optimizer.toString()));
    }

    public void assertEquals(double tolerance, RealVector actual, double ... expected) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual.getEntry(i), (double)tolerance);
        }
        Assert.assertEquals((long)expected.length, (long)actual.getDimension());
    }

    public abstract int getMaxIterations();

    public abstract LeastSquaresOptimizer getOptimizer();

    @Test
    public void testGetIterations() {
        LeastSquaresProblem lsp = this.base().target(new double[]{1.0}).weight((RealMatrix)new DiagonalMatrix(new double[]{1.0})).start(new double[]{3.0}).model(new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                return new Pair((Object)new ArrayRealVector(new double[]{FastMath.pow((double)point.getEntry(0), (int)4)}, false), (Object)new Array2DRowRealMatrix((double[][])new double[][]{{0.25 * FastMath.pow((double)point.getEntry(0), (int)3)}}, false));
            }
        }).build();
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(lsp);
        Assert.assertTrue((optimum.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        LeastSquaresProblem ls = problem.getBuilder().build();
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(ls);
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 1.5);
        Assert.assertEquals((double)0.0, (double)optimum.getResiduals().getEntry(0), (double)1.0E-10);
    }

    @Test
    public void testQRColumnsPermutation() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, -1.0}, {0.0, 2.0}, {1.0, -2.0}}, new double[]{4.0, 6.0, 1.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 7.0, 3.0);
        this.assertEquals(1.0E-10, optimum.getResiduals(), 0.0, 0.0, 0.0);
    }

    @Test
    public void testNoDependency() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 2.0}}, new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        for (int i = 0; i < problem.target.length; ++i) {
            Assert.assertEquals((double)(0.55 * (double)i), (double)optimum.getPoint().getEntry(i), (double)1.0E-10);
        }
    }

    @Test
    public void testOneSet() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}}, new double[]{1.0, 1.0, 1.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 1.0, 2.0, 3.0);
    }

    @Test
    public void testTwoSets() {
        double epsilon = 1.0E-7;
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 1.0, 0.0, 4.0, 0.0, 0.0}, {-4.0, -2.0, 3.0, -7.0, 0.0, 0.0}, {4.0, 1.0, -2.0, 8.0, 0.0, 0.0}, {0.0, -3.0, -12.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, epsilon, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0}}, new double[]{2.0, -9.0, 2.0, 2.0, 1.0 + epsilon * epsilon, 2.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 3.0, 4.0, -1.0, -2.0, 1.0 + epsilon, 1.0 - epsilon);
    }

    @Test
    public void testNonInvertible() throws Exception {
        try {
            LinearProblem problem = new LinearProblem(new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
            this.optimizer.optimize(problem.getBuilder().build());
            this.fail(this.optimizer);
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
    }

    @Test
    public void testIllConditioned() {
        LinearProblem problem1 = new LinearProblem(new double[][]{{10.0, 7.0, 8.0, 7.0}, {7.0, 5.0, 6.0, 5.0}, {8.0, 6.0, 10.0, 9.0}, {7.0, 5.0, 9.0, 10.0}}, new double[]{32.0, 23.0, 33.0, 31.0});
        double[] start = new double[]{0.0, 1.0, 2.0, 3.0};
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem1.getBuilder().start(start).build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 1.0, 1.0, 1.0, 1.0);
        LinearProblem problem2 = new LinearProblem(new double[][]{{10.0, 7.0, 8.1, 7.2}, {7.08, 5.04, 6.0, 5.0}, {8.0, 5.98, 9.89, 9.0}, {6.99, 4.99, 9.0, 9.98}}, new double[]{32.0, 23.0, 33.0, 31.0});
        optimum = this.optimizer.optimize(problem2.getBuilder().start(start).build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-8, optimum.getPoint(), -81.0, 137.0, -34.0, 22.0);
    }

    @Test
    public void testMoreEstimatedParametersSimple() {
        LinearProblem problem = new LinearProblem(new double[][]{{3.0, 2.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 1.0}, {2.0, 0.0, 1.0, 0.0}}, new double[]{7.0, 3.0, 5.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().start(new double[]{7.0, 6.0, 5.0, 4.0}).build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
    }

    @Test
    public void testMoreEstimatedParametersUnsorted() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, -1.0}, {0.0, 0.0, -1.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, -1.0, 1.0, 0.0}}, new double[]{3.0, 12.0, -1.0, 7.0, 1.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().start(new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0}).build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        RealVector point = optimum.getPoint();
        Assert.assertEquals((double)3.0, (double)(point.getEntry(0) + point.getEntry(1)), (double)1.0E-10);
        this.assertEquals(1.0E-10, point.getSubVector(2, 4), 3.0, 4.0, 5.0, 6.0);
    }

    @Test
    public void testRedundantEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 5.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().start(new double[]{1.0, 1.0}).build());
        Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
        this.assertEquals(1.0E-10, optimum.getPoint(), 2.0, 1.0);
    }

    @Test
    public void testInconsistentEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 4.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().start(new double[]{1.0, 1.0}).build());
        Assert.assertTrue((optimum.getRMS() > 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testInconsistentSizes1() {
        try {
            LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0}, {0.0, 1.0}}, new double[]{-1.0, 1.0});
            LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
            Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
            this.assertEquals(1.0E-10, optimum.getPoint(), -1.0, 1.0);
            this.optimizer.optimize(problem.getBuilder().weight((RealMatrix)new DiagonalMatrix(new double[]{1.0})).build());
            this.fail(this.optimizer);
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testInconsistentSizes2() {
        try {
            LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0}, {0.0, 1.0}}, new double[]{-1.0, 1.0});
            LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
            Assert.assertEquals((double)0.0, (double)optimum.getRMS(), (double)1.0E-10);
            this.assertEquals(1.0E-10, optimum.getPoint(), -1.0, 1.0);
            this.optimizer.optimize(problem.getBuilder().target(new double[]{1.0}).weight((RealMatrix)new DiagonalMatrix(new double[]{1.0})).build());
            this.fail(this.optimizer);
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testCircleFitting() {
        CircleVectorial circle = new CircleVectorial();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        double[] start = new double[]{98.68, 47.345};
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(circle).start(start).build());
        Assert.assertTrue((optimum.getEvaluations() < 10 ? 1 : 0) != 0);
        double rms = optimum.getRMS();
        Assert.assertEquals((double)1.768262623567235, (double)(FastMath.sqrt((double)circle.getN()) * rms), (double)1.0E-10);
        Vector2D center = new Vector2D(optimum.getPoint().getEntry(0), optimum.getPoint().getEntry(1));
        Assert.assertEquals((double)69.96016176931406, (double)circle.getRadius(center), (double)1.0E-6);
        Assert.assertEquals((double)96.07590211815305, (double)center.getX(), (double)1.0E-6);
        Assert.assertEquals((double)48.13516790438953, (double)center.getY(), (double)1.0E-6);
        double[][] cov = optimum.getCovariances(1.0E-14).getData();
        Assert.assertEquals((double)1.839, (double)cov[0][0], (double)0.001);
        Assert.assertEquals((double)0.731, (double)cov[0][1], (double)0.001);
        Assert.assertEquals((double)cov[0][1], (double)cov[1][0], (double)1.0E-14);
        Assert.assertEquals((double)0.786, (double)cov[1][1], (double)0.001);
        double r = circle.getRadius(center);
        for (double d = 0.0; d < Math.PI * 2; d += 0.01) {
            circle.addPoint(center.getX() + r * FastMath.cos((double)d), center.getY() + r * FastMath.sin((double)d));
        }
        double[] weights = new double[circle.getN()];
        Arrays.fill(weights, 2.0);
        optimum = this.optimizer.optimize(this.builder(circle).weight((RealMatrix)new DiagonalMatrix(weights)).start(start).build());
        cov = optimum.getCovariances(1.0E-14).getData();
        Assert.assertEquals((double)0.0016, (double)cov[0][0], (double)0.001);
        Assert.assertEquals((double)3.2E-7, (double)cov[0][1], (double)1.0E-9);
        Assert.assertEquals((double)cov[0][1], (double)cov[1][0], (double)1.0E-14);
        Assert.assertEquals((double)0.0016, (double)cov[1][1], (double)0.001);
    }

    @Test
    public void testCircleFittingBadInit() {
        CircleVectorial circle = new CircleVectorial();
        double[][] points = this.circlePoints;
        double[] weights = new double[points.length];
        double[] start = new double[]{-12.0, -12.0};
        Arrays.fill(weights, 2.0);
        for (int i = 0; i < points.length; ++i) {
            circle.addPoint(points[i][0], points[i][1]);
        }
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(circle).weight((RealMatrix)new DiagonalMatrix(weights)).start(start).build());
        Vector2D center = new Vector2D(optimum.getPoint().getEntry(0), optimum.getPoint().getEntry(1));
        Assert.assertTrue((optimum.getEvaluations() < 25 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.043, (double)optimum.getRMS(), (double)0.001);
        Assert.assertEquals((double)0.292235, (double)circle.getRadius(center), (double)1.0E-6);
        Assert.assertEquals((double)-0.151738, (double)center.getX(), (double)1.0E-6);
        Assert.assertEquals((double)0.2075001, (double)center.getY(), (double)1.0E-6);
    }

    @Test
    public void testCircleFittingGoodInit() {
        CircleVectorial circle = new CircleVectorial();
        double[][] points = this.circlePoints;
        double[] weights = new double[points.length];
        Arrays.fill(weights, 2.0);
        for (int i = 0; i < points.length; ++i) {
            circle.addPoint(points[i][0], points[i][1]);
        }
        double[] start = new double[]{0.0, 0.0};
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(circle).weight((RealMatrix)new DiagonalMatrix(weights)).start(start).build());
        this.assertEquals(1.0E-6, optimum.getPoint(), -0.1517383071957963, 0.2074999736353867);
        Assert.assertEquals((double)0.04268731682389561, (double)optimum.getRMS(), (double)1.0E-8);
    }

    public void doTestStRD(StatisticalReferenceDataset dataset, LeastSquaresOptimizer optimizer, double errParams, double errParamsSd) {
        LeastSquaresOptimizer.Optimum optimum = optimizer.optimize(this.builder(dataset).build());
        RealVector actual = optimum.getPoint();
        for (int i = 0; i < actual.getDimension(); ++i) {
            double expected = dataset.getParameter(i);
            double delta = FastMath.abs((double)(errParams * expected));
            Assert.assertEquals((String)(dataset.getName() + ", param #" + i), (double)expected, (double)actual.getEntry(i), (double)delta);
        }
    }

    @Test
    public void testKirby2() throws IOException {
        this.doTestStRD(StatisticalReferenceDatasetFactory.createKirby2(), this.optimizer, 1.0E-7, 1.0E-7);
    }

    @Test
    public void testHahn1() throws IOException {
        this.doTestStRD(StatisticalReferenceDatasetFactory.createHahn1(), this.optimizer, 1.0E-7, 1.0E-4);
    }

    @Test
    public void testPointCopy() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}}, new double[]{1.0, 1.0, 1.0});
        final boolean[] checked = new boolean[]{false};
        LeastSquaresBuilder builder = problem.getBuilder().checker((ConvergenceChecker)new ConvergenceChecker<LeastSquaresProblem.Evaluation>(){

            public boolean converged(int iteration, LeastSquaresProblem.Evaluation previous, LeastSquaresProblem.Evaluation current) {
                Assert.assertThat((Object)previous.getPoint(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)current.getPoint())));
                Assert.assertArrayEquals((double[])new double[3], (double[])previous.getPoint().toArray(), (double)0.0);
                Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0}, (double[])current.getPoint().toArray(), (double)1.0E-10);
                checked[0] = true;
                return true;
            }
        });
        this.optimizer.optimize(builder.build());
        Assert.assertThat((Object)checked[0], (Matcher)CoreMatchers.is((Object)true));
    }

    class LinearProblem {
        private final RealMatrix factors;
        private final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public double[] getTarget() {
            return this.target;
        }

        public MultivariateVectorFunction getModelFunction() {
            return new MultivariateVectorFunction(){

                public double[] value(double[] params) {
                    return LinearProblem.this.factors.operate(params);
                }
            };
        }

        public MultivariateMatrixFunction getModelFunctionJacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] params) {
                    return LinearProblem.this.factors.getData();
                }
            };
        }

        public LeastSquaresBuilder getBuilder() {
            double[] weights = new double[this.target.length];
            Arrays.fill(weights, 1.0);
            return AbstractLeastSquaresOptimizerAbstractTest.this.base().model(this.getModelFunction(), this.getModelFunctionJacobian()).target(this.target).weight((RealMatrix)new DiagonalMatrix(weights)).start(new double[this.factors.getColumnDimension()]);
        }
    }
}

