/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.ParetoDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class ParetoDistributionTest
extends RealDistributionAbstractTest {
    public ParetoDistribution makeDistribution() {
        return new ParetoDistribution(2.1, 1.4);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-2.226325228634938, -1.156887023657177, -0.643949578356075, -0.2027950777320613, 0.305827808237559, 6.42632522863494, 5.35688702365718, 4.843949578356074, 4.40279507773206, 3.89417219176244};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.791089998892, 0.730456085931, 0.689667290488, 0.645278794701, 0.578763688757};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0455118580441, 0.070444173646, 0.0896924681582, 0.112794186114, 0.151439332084};
    }

    public double[] makeInverseCumulativeTestPoints() {
        double[] points = this.makeCumulativeTestValues();
        double[] points2 = new double[points.length - 5];
        System.arraycopy(points, 5, points2, 0, points.length - 5);
        return points2;
    }

    public double[] makeInverseCumulativeTestValues() {
        double[] points = this.makeCumulativeTestPoints();
        double[] points2 = new double[points.length - 5];
        System.arraycopy(points, 5, points2, 0, points.length - 5);
        return points2;
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    private void verifyQuantiles() {
        ParetoDistribution distribution = (ParetoDistribution)this.getDistribution();
        double mu = distribution.getScale();
        double sigma = distribution.getShape();
        this.setCumulativeTestPoints(new double[]{mu - 2.0 * sigma, mu - sigma, mu, mu + sigma, mu + 2.0 * sigma, mu + 3.0 * sigma, mu + 4.0 * sigma, mu + 5.0 * sigma});
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testQuantiles() {
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.510884134236, 0.694625688662, 0.785201995008, 0.837811522357, 0.871634279326});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.666666666, 0.195646346305, 0.0872498032394, 0.0477328899983, 0.0294888141169, 0.0197485724114});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new ParetoDistribution(1.0, 1.0));
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.5, 0.666666666667, 0.75, 0.8, 0.833333333333});
        this.setDensityTestValues(new double[]{0.0, 0.0, 1.0, 0.25, 0.111111111111, 0.0625, 0.04, 0.0277777777778});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new ParetoDistribution(0.1, 0.1));
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.0669670084632, 0.104041540159, 0.129449436704, 0.148660077479, 0.164041197922});
        this.setDensityTestValues(new double[]{0.0, 0.0, 1.0, 0.466516495768, 0.298652819947, 0.217637640824, 0.170267984504, 0.139326467013});
        this.verifyQuantiles();
        this.verifyDensities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{2.1, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testGetScale() {
        ParetoDistribution distribution = (ParetoDistribution)this.getDistribution();
        Assert.assertEquals((double)2.1, (double)distribution.getScale(), (double)0.0);
    }

    @Test
    public void testGetShape() {
        ParetoDistribution distribution = (ParetoDistribution)this.getDistribution();
        Assert.assertEquals((double)1.4, (double)distribution.getShape(), (double)0.0);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new ParetoDistribution(1.0, 0.0);
    }

    @Test
    public void testDensity() {
        double[] x = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0};
        this.checkDensity(1.0, 1.0, x, new double[]{0.0, 0.0, 0.0, 1.0, 0.25});
        this.checkDensity(1.1, 1.0, x, new double[]{0.0, 0.0, 0.0, 0.0, 0.275});
    }

    private void checkDensity(double scale, double shape, double[] x, double[] expected) {
        ParetoDistribution d = new ParetoDistribution(scale, shape);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)d.density(x[i]), (double)1.0E-9);
        }
    }

    @Test
    public void testExtremeValues() {
        ParetoDistribution d = new ParetoDistribution(1.0, 1.0);
        int i = 0;
        while ((double)i < 100000.0) {
            double upperTail = d.cumulativeProbability((double)i);
            if (i <= 1000) {
                Assert.assertTrue((upperTail < 1.0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((upperTail > 0.999 ? 1 : 0) != 0);
            }
            ++i;
        }
        Assert.assertEquals((double)d.cumulativeProbability(Double.MAX_VALUE), (double)1.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(-1.7976931348623157E308), (double)0.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(Double.POSITIVE_INFINITY), (double)1.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(Double.NEGATIVE_INFINITY), (double)0.0, (double)0.0);
    }

    @Test
    public void testMeanVariance() {
        double tol = 1.0E-9;
        ParetoDistribution dist = new ParetoDistribution(1.0, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)Double.POSITIVE_INFINITY, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)Double.POSITIVE_INFINITY, (double)1.0E-9);
        dist = new ParetoDistribution(2.2, 2.4);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)3.771428571428, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)14.81632653, (double)1.0E-9);
    }
}

