/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.GumbelDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class GumbelDistributionTest
extends RealDistributionAbstractTest {
    @Test
    public void testParameters() {
        GumbelDistribution d = this.makeDistribution();
        Assert.assertEquals((double)0.5, (double)d.getLocation(), (double)Precision.EPSILON);
        Assert.assertEquals((double)2.0, (double)d.getScale(), (double)Precision.EPSILON);
    }

    @Test
    public void testSupport() {
        GumbelDistribution d = this.makeDistribution();
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportLowerBound()));
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportUpperBound()));
        Assert.assertTrue((boolean)d.isSupportConnected());
    }

    public GumbelDistribution makeDistribution() {
        return new GumbelDistribution(0.5, 2.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    }

    public double[] makeDensityTestValues() {
        return new double[]{1.258262E-6, 3.594689E-4, 0.009115766, 0.053211, 0.1274352, 0.1777864, 0.1787177, 0.1472662, 0.1075659, 0.07302736, 0.04742782};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{1.60876E-7, 7.577548E-5, 0.003168165, 0.03049041, 0.1203923, 0.2769203, 0.4589561, 0.6235249, 0.7508835, 0.8404869, 0.8999652};
    }
}

