/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import org.junit.Assert;
import org.junit.Test;

public class UnivariateSolverUtilsTest {
    protected UnivariateFunction sin = new Sin();

    @Test(expected=MathIllegalArgumentException.class)
    public void testSolveNull() {
        UnivariateSolverUtils.solve(null, (double)0.0, (double)4.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testSolveBadEndpoints() {
        double root = UnivariateSolverUtils.solve((UnivariateFunction)this.sin, (double)4.0, (double)-0.1, (double)1.0E-6);
        System.out.println("root=" + root);
    }

    @Test
    public void testSolveBadAccuracy() {
        try {
            UnivariateSolverUtils.solve((UnivariateFunction)this.sin, (double)0.0, (double)4.0, (double)0.0);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolveSin() {
        double x = UnivariateSolverUtils.solve((UnivariateFunction)this.sin, (double)1.0, (double)4.0);
        Assert.assertEquals((double)Math.PI, (double)x, (double)1.0E-4);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testSolveAccuracyNull() {
        double accuracy = 1.0E-6;
        UnivariateSolverUtils.solve(null, (double)0.0, (double)4.0, (double)accuracy);
    }

    @Test
    public void testSolveAccuracySin() {
        double accuracy = 1.0E-6;
        double x = UnivariateSolverUtils.solve((UnivariateFunction)this.sin, (double)1.0, (double)4.0, (double)accuracy);
        Assert.assertEquals((double)Math.PI, (double)x, (double)accuracy);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testSolveNoRoot() {
        UnivariateSolverUtils.solve((UnivariateFunction)this.sin, (double)1.0, (double)1.5);
    }

    @Test
    public void testBracketSin() {
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)0.0, (double)-2.0, (double)2.0);
        Assert.assertTrue((this.sin.value(result[0]) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[1]) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBracketCentered() {
        double initial = 0.1;
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)initial, (double)-2.0, (double)2.0, (double)0.2, (double)1.0, (int)100);
        Assert.assertTrue((result[0] < initial ? 1 : 0) != 0);
        Assert.assertTrue((result[1] > initial ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[0]) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[1]) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBracketLow() {
        double initial = 0.5;
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)initial, (double)-2.0, (double)2.0, (double)0.2, (double)1.0, (int)100);
        Assert.assertTrue((result[0] < initial ? 1 : 0) != 0);
        Assert.assertTrue((result[1] < initial ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[0]) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[1]) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBracketHigh() {
        double initial = -0.5;
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)initial, (double)-2.0, (double)2.0, (double)0.2, (double)1.0, (int)100);
        Assert.assertTrue((result[0] > initial ? 1 : 0) != 0);
        Assert.assertTrue((result[1] > initial ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[0]) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.sin.value(result[1]) > 0.0 ? 1 : 0) != 0);
    }

    @Test(expected=NoBracketingException.class)
    public void testBracketLinear() {
        UnivariateSolverUtils.bracket((UnivariateFunction)new UnivariateFunction(){

            public double value(double x) {
                return 1.0 - x;
            }
        }, (double)1000.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0, (double)1.0, (int)100);
    }

    @Test
    public void testBracketExponential() {
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)new UnivariateFunction(){

            public double value(double x) {
                return 1.0 - x;
            }
        }, (double)1000.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0, (double)2.0, (int)10);
        Assert.assertTrue((result[0] <= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((result[1] >= 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBracketEndpointRoot() {
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)1.5, (double)0.0, (double)2.0);
        Assert.assertEquals((double)0.0, (double)this.sin.value(result[0]), (double)1.0E-15);
        Assert.assertTrue((this.sin.value(result[1]) > 0.0 ? 1 : 0) != 0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNullFunction() {
        UnivariateSolverUtils.bracket(null, (double)1.5, (double)0.0, (double)2.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testBadInitial() {
        UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)2.5, (double)0.0, (double)2.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testBadAdditive() {
        UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)1.0, (double)-2.0, (double)3.0, (double)-1.0, (double)1.0, (int)100);
    }

    @Test(expected=NoBracketingException.class)
    public void testIterationExceeded() {
        UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)1.0, (double)-2.0, (double)3.0, (double)1.0E-5, (double)1.0, (int)100);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testBadEndpoints() {
        UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)1.5, (double)2.0, (double)1.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testBadMaximumIterations() {
        UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)1.5, (double)0.0, (double)2.0, (int)0);
    }

    @Test
    public void testBracketLoopConditionForB() {
        double[] result = UnivariateSolverUtils.bracket((UnivariateFunction)this.sin, (double)-0.9, (double)-1.0, (double)1.0, (double)0.1, (double)1.0, (int)100);
        Assert.assertTrue((result[0] <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((result[1] >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMisc() {
        QuinticFunction f = new QuinticFunction();
        double result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)-0.2, (double)0.2);
        Assert.assertEquals((double)result, (double)0.0, (double)1.0E-8);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)-0.1, (double)0.3);
        Assert.assertEquals((double)result, (double)0.0, (double)1.0E-8);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)-0.3, (double)0.45);
        Assert.assertEquals((double)result, (double)0.0, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.3, (double)0.7);
        Assert.assertEquals((double)result, (double)0.5, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.2, (double)0.6);
        Assert.assertEquals((double)result, (double)0.5, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.05, (double)0.95);
        Assert.assertEquals((double)result, (double)0.5, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.85, (double)1.25);
        Assert.assertEquals((double)result, (double)1.0, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.8, (double)1.2);
        Assert.assertEquals((double)result, (double)1.0, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.85, (double)1.75);
        Assert.assertEquals((double)result, (double)1.0, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.55, (double)1.45);
        Assert.assertEquals((double)result, (double)1.0, (double)1.0E-6);
        result = UnivariateSolverUtils.solve((UnivariateFunction)f, (double)0.85, (double)5.0);
        Assert.assertEquals((double)result, (double)1.0, (double)1.0E-6);
    }
}

