/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SplineInterpolatorTest {
    protected double knotTolerance = 1.0E-14;
    protected double coefficientTolerance = 1.0E-14;
    protected double interpolationTolerance = 1.0E-14;

    @Test
    public void testInterpolateLinearDegenerateTwoSegment() {
        double tolerance = 1.0E-15;
        double[] x = new double[]{0.0, 0.5, 1.0};
        double[] y = new double[]{0.0, 0.5, 1.0};
        SplineInterpolator i = new SplineInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        this.verifyConsistency((PolynomialSplineFunction)f, x);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], 1.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
        Assert.assertEquals((double)0.0, (double)f.value(0.0), (double)tolerance);
        Assert.assertEquals((double)0.4, (double)f.value(0.4), (double)tolerance);
        Assert.assertEquals((double)1.0, (double)f.value(1.0), (double)tolerance);
    }

    @Test
    public void testInterpolateLinearDegenerateThreeSegment() {
        double tolerance = 1.0E-15;
        double[] x = new double[]{0.0, 0.5, 1.0, 1.5};
        double[] y = new double[]{0.0, 0.5, 1.0, 1.5};
        SplineInterpolator i = new SplineInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], 1.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[2], 1.0};
        TestUtils.assertEquals(polynomials[2].getCoefficients(), target, this.coefficientTolerance);
        Assert.assertEquals((double)0.0, (double)f.value(0.0), (double)tolerance);
        Assert.assertEquals((double)1.4, (double)f.value(1.4), (double)tolerance);
        Assert.assertEquals((double)1.5, (double)f.value(1.5), (double)tolerance);
    }

    @Test
    public void testInterpolateLinear() {
        double[] x = new double[]{0.0, 0.5, 1.0};
        double[] y = new double[]{0.0, 0.5, 0.0};
        SplineInterpolator i = new SplineInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        this.verifyConsistency((PolynomialSplineFunction)f, x);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.5, 0.0, -2.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], 0.0, -3.0, 2.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
    }

    @Test
    public void testInterpolateSin() {
        double sineCoefficientTolerance = 1.0E-6;
        double sineInterpolationTolerance = 0.0043;
        double[] x = new double[]{0.0, 0.5235987755982988, 1.5707963267948966, 2.6179938779914944, Math.PI, 3.665191429188092, 4.71238898038469, 5.759586531581287, Math.PI * 2};
        double[] y = new double[]{0.0, 0.5, 1.0, 0.5, 0.0, -0.5, -1.0, -0.5, 0.0};
        SplineInterpolator i = new SplineInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        this.verifyConsistency((PolynomialSplineFunction)f, x);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.002676, 0.0, -0.17415829};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[1], 0.8594367, -0.2735672, -0.08707914};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[2], 1.471804E-17, -0.5471344, 0.08707914};
        TestUtils.assertEquals(polynomials[2].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[3], -0.8594367, -0.2735672, 0.17415829};
        TestUtils.assertEquals(polynomials[3].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[4], -1.002676, 6.548562E-17, 0.17415829};
        TestUtils.assertEquals(polynomials[4].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[5], -0.8594367, 0.2735672, 0.08707914};
        TestUtils.assertEquals(polynomials[5].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[6], 3.466465E-16, 0.5471344, -0.08707914};
        TestUtils.assertEquals(polynomials[6].getCoefficients(), target, sineCoefficientTolerance);
        target = new double[]{y[7], 0.8594367, 0.2735672, -0.17415829};
        TestUtils.assertEquals(polynomials[7].getCoefficients(), target, sineCoefficientTolerance);
        Assert.assertEquals((double)(FastMath.sqrt((double)2.0) / 2.0), (double)f.value(0.7853981633974483), (double)sineInterpolationTolerance);
        Assert.assertEquals((double)(FastMath.sqrt((double)2.0) / 2.0), (double)f.value(2.356194490192345), (double)sineInterpolationTolerance);
    }

    @Test
    public void testIllegalArguments() {
        double[] yval;
        double[] xval2;
        SplineInterpolator i = new SplineInterpolator();
        try {
            xval2 = new double[]{0.0, 1.0};
            yval = new double[]{0.0, 1.0, 2.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException xval2) {
            // empty catch block
        }
        try {
            xval2 = new double[]{0.0, 1.0, 0.5};
            yval = new double[]{0.0, 1.0, 2.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect unsorted arguments.");
        }
        catch (NonMonotonicSequenceException xval3) {
            // empty catch block
        }
        try {
            xval2 = new double[]{0.0, 1.0};
            yval = new double[]{0.0, 1.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect unsorted arguments.");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    protected void verifyInterpolation(UnivariateFunction f, double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)f.value(x[i]), (double)y[i], (double)this.knotTolerance);
        }
    }

    protected void verifyConsistency(PolynomialSplineFunction f, double[] x) {
        PolynomialFunction[] polynomials = f.getPolynomials();
        for (int i = 1; i < x.length - 2; ++i) {
            Assert.assertEquals((double)polynomials[i].value(x[i + 1] - x[i]), (double)polynomials[i + 1].value(0.0), (double)0.1);
            Assert.assertEquals((double)polynomials[i].derivative().value(x[i + 1] - x[i]), (double)polynomials[i + 1].derivative().value(0.0), (double)0.5);
            Assert.assertEquals((double)polynomials[i].polynomialDerivative().derivative().value(x[i + 1] - x[i]), (double)polynomials[i + 1].polynomialDerivative().derivative().value(0.0), (double)0.5);
        }
    }
}

