/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sqrt;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SqrtTest {
    @Test
    public void testComparison() {
        Sqrt s = new Sqrt();
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return FastMath.sqrt((double)x);
            }
        };
        for (double x = 1.0E-30; x < 1.0E10; x *= 2.0) {
            double fX = f.value(x);
            double sX = s.value(x);
            Assert.assertEquals((String)("x=" + x), (double)fX, (double)sX, (double)0.0);
        }
    }

    @Test
    public void testDerivativeComparison() {
        Sqrt sPrime = new Sqrt();
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return 1.0 / (2.0 * FastMath.sqrt((double)x));
            }
        };
        for (double x = 1.0E-30; x < 1.0E10; x *= 2.0) {
            double fX = f.value(x);
            double sX = sPrime.value(new DerivativeStructure(1, 1, 0, x)).getPartialDerivative(new int[]{1});
            Assert.assertEquals((String)("x=" + x), (double)fX, (double)sX, (double)FastMath.ulp((double)fX));
        }
    }

    @Test
    public void testDerivativesHighOrder() {
        DerivativeStructure s = new Sqrt().value(new DerivativeStructure(1, 5, 0, 1.2));
        Assert.assertEquals((double)1.0954451150103321, (double)s.getPartialDerivative(new int[]{0}), (double)1.0E-16);
        Assert.assertEquals((double)0.45643546458763845, (double)s.getPartialDerivative(new int[]{1}), (double)1.0E-16);
        Assert.assertEquals((double)-0.19018144357818267, (double)s.getPartialDerivative(new int[]{2}), (double)1.0E-16);
        Assert.assertEquals((double)0.23772680447272834, (double)s.getPartialDerivative(new int[]{3}), (double)1.0E-16);
        Assert.assertEquals((double)-0.49526417598485073, (double)s.getPartialDerivative(new int[]{4}), (double)1.0E-16);
        Assert.assertEquals((double)1.4445205132891479, (double)s.getPartialDerivative(new int[]{5}), (double)5.0E-16);
    }
}

