/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3;

import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.complex.ComplexFormat;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.ChiSquareTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    private TestUtils() {
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, (double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(String msg, double expected, double actual, double delta) {
        if (Double.isNaN(expected)) {
            Assert.assertTrue((String)("" + actual + " is not NaN."), (boolean)Double.isNaN(actual));
        } else {
            Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
        }
    }

    public static void assertSame(double expected, double actual) {
        Assert.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    public static void assertSame(Complex expected, Complex actual) {
        TestUtils.assertSame(expected.getReal(), actual.getReal());
        TestUtils.assertSame(expected.getImaginary(), actual.getImaginary());
    }

    public static void assertEquals(Complex expected, Complex actual, double delta) {
        Assert.assertEquals((double)expected.getReal(), (double)actual.getReal(), (double)delta);
        Assert.assertEquals((double)expected.getImaginary(), (double)actual.getImaginary(), (double)delta);
    }

    public static void assertEquals(double[] expected, double[] observed, double tolerance) {
        TestUtils.assertEquals("Array comparison failure", expected, observed, tolerance);
    }

    public static Object serializeAndRecover(Object o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream so = new ObjectOutputStream(bos);
            so.writeObject(o);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream si = new ObjectInputStream(bis);
            return si.readObject();
        }
        catch (IOException ioe) {
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static void checkSerializedEquality(Object object) {
        Object object2 = TestUtils.serializeAndRecover(object);
        Assert.assertEquals((String)"Equals check", (Object)object, (Object)object2);
        Assert.assertEquals((String)"HashCode check", (long)object.hashCode(), (long)object2.hashCode());
    }

    public static void assertRelativelyEquals(double expected, double actual, double relativeError) {
        TestUtils.assertRelativelyEquals(null, expected, actual, relativeError);
    }

    public static void assertRelativelyEquals(String msg, double expected, double actual, double relativeError) {
        if (Double.isNaN(expected)) {
            Assert.assertTrue((String)msg, (boolean)Double.isNaN(actual));
        } else if (Double.isNaN(actual)) {
            Assert.assertTrue((String)msg, (boolean)Double.isNaN(expected));
        } else if (Double.isInfinite(actual) || Double.isInfinite(expected)) {
            Assert.assertEquals((double)expected, (double)actual, (double)relativeError);
        } else if (expected == 0.0) {
            Assert.assertEquals((String)msg, (double)actual, (double)expected, (double)relativeError);
        } else {
            double absError = FastMath.abs((double)expected) * relativeError;
            Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)absError);
        }
    }

    public static void assertContains(String msg, Complex[] values, Complex z, double epsilon) {
        for (Complex value : values) {
            if (!Precision.equals((double)value.getReal(), (double)z.getReal(), (double)epsilon) || !Precision.equals((double)value.getImaginary(), (double)z.getImaginary(), (double)epsilon)) continue;
            return;
        }
        Assert.fail((String)(msg + " Unable to find " + new ComplexFormat().format(z)));
    }

    public static void assertContains(Complex[] values, Complex z, double epsilon) {
        TestUtils.assertContains(null, values, z, epsilon);
    }

    public static void assertContains(String msg, double[] values, double x, double epsilon) {
        for (double value : values) {
            if (!Precision.equals((double)value, (double)x, (double)epsilon)) continue;
            return;
        }
        Assert.fail((String)(msg + " Unable to find " + x));
    }

    public static void assertContains(double[] values, double x, double epsilon) {
        TestUtils.assertContains(null, values, x, epsilon);
    }

    public static void assertEquals(String message, double[] expected, RealVector actual, double delta) {
        String msgAndSep = message.equals("") ? "" : message + ", ";
        Assert.assertEquals((String)(msgAndSep + "dimension"), (long)expected.length, (long)actual.getDimension());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)(msgAndSep + "entry #" + i), (double)expected[i], (double)actual.getEntry(i), (double)delta);
        }
    }

    public static void assertEquals(String message, RealVector expected, RealVector actual, double delta) {
        String msgAndSep = message.equals("") ? "" : message + ", ";
        Assert.assertEquals((String)(msgAndSep + "dimension"), (long)expected.getDimension(), (long)actual.getDimension());
        int dim = expected.getDimension();
        for (int i = 0; i < dim; ++i) {
            Assert.assertEquals((String)(msgAndSep + "entry #" + i), (double)expected.getEntry(i), (double)actual.getEntry(i), (double)delta);
        }
    }

    public static void assertEquals(String msg, RealMatrix expected, RealMatrix observed, double tolerance) {
        RealMatrix delta;
        Assert.assertNotNull((String)(msg + "\nObserved should not be null"), (Object)observed);
        if (expected.getColumnDimension() != observed.getColumnDimension() || expected.getRowDimension() != observed.getRowDimension()) {
            StringBuilder messageBuffer = new StringBuilder(msg);
            messageBuffer.append("\nObserved has incorrect dimensions.");
            messageBuffer.append("\nobserved is " + observed.getRowDimension() + " x " + observed.getColumnDimension());
            messageBuffer.append("\nexpected " + expected.getRowDimension() + " x " + expected.getColumnDimension());
            Assert.fail((String)messageBuffer.toString());
        }
        if ((delta = expected.subtract(observed)).getNorm() >= tolerance) {
            StringBuilder messageBuffer = new StringBuilder(msg);
            messageBuffer.append("\nExpected: " + expected);
            messageBuffer.append("\nObserved: " + observed);
            messageBuffer.append("\nexpected - observed: " + delta);
            Assert.fail((String)messageBuffer.toString());
        }
    }

    public static void assertEquals(FieldMatrix<? extends FieldElement<?>> expected, FieldMatrix<? extends FieldElement<?>> observed) {
        Assert.assertNotNull((String)"Observed should not be null", observed);
        if (expected.getColumnDimension() != observed.getColumnDimension() || expected.getRowDimension() != observed.getRowDimension()) {
            StringBuilder messageBuffer = new StringBuilder();
            messageBuffer.append("Observed has incorrect dimensions.");
            messageBuffer.append("\nobserved is " + observed.getRowDimension() + " x " + observed.getColumnDimension());
            messageBuffer.append("\nexpected " + expected.getRowDimension() + " x " + expected.getColumnDimension());
            Assert.fail((String)messageBuffer.toString());
        }
        for (int i = 0; i < expected.getRowDimension(); ++i) {
            for (int j = 0; j < expected.getColumnDimension(); ++j) {
                FieldElement eij = expected.getEntry(i, j);
                FieldElement oij = observed.getEntry(i, j);
                Assert.assertEquals((Object)eij, (Object)oij);
            }
        }
    }

    public static void assertEquals(String msg, double[] expected, double[] observed, double tolerance) {
        StringBuilder out = new StringBuilder(msg);
        if (expected.length != observed.length) {
            out.append("\n Arrays not same length. \n");
            out.append("expected has length ");
            out.append(expected.length);
            out.append(" observed length = ");
            out.append(observed.length);
            Assert.fail((String)out.toString());
        }
        boolean failure = false;
        for (int i = 0; i < expected.length; ++i) {
            if (Precision.equalsIncludingNaN((double)expected[i], (double)observed[i], (double)tolerance)) continue;
            failure = true;
            out.append("\n Elements at index ");
            out.append(i);
            out.append(" differ. ");
            out.append(" expected = ");
            out.append(expected[i]);
            out.append(" observed = ");
            out.append(observed[i]);
        }
        if (failure) {
            Assert.fail((String)out.toString());
        }
    }

    public static <T extends FieldElement<T>> void assertEquals(T[] m, T[] n) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors not same length");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals(m[i], n[i]);
        }
    }

    public static double sumSquareDev(double[] values, double target) {
        double sumsq = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double dev = values[i] - target;
            sumsq += dev * dev;
        }
        return sumsq;
    }

    public static void assertChiSquareAccept(String[] valueLabels, double[] expected, long[] observed, double alpha) {
        ChiSquareTest chiSquareTest = new ChiSquareTest();
        if (chiSquareTest.chiSquareTest(expected, observed, alpha)) {
            StringBuilder msgBuffer = new StringBuilder();
            DecimalFormat df = new DecimalFormat("#.##");
            msgBuffer.append("Chisquare test failed");
            msgBuffer.append(" p-value = ");
            msgBuffer.append(chiSquareTest.chiSquareTest(expected, observed));
            msgBuffer.append(" chisquare statistic = ");
            msgBuffer.append(chiSquareTest.chiSquare(expected, observed));
            msgBuffer.append(". \n");
            msgBuffer.append("value\texpected\tobserved\n");
            for (int i = 0; i < expected.length; ++i) {
                msgBuffer.append(valueLabels[i]);
                msgBuffer.append("\t");
                msgBuffer.append(df.format(expected[i]));
                msgBuffer.append("\t\t");
                msgBuffer.append(observed[i]);
                msgBuffer.append("\n");
            }
            msgBuffer.append("This test can fail randomly due to sampling error with probability ");
            msgBuffer.append(alpha);
            msgBuffer.append(".");
            Assert.fail((String)msgBuffer.toString());
        }
    }

    public static void assertChiSquareAccept(int[] values, double[] expected, long[] observed, double alpha) {
        String[] labels = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            labels[i] = Integer.toString(values[i]);
        }
        TestUtils.assertChiSquareAccept(labels, expected, observed, alpha);
    }

    public static void assertChiSquareAccept(double[] expected, long[] observed, double alpha) {
        String[] labels = new String[expected.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Integer.toString(i + 1);
        }
        TestUtils.assertChiSquareAccept(labels, expected, observed, alpha);
    }

    public static double[] getDistributionQuartiles(RealDistribution distribution) {
        double[] quantiles = new double[]{distribution.inverseCumulativeProbability(0.25), distribution.inverseCumulativeProbability(0.5), distribution.inverseCumulativeProbability(0.75)};
        return quantiles;
    }

    public static void updateCounts(double value, long[] counts, double[] quartiles) {
        if (value < quartiles[0]) {
            counts[0] = counts[0] + 1L;
        } else if (value > quartiles[2]) {
            counts[3] = counts[3] + 1L;
        } else if (value > quartiles[1]) {
            counts[2] = counts[2] + 1L;
        } else {
            counts[1] = counts[1] + 1L;
        }
    }

    public static int eliminateZeroMassPoints(int[] densityPoints, double[] densityValues) {
        int positiveMassCount = 0;
        for (int i = 0; i < densityValues.length; ++i) {
            if (!(densityValues[i] > 0.0)) continue;
            ++positiveMassCount;
        }
        if (positiveMassCount < densityValues.length) {
            int[] newPoints = new int[positiveMassCount];
            double[] newValues = new double[positiveMassCount];
            int j = 0;
            for (int i = 0; i < densityValues.length; ++i) {
                if (!(densityValues[i] > 0.0)) continue;
                newPoints[j] = densityPoints[i];
                newValues[j] = densityValues[i];
                ++j;
            }
            System.arraycopy(newPoints, 0, densityPoints, 0, positiveMassCount);
            System.arraycopy(newValues, 0, densityValues, 0, positiveMassCount);
        }
        return positiveMassCount;
    }
}

