/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.net;

import com.hazelcast.shaded.org.apache.commons.codec.CharEncoding;
import com.hazelcast.shaded.org.apache.commons.codec.CodecPolicy;
import com.hazelcast.shaded.org.apache.commons.codec.DecoderException;
import com.hazelcast.shaded.org.apache.commons.codec.EncoderException;
import com.hazelcast.shaded.org.apache.commons.codec.net.BCodec;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BCodecTest {
    private static final String[] BASE64_IMPOSSIBLE_CASES = new String[]{"=?ASCII?B?ZE==?=", "=?ASCII?B?ZmC=?=", "=?ASCII?B?Zm9vYE==?=", "=?ASCII?B?Zm9vYmC=?=", "=?ASCII?B?AB==?="};
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    BCodecTest() {
    }

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testBase64ImpossibleSamplesDefault() throws DecoderException {
        BCodec codec = new BCodec();
        Assertions.assertFalse((boolean)codec.isStrictDecoding());
        for (String s : BASE64_IMPOSSIBLE_CASES) {
            codec.decode(s);
        }
    }

    @Test
    void testBase64ImpossibleSamplesLenient() throws DecoderException {
        BCodec codec = new BCodec(StandardCharsets.UTF_8, CodecPolicy.LENIENT);
        Assertions.assertFalse((boolean)codec.isStrictDecoding());
        for (String s : BASE64_IMPOSSIBLE_CASES) {
            codec.decode(s);
        }
    }

    @Test
    void testBase64ImpossibleSamplesStrict() {
        BCodec codec = new BCodec(StandardCharsets.UTF_8, CodecPolicy.STRICT);
        Assertions.assertTrue((boolean)codec.isStrictDecoding());
        for (String s : BASE64_IMPOSSIBLE_CASES) {
            Assertions.assertThrows(DecoderException.class, () -> codec.decode(s));
        }
    }

    @Test
    void testBasicEncodeDecode() throws Exception {
        BCodec bcodec = new BCodec();
        String plain = "Hello there";
        String encoded = bcodec.encode("Hello there");
        Assertions.assertEquals((Object)"=?UTF-8?B?SGVsbG8gdGhlcmU=?=", (Object)encoded, (String)"Basic B encoding test");
        Assertions.assertEquals((Object)"Hello there", (Object)bcodec.decode(encoded), (String)"Basic B decoding test");
    }

    @Test
    void testDecodeObjects() throws Exception {
        BCodec bcodec = new BCodec();
        String decoded = "=?UTF-8?B?d2hhdCBub3Q=?=";
        String plain = (String)bcodec.decode((Object)"=?UTF-8?B?d2hhdCBub3Q=?=");
        Assertions.assertEquals((Object)"what not", (Object)plain, (String)"Basic B decoding test");
        Object result = bcodec.decode(null);
        Assertions.assertNull((Object)result, (String)"Decoding a null Object should return null");
        Assertions.assertThrows(DecoderException.class, () -> bcodec.decode((Object)3.0));
    }

    @Test
    void testDecodeStringWithNull() throws Exception {
        BCodec bcodec = new BCodec();
        String test = null;
        String result = bcodec.decode(test);
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    void testEncodeDecodeNull() throws Exception {
        BCodec bcodec = new BCodec();
        Assertions.assertNull((Object)bcodec.encode((String)null), (String)"Null string B encoding test");
        Assertions.assertNull((Object)bcodec.decode((String)null), (String)"Null string B decoding test");
    }

    @Test
    void testEncodeObjects() throws Exception {
        BCodec bcodec = new BCodec();
        String plain = "what not";
        String encoded = (String)bcodec.encode((Object)"what not");
        Assertions.assertEquals((Object)"=?UTF-8?B?d2hhdCBub3Q=?=", (Object)encoded, (String)"Basic B encoding test");
        Object result = bcodec.encode(null);
        Assertions.assertNull((Object)result, (String)"Encoding a null Object should return null");
        Assertions.assertThrows(EncoderException.class, () -> bcodec.encode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
    }

    @Test
    void testEncodeStringWithNull() throws Exception {
        BCodec bcodec = new BCodec();
        String test = null;
        String result = bcodec.encode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    void testInvalidEncoding() {
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> new BCodec("NONSENSE"));
    }

    @Test
    void testNullInput() throws Exception {
        BCodec bcodec = new BCodec();
        Assertions.assertNull((Object)bcodec.doDecoding(null));
        Assertions.assertNull((Object)bcodec.doEncoding(null));
    }

    @Test
    void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        BCodec bcodec = new BCodec(CharEncoding.UTF_8);
        Assertions.assertEquals((Object)"=?UTF-8?B?0JLRgdC10Lxf0L/RgNC40LLQtdGC?=", (Object)bcodec.encode(ru_msg));
        Assertions.assertEquals((Object)"=?UTF-8?B?R3LDvGV6aV96w6Rtw6Q=?=", (Object)bcodec.encode(ch_msg));
        Assertions.assertEquals((Object)ru_msg, (Object)bcodec.decode(bcodec.encode(ru_msg)));
        Assertions.assertEquals((Object)ch_msg, (Object)bcodec.decode(bcodec.encode(ch_msg)));
    }
}

