/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.language;

import com.hazelcast.shaded.org.apache.commons.codec.AbstractStringEncoderTest;
import com.hazelcast.shaded.org.apache.commons.codec.EncoderException;
import com.hazelcast.shaded.org.apache.commons.codec.language.Caverphone1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Caverphone1Test
extends AbstractStringEncoderTest<Caverphone1> {
    Caverphone1Test() {
    }

    @Override
    protected Caverphone1 createStringEncoder() {
        return new Caverphone1();
    }

    @Test
    void testCaverphoneRevisitedCommonCodeAT1111() throws EncoderException {
        this.checkEncodingVariations("AT1111", "add", "aid", "at", "art", "eat", "earth", "head", "hit", "hot", "hold", "hard", "heart", "it", "out", "old");
    }

    @Test
    void testEndMb() throws EncoderException {
        String[][] data = new String[][]{{"mb", "M11111"}, {"mbmb", "MPM111"}};
        this.checkEncodings(data);
    }

    @Test
    void testIsCaverphoneEquals() throws EncoderException {
        Caverphone1 caverphone = new Caverphone1();
        Assertions.assertFalse((boolean)caverphone.isEncodeEqual("Peter", "Stevenson"), (String)"Caverphone encodings should not be equal");
        Assertions.assertTrue((boolean)caverphone.isEncodeEqual("Peter", "Peady"), (String)"Caverphone encodings should be equal");
    }

    @Test
    void testSpecificationV1Examples() throws EncoderException {
        String[][] data = new String[][]{{"David", "TFT111"}, {"Whittle", "WTL111"}};
        this.checkEncodings(data);
    }

    @Test
    void testWikipediaExamples() throws EncoderException {
        String[][] data = new String[][]{{"Lee", "L11111"}, {"Thompson", "TMPSN1"}};
        this.checkEncodings(data);
    }
}

