/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.digest;

import com.hazelcast.shaded.org.apache.commons.codec.digest.Crypt;
import com.hazelcast.shaded.org.apache.commons.codec.digest.UnixCrypt;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnixCryptTest {
    UnixCryptTest() {
    }

    @Test
    void testCtor() {
        Assertions.assertNotNull((Object)new UnixCrypt());
    }

    @Test
    void testUnixCryptBytes() {
        Assertions.assertEquals((Object)"12UFlHxel6uMM", (Object)Crypt.crypt((byte[])new byte[0], (String)"12"));
        Assertions.assertEquals((Object)"./287bds2PjVw", (Object)Crypt.crypt((String)"t\u00e4st", (String)"./"));
        Assertions.assertEquals((Object)"./bLIFNqo9XKQ", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"./"));
        Assertions.assertEquals((Object)"./bLIFNqo9XKQ", (Object)Crypt.crypt((byte[])new byte[]{116, -28, 115, 116}, (String)"./"));
    }

    @Test
    void testUnixCryptExplicitCall() {
        Assertions.assertTrue((boolean)UnixCrypt.crypt((byte[])"secret".getBytes()).matches("^[a-zA-Z0-9./]{13}$"));
        Assertions.assertTrue((boolean)UnixCrypt.crypt((byte[])"secret".getBytes(), null).matches("^[a-zA-Z0-9./]{13}$"));
    }

    @Test
    void testUnixCryptInvalidSalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UnixCrypt.crypt((String)"secret", (String)"$a"));
    }

    @Test
    void testUnixCryptNullData() {
        Assertions.assertThrows(NullPointerException.class, () -> UnixCrypt.crypt((byte[])null));
    }

    @Test
    void testUnixCryptStrings() {
        Assertions.assertEquals((Object)"xxWAum7tHdIUw", (Object)Crypt.crypt((String)"secret", (String)"xx"));
        Assertions.assertEquals((Object)"12UFlHxel6uMM", (Object)Crypt.crypt((String)"", (String)"12"));
        Assertions.assertEquals((Object)"12FJgqDtVOg7Q", (Object)Crypt.crypt((String)"secret", (String)"12"));
        Assertions.assertEquals((Object)"12FJgqDtVOg7Q", (Object)Crypt.crypt((String)"secret", (String)"12345678"));
    }

    @Test
    void testUnixCryptWithEmptySalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UnixCrypt.crypt((String)"secret", (String)""));
    }

    @Test
    void testUnixCryptWithHalfSalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UnixCrypt.crypt((String)"secret", (String)"x"));
    }

    @Test
    void testUnixCryptWithoutSalt() {
        String hash = UnixCrypt.crypt((String)"foo");
        Assertions.assertTrue((boolean)hash.matches("^[a-zA-Z0-9./]{13}$"));
        String hash2 = UnixCrypt.crypt((String)"foo");
        Assertions.assertNotSame((Object)hash, (Object)hash2);
    }
}

