/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.binary;

import com.hazelcast.shaded.org.apache.commons.codec.DecoderException;
import com.hazelcast.shaded.org.apache.commons.codec.EncoderException;
import com.hazelcast.shaded.org.apache.commons.codec.binary.BinaryCodec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BinaryCodecTest {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final int BIT_0 = 1;
    private static final int BIT_1 = 2;
    private static final int BIT_2 = 4;
    private static final int BIT_3 = 8;
    private static final int BIT_4 = 16;
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    BinaryCodec instance;

    BinaryCodecTest() {
    }

    void assertDecodeObject(byte[] bits, String encodeMe) throws DecoderException {
        byte[] decoded = (byte[])this.instance.decode((Object)encodeMe);
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        decoded = encodeMe == null ? this.instance.decode((byte[])null) : (byte[])this.instance.decode((Object)encodeMe.getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        decoded = encodeMe == null ? (byte[])this.instance.decode((Object)null) : (byte[])this.instance.decode((Object)encodeMe.toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.instance = new BinaryCodec();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.instance = null;
    }

    @Test
    void testDecodeByteArray() {
        byte[] bits = new byte[1];
        byte[] decoded = this.instance.decode("00000000".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = this.instance.decode("00000001".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = this.instance.decode("00000011".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = this.instance.decode("00000111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = this.instance.decode("00001111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = this.instance.decode("00011111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = this.instance.decode("00111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = this.instance.decode("01111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = this.instance.decode("11111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = this.instance.decode("0000000011111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = this.instance.decode("0000000111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = this.instance.decode("0000001111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = this.instance.decode("0000011111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = this.instance.decode("0000111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = this.instance.decode("0001111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = this.instance.decode("0011111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = this.instance.decode("0111111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = this.instance.decode("1111111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
    }

    @Test
    void testDecodeObject() throws Exception {
        byte[] bits = new byte[1];
        this.assertDecodeObject(bits, "00000000");
        bits = new byte[]{1};
        this.assertDecodeObject(bits, "00000001");
        bits = new byte[]{3};
        this.assertDecodeObject(bits, "00000011");
        bits = new byte[]{7};
        this.assertDecodeObject(bits, "00000111");
        bits = new byte[]{15};
        this.assertDecodeObject(bits, "00001111");
        bits = new byte[]{31};
        this.assertDecodeObject(bits, "00011111");
        bits = new byte[]{63};
        this.assertDecodeObject(bits, "00111111");
        bits = new byte[]{127};
        this.assertDecodeObject(bits, "01111111");
        bits = new byte[]{-1};
        this.assertDecodeObject(bits, "11111111");
        bits = new byte[2];
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000000011111111");
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000000111111111");
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000001111111111");
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000011111111111");
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000111111111111");
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0001111111111111");
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0011111111111111");
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0111111111111111");
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        this.assertDecodeObject(bits, "1111111111111111");
        this.assertDecodeObject(new byte[0], null);
    }

    @Test
    void testDecodeObjectException() {
        try {
            this.instance.decode(new Object());
        }
        catch (DecoderException e) {
            return;
        }
        Assertions.fail((String)"Expected DecoderException");
    }

    @Test
    void testEncodeByteArray() {
        byte[] bits = new byte[1];
        String l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(this.instance.encode(bits));
        Assertions.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assertions.assertEquals((int)0, (int)this.instance.encode((byte[])null).length);
    }

    @Test
    void testEncodeObject() throws Exception {
        byte[] bits = new byte[1];
        String l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assertions.assertEquals((Object)"1111111111111111", (Object)l_encoded);
    }

    @Test
    void testEncodeObjectException() {
        try {
            this.instance.encode((Object)"");
        }
        catch (EncoderException e) {
            return;
        }
        Assertions.fail((String)"Expected EncoderException");
    }

    @Test
    void testEncodeObjectNull() throws Exception {
        byte[] obj = new byte[]{};
        Assertions.assertEquals((int)0, (int)((char[])this.instance.encode((Object)obj)).length);
    }

    @Test
    void testFromAsciiByteArray() {
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((byte[])null).length);
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((byte[])new byte[0]).length);
        byte[] bits = new byte[1];
        byte[] decoded = BinaryCodec.fromAscii((byte[])"00000000".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = BinaryCodec.fromAscii((byte[])"00000001".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = BinaryCodec.fromAscii((byte[])"00000011".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = BinaryCodec.fromAscii((byte[])"00000111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = BinaryCodec.fromAscii((byte[])"00001111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = BinaryCodec.fromAscii((byte[])"00011111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = BinaryCodec.fromAscii((byte[])"00111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = BinaryCodec.fromAscii((byte[])"01111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = BinaryCodec.fromAscii((byte[])"11111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000000011111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000000111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000001111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000011111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0001111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0011111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0111111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"1111111111111111".getBytes(CHARSET_UTF8));
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((byte[])null).length);
    }

    @Test
    void testFromAsciiCharArray() {
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((char[])null).length);
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((char[])new char[0]).length);
        byte[] bits = new byte[1];
        byte[] decoded = BinaryCodec.fromAscii((char[])"00000000".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = BinaryCodec.fromAscii((char[])"00000001".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = BinaryCodec.fromAscii((char[])"00000011".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = BinaryCodec.fromAscii((char[])"00000111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = BinaryCodec.fromAscii((char[])"00001111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = BinaryCodec.fromAscii((char[])"00011111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = BinaryCodec.fromAscii((char[])"00111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = BinaryCodec.fromAscii((char[])"01111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = BinaryCodec.fromAscii((char[])"11111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000000011111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000000111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000001111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000011111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000111111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0001111111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0011111111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0111111111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"1111111111111111".toCharArray());
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assertions.assertEquals((int)0, (int)BinaryCodec.fromAscii((char[])null).length);
    }

    @Test
    void testToAsciiBytes() {
        byte[] bits = new byte[1];
        String l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assertions.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assertions.assertEquals((int)0, (int)BinaryCodec.toAsciiBytes((byte[])null).length);
    }

    @Test
    void testToAsciiChars() {
        byte[] bits = new byte[1];
        String l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assertions.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assertions.assertEquals((int)0, (int)BinaryCodec.toAsciiChars((byte[])null).length);
    }

    @Test
    void testToAsciiString() {
        byte[] bits = new byte[1];
        String l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assertions.assertEquals((Object)"1111111111111111", (Object)l_encoded);
    }

    @Test
    void testToByteArrayFromString() {
        byte[] bits = new byte[1];
        byte[] decoded = this.instance.toByteArray("00000000");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = this.instance.toByteArray("00000001");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = this.instance.toByteArray("00000011");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = this.instance.toByteArray("00000111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = this.instance.toByteArray("00001111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = this.instance.toByteArray("00011111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = this.instance.toByteArray("00111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = this.instance.toByteArray("01111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = this.instance.toByteArray("11111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000000011111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000000111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000001111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000011111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000111111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0001111111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0011111111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0111111111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = this.instance.toByteArray("1111111111111111");
        Assertions.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assertions.assertEquals((int)0, (int)this.instance.toByteArray((String)null).length);
    }
}

