/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.config.Config;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class UdtRestrictionTest
extends SqlTestSupport {
    static SqlService sqlService;
    private static final Class<AllowedClass> ALLOWED_CLASS;
    private static final Class<NotAllowedClass> DENIED_CLASS;
    private final String expectedMessage = String.format("Creation of class %s is not allowed.", DENIED_CLASS.getName());

    @BeforeClass
    public static void setup() {
        Config config = UdtRestrictionTest.smallInstanceConfig();
        JavaSerializationFilterConfig reflectionConfig = new JavaSerializationFilterConfig();
        reflectionConfig.setDefaultsDisabled(true);
        reflectionConfig.getBlacklist().addClasses(new String[]{DENIED_CLASS.getName()});
        reflectionConfig.getWhitelist().addClasses(new String[]{ALLOWED_CLASS.getName()});
        config.getSqlConfig().setJavaReflectionFilterConfig(reflectionConfig);
        UdtRestrictionTest.initialize((int)2, (Config)config);
        sqlService = UdtRestrictionTest.instance().getSql();
    }

    @Test
    public void when_valueClassRestricted_then_fails() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, ALLOWED_CLASS, DENIED_CLASS).create();
        Assertions.assertThatThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (1, 1)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (2, 2)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (1, null)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (1, null)")).hasMessageContaining(this.expectedMessage);
    }

    @Test
    public void when_keyClassRestricted_then_fails() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, DENIED_CLASS, ALLOWED_CLASS).create();
        Assertions.assertThatThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (1, 1)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (1, 2)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (null, 1)")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (null, 2)")).hasMessageContaining(this.expectedMessage);
    }

    @Test
    public void when_valueClassAllowed_then_success() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, Integer.class, ALLOWED_CLASS).create();
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (1, 1)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (2, 2)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (3, null)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (4, null)"));
    }

    @Test
    public void when_keyClassAllowed_then_success() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, AllowedClass.class, Integer.class).create();
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (1, 1)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (2, 2)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("INSERT INTO " + name + " VALUES (null, 3)"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("SINK INTO " + name + " VALUES (null, 2)"));
    }

    @Test
    public void when_updateValueWithRestrictedClass_then_failed() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, Integer.class, NotAllowedClass.class).create();
        UdtRestrictionTest.instance().getMap(name).put((Object)1, (Object)"initial");
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE map SET restricted = 100 WHERE __key = 1")).hasMessageContaining(this.expectedMessage);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE map SET restricted = null WHERE __key = 1")).hasMessageContaining(this.expectedMessage);
    }

    @Test
    public void when_updateValueWithAllowedClass_then_success() {
        String name = "map";
        UdtRestrictionTest.javaMapping(name, Integer.class, AllowedClass.class).create();
        UdtRestrictionTest.instance().getMap(name).put((Object)1, (Object)"initial");
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("UPDATE map SET allowed = 100 WHERE __key = 1"));
        Assertions.assertThatNoException().isThrownBy(() -> this.execute("UPDATE map SET allowed = null WHERE __key = 1"));
    }

    private static SqlTestSupport.SqlMapping javaMapping(String name, Class<?> keyClass, Class<?> valueClass) {
        return (SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).options(new Object[]{"keyFormat", "java", "keyJavaClass", keyClass.getName(), "valueFormat", "java", "valueJavaClass", valueClass.getName()});
    }

    private void execute(String sql) {
        SqlResult ignore = sqlService.execute(sql, new Object[0]);
        if (ignore != null) {
            ignore.close();
        }
    }

    static {
        ALLOWED_CLASS = AllowedClass.class;
        DENIED_CLASS = NotAllowedClass.class;
    }

    public static class AllowedClass
    implements Serializable {
        private Integer allowed;

        public Integer getAllowed() {
            return this.allowed;
        }

        public void setAllowed(Integer value) {
            this.allowed = value;
        }
    }

    public static class NotAllowedClass
    implements Serializable {
        private Integer restricted;

        public Integer getRestricted() {
            return this.restricted;
        }

        public void setRestricted(Integer value) {
            this.restricted = value;
        }
    }
}

