/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.schema.AbstractRelationsStorage;
import com.hazelcast.jet.sql.impl.type.BasicNestedFieldsTest;
import com.hazelcast.jet.sql.impl.type.CompactNestedFieldsTest;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class NestedTypesDDLTest
extends SqlTestSupport {
    private static AbstractRelationsStorage storage;

    @BeforeClass
    public static void beforeClass() {
        NestedTypesDDLTest.initialize((int)2, null);
        storage = NestedTypesDDLTest.sqlServiceImpl(NestedTypesDDLTest.instance()).getOptimizer().relationsStorage();
    }

    @Test
    public void test_createTypeIsNotDuplicatedByDefault() {
        new SqlTestSupport.SqlType("FirstType").create();
        Assertions.assertThatThrownBy(() -> new SqlTestSupport.SqlType("FirstType").create()).hasMessage("Type already exists: FirstType");
    }

    @Test
    public void test_replaceType() {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("FirstType").fields(new String[]{"a INT"})).create();
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("FirstType").fields(new String[]{"a VARCHAR"})).createOrReplace();
        Assert.assertEquals((Object)QueryDataType.VARCHAR, (Object)((Type.TypeField)storage.getType("FirstType").getFields().get(0)).getType());
    }

    @Test
    public void test_createIfNotExists() {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("FirstType").fields(new String[]{"a INT"})).create();
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("FirstType").fields(new String[]{"a VARCHAR"})).createIfNotExists();
        Assert.assertEquals((Object)QueryDataType.INT, (Object)((Type.TypeField)storage.getType("FirstType").getFields().get(0)).getType());
    }

    @Test
    public void test_showTypes() {
        new SqlTestSupport.SqlType("FirstType").create();
        new SqlTestSupport.SqlType("SecondType").create();
        NestedTypesDDLTest.assertRowsAnyOrder("SHOW TYPES", NestedTypesDDLTest.rows(1, "FirstType", "SecondType"));
    }

    @Test
    public void test_dropNonexistentType() {
        Assertions.assertThatThrownBy(() -> this.execute("DROP TYPE Foo")).hasMessage("Type does not exist: Foo");
        this.execute("DROP TYPE IF EXISTS Foo");
    }

    @Test
    public void when_compactTypeNoColumns_then_fail() {
        new SqlTestSupport.SqlType("FirstType").create();
        Assertions.assertThatThrownBy(() -> CompactNestedFieldsTest.createCompactMapping(NestedTypesDDLTest.instance(), "test", "foo", "bar FirstType")).hasMessage("Column list is required to create Compact-based types");
    }

    @Test
    public void test_typeFieldResolution() {
        new SqlTestSupport.SqlType("NestedType").create();
        Assert.assertTrue((boolean)storage.getType("NestedType").getFields().isEmpty());
        Assertions.assertThatThrownBy(() -> CompactNestedFieldsTest.createCompactMapping(NestedTypesDDLTest.instance(), "test", "foo", "bar NestedType")).hasMessage("Column list is required to create Compact-based types");
        BasicNestedFieldsTest.createJavaMapping(NestedTypesDDLTest.instance(), "test2", BasicNestedFieldsTest.RegularPOJO.class, "name VARCHAR", "child NestedType");
        Assert.assertFalse((boolean)storage.getType("NestedType").getFields().isEmpty());
        Assertions.assertThatCode(() -> CompactNestedFieldsTest.createCompactMapping(NestedTypesDDLTest.instance(), "test", "foo", "bar NestedType")).doesNotThrowAnyException();
    }

    @Test
    public void test_failOnDuplicateColumnName() {
        Assertions.assertThatThrownBy(() -> ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("TestType").fields(new String[]{"id BIGINT", "id BIGINT"})).create()).hasMessageContaining("Column 'id' specified more than once");
    }

    @Test
    public void test_failOnReplaceAndIfNotExists() {
        Assertions.assertThatThrownBy(() -> this.execute("CREATE OR REPLACE TYPE IF NOT EXISTS TestType (id BIGINT, name VARCHAR)")).hasMessageContaining("OR REPLACE in conjunction with IF NOT EXISTS not supported");
    }

    @Test
    public void test_fullyQualifiedTypeName() {
        new SqlTestSupport.SqlType("hazelcast.public.FirstType").create();
        Assert.assertNotNull((Object)storage.getType("FirstType"));
        this.execute("DROP TYPE hazelcast.public.FirstType");
        Assert.assertNull((Object)storage.getType("FirstType"));
    }

    @Test
    public void test_failOnNonPublicSchemaType() {
        Assertions.assertThatThrownBy(() -> new SqlTestSupport.SqlType("information_schema.TestType").create()).hasMessageContaining("The type must be created in the \"public\" schema");
        Assert.assertNull((Object)storage.getType("TestType"));
        new SqlTestSupport.SqlType("hazelcast.public.TestType").create();
        Assertions.assertThatThrownBy(() -> this.execute("DROP TYPE information_schema.TestType")).hasMessageContaining("Type does not exist: information_schema.TestType");
        Assert.assertNotNull((Object)storage.getType("TestType"));
    }

    void execute(String sql) {
        NestedTypesDDLTest.instance().getSql().execute(sql, new Object[0]);
    }
}

