/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.visitor;

import com.hazelcast.jet.sql.impl.expression.Sarg;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpression;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.com.google.common.collect.ImmutableRangeSet;
import com.hazelcast.shaded.com.google.common.collect.Range;
import com.hazelcast.shaded.com.google.common.collect.RangeSet;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUnknownAs;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.DateString;
import com.hazelcast.shaded.org.apache.calcite.util.TimeString;
import com.hazelcast.shaded.org.apache.calcite.util.TimestampString;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.SqlYearMonthInterval;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RexToExpressionTest {
    private static final RelDataTypeFactory FACTORY = HazelcastTypeFactory.INSTANCE;
    private static final RexBuilder BUILDER = new RexBuilder(FACTORY);

    @Test
    public void test_boolean() {
        RexLiteral literal = RexToExpressionTest.literal(false, true, SqlTypeName.BOOLEAN);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(false, true));
    }

    @Test
    public void test_tinyint() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.TINYINT);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range((byte)1, (byte)2));
    }

    @Test
    public void test_smallint() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.SMALLINT);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range((short)1, (short)2));
    }

    @Test
    public void test_int() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.INTEGER);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(1, 2));
    }

    @Test
    public void test_bigint() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.BIGINT);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(1L, 2L));
    }

    @Test
    public void test_decimal() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.DECIMAL);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(new BigDecimal(1), new BigDecimal(2)));
    }

    @Test
    public void test_real() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.REAL);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(Float.valueOf(1.0f), Float.valueOf(2.0f)));
    }

    @Test
    public void test_double() {
        RexLiteral literal = RexToExpressionTest.literal(new BigDecimal(1), new BigDecimal(2), SqlTypeName.DOUBLE);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(1.0, 2.0));
    }

    @Test
    public void test_time() {
        RexLiteral literal = RexToExpressionTest.literal(new TimeString("12:23:34"), new TimeString("12:23:35"), SqlTypeName.TIME);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(LocalTime.of(12, 23, 34), LocalTime.of(12, 23, 35)));
    }

    @Test
    public void test_date() {
        RexLiteral literal = RexToExpressionTest.literal(new DateString("2021-09-17"), new DateString("2021-09-18"), SqlTypeName.DATE);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(LocalDate.of(2021, 9, 17), LocalDate.of(2021, 9, 18)));
    }

    @Test
    public void test_timestamp() {
        RexLiteral literal = RexToExpressionTest.literal(new TimestampString("2021-09-17 12:23:34"), new TimestampString("2021-09-17 12:23:35"), SqlTypeName.TIMESTAMP);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(LocalDateTime.of(2021, 9, 17, 12, 23, 34), LocalDateTime.of(2021, 9, 17, 12, 23, 35)));
    }

    @Test
    public void test_intervalYearMonth() {
        RelDataType type = FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO));
        RexLiteral literal = BUILDER.makeSearchArgumentLiteral(RexToExpressionTest.sarg(new BigDecimal(1), new BigDecimal(2)), type);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(new SqlYearMonthInterval(1), new SqlYearMonthInterval(2)));
    }

    @Test
    public void test_intervalDaySecond() {
        RelDataType type = FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO));
        RexLiteral literal = BUILDER.makeSearchArgumentLiteral(RexToExpressionTest.sarg(new BigDecimal(1), new BigDecimal(2)), type);
        Sarg converted = RexToExpressionTest.convert(literal);
        Assertions.assertThat(converted).isEqualToComparingFieldByField(RexToExpressionTest.range(new SqlDaySecondInterval(1L), new SqlDaySecondInterval(2L)));
    }

    private static <C extends Comparable<C>> Sarg<C> convert(RexLiteral literal) {
        Expression expression = RexToExpression.convertLiteral((RexLiteral)literal);
        return (Sarg)expression.eval(null, null);
    }

    private static <C extends Comparable<C>> RexLiteral literal(C left, C right, SqlTypeName typeName) {
        com.hazelcast.shaded.org.apache.calcite.util.Sarg<C> sarg = RexToExpressionTest.sarg(left, right);
        RelDataType type = HazelcastTypeUtils.createType((RelDataTypeFactory)FACTORY, (SqlTypeName)typeName, (boolean)true);
        return BUILDER.makeSearchArgumentLiteral(sarg, type);
    }

    private static <C extends Comparable<C>> com.hazelcast.shaded.org.apache.calcite.util.Sarg<C> sarg(C left, C right) {
        return com.hazelcast.shaded.org.apache.calcite.util.Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, RexToExpressionTest.rangeSet(left, right));
    }

    private static <C extends Comparable<C>> RangeSet<C> rangeSet(C left, C right) {
        return ImmutableRangeSet.of((Range)Range.closed(left, right));
    }

    private static <C extends Comparable<C>> Sarg<C> range(C left, C right) {
        return new Sarg(RexToExpressionTest.rangeSet(left, right), null);
    }
}

