/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentCandidate;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentFilter;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentFilterResolver;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IndexComponentFilterResolverTest {
    private static final RexInputRef REX_INPUT_REF = new RexInputRef(0, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.INTEGER, (boolean)false));
    private static final QueryDataType QUERY_DATA_TYPE = QueryDataType.INT;
    private static final IndexComponentCandidate SINGLE_EQUALITY_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexEqualsFilter());
    private static final IndexComponentCandidate TWO_EQUALITIES_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexCompositeFilter(new IndexFilter[]{new IndexEqualsFilter(), new IndexEqualsFilter()}));
    private static final IndexComponentCandidate LOWER_BOUND_RANGE_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexRangeFilter(new IndexFilterValue(), true, null, false));
    private static final IndexComponentCandidate UPPER_BOUND_RANGE_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexRangeFilter(null, false, new IndexFilterValue(), true));
    private static final IndexComponentCandidate BOTH_BOUNDS_RANGE_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexRangeFilter(new IndexFilterValue(), true, new IndexFilterValue(), true));
    private static final IndexComponentCandidate EQUALITY_AND_RANGE_CANDIDATE = new IndexComponentCandidate((RexNode)REX_INPUT_REF, 0, (IndexFilter)new IndexCompositeFilter(new IndexFilter[]{new IndexRangeFilter(), new IndexEqualsFilter()}));
    private static final List<IndexComponentCandidate> WITH_SINGLE_EQUALITY_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, LOWER_BOUND_RANGE_CANDIDATE, TWO_EQUALITIES_CANDIDATE, SINGLE_EQUALITY_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_TWO_EQUALITIES_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, LOWER_BOUND_RANGE_CANDIDATE, TWO_EQUALITIES_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_LOWER_BOUND_RANGE_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, LOWER_BOUND_RANGE_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_UPPER_BOUND_RANGE_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, UPPER_BOUND_RANGE_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_TWO_RANGES_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, UPPER_BOUND_RANGE_CANDIDATE, LOWER_BOUND_RANGE_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_BOTH_BOUNDS_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE, BOTH_BOUNDS_RANGE_CANDIDATE);
    private static final List<IndexComponentCandidate> WITH_EQUALITY_AND_RANGE_FILTER_AS_BEST_CANDIDATES = Arrays.asList(EQUALITY_AND_RANGE_CANDIDATE);
    @Parameterized.Parameter
    public IndexType indexType;

    @Test
    public void when_singleEqualityFilterPresent_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_SINGLE_EQUALITY_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        Assert.assertEquals((Object)SINGLE_EQUALITY_CANDIDATE.getFilter(), (Object)bestFilter.getFilter());
    }

    @Test
    public void when_twoEqualitiesFilterPresentAndNoBetterChoice_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_TWO_EQUALITIES_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        Assert.assertEquals((Object)TWO_EQUALITIES_CANDIDATE.getFilter(), (Object)bestFilter.getFilter());
    }

    @Test
    public void when_lowerBoundRangeFilterPresentAndNoBetterChoiceAndSortedIndex_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_LOWER_BOUND_RANGE_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        if (this.indexType == IndexType.SORTED) {
            Assert.assertEquals((Object)bestFilter.getFilter(), (Object)LOWER_BOUND_RANGE_CANDIDATE.getFilter());
        } else {
            Assert.assertNull((Object)bestFilter);
        }
    }

    @Test
    public void when_upperBoundRangeFilterPresentAndNoBetterChoiceAndSortedIndex_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_UPPER_BOUND_RANGE_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        if (this.indexType == IndexType.SORTED) {
            Assert.assertEquals((Object)bestFilter.getFilter(), (Object)UPPER_BOUND_RANGE_CANDIDATE.getFilter());
        } else {
            Assert.assertNull((Object)bestFilter);
        }
    }

    @Test
    public void when_bothBoundsRangeFilterPresentAndNoBetterChoiceAndSortedIndex_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_BOTH_BOUNDS_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        if (this.indexType == IndexType.SORTED) {
            Assert.assertEquals((Object)bestFilter.getFilter(), (Object)BOTH_BOUNDS_RANGE_CANDIDATE.getFilter());
        } else {
            Assert.assertNull((Object)bestFilter);
        }
    }

    @Test
    public void when_equalityAndRangeFilterPresentNoBetterChoiceAndSortedIndex_then_itIsUsed() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_EQUALITY_AND_RANGE_FILTER_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        if (this.indexType == IndexType.SORTED) {
            Assert.assertEquals((Object)bestFilter.getFilter(), (Object)EQUALITY_AND_RANGE_CANDIDATE.getFilter());
        } else {
            Assert.assertNull((Object)bestFilter);
        }
    }

    @Test
    public void when_twoRangeFilterPresentAndNoBetterChoiceAndSortedIndex_then_filtersAreCombined() {
        IndexComponentFilter bestFilter = IndexComponentFilterResolver.findBestComponentFilter((IndexType)this.indexType, WITH_TWO_RANGES_AS_BEST_CANDIDATES, (QueryDataType)QUERY_DATA_TYPE);
        if (this.indexType == IndexType.SORTED) {
            Assert.assertTrue((boolean)(bestFilter.getFilter() instanceof IndexRangeFilter));
            IndexRangeFilter resultFilter = (IndexRangeFilter)bestFilter.getFilter();
            IndexRangeFilter lowerBound = (IndexRangeFilter)LOWER_BOUND_RANGE_CANDIDATE.getFilter();
            IndexRangeFilter upperBound = (IndexRangeFilter)UPPER_BOUND_RANGE_CANDIDATE.getFilter();
            Assert.assertEquals((Object)resultFilter.getFrom(), (Object)lowerBound.getFrom());
            Assert.assertEquals((Object)resultFilter.isFromInclusive(), (Object)lowerBound.isFromInclusive());
            Assert.assertEquals((Object)resultFilter.getTo(), (Object)upperBound.getTo());
            Assert.assertEquals((Object)resultFilter.isToInclusive(), (Object)upperBound.isToInclusive());
        } else {
            Assert.assertNull((Object)bestFilter);
        }
    }

    @Parameterized.Parameters(name="indexType:{0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (IndexType indexType : Arrays.asList(IndexType.SORTED, IndexType.HASH)) {
            res.add(new Object[]{indexType});
        }
        return res;
    }
}

