/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.DropLateItemsLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UnionLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalUnion;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class UnionDropLateItemsTransposeTest
extends OptimizerTestSupport {
    private TableResolver resolver;

    @BeforeClass
    public static void beforeClass() {
        UnionDropLateItemsTransposeTest.initialize((int)1, null);
    }

    @Before
    public void setUp() throws Exception {
        NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)UnionDropLateItemsTransposeTest.instance());
        this.resolver = new TableResolverImpl((NodeEngine)nodeEngine, new RelationsStorage((NodeEngine)nodeEngine), new SqlConnectorCache((NodeEngine)nodeEngine));
        String stream = "stream1";
        TestStreamSqlConnector.create(UnionDropLateItemsTransposeTest.instance().getSql(), stream, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP), new Object[][]{UnionDropLateItemsTransposeTest.row(0, UnionDropLateItemsTransposeTest.timestamp(0L))});
        String stream2 = "stream2";
        TestStreamSqlConnector.create(UnionDropLateItemsTransposeTest.instance().getSql(), stream2, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP), new Object[][]{UnionDropLateItemsTransposeTest.row(1, UnionDropLateItemsTransposeTest.timestamp(1L))});
        String stream3 = "stream3";
        TestStreamSqlConnector.create(UnionDropLateItemsTransposeTest.instance().getSql(), stream3, Arrays.asList("x", "y"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP), new Object[][]{UnionDropLateItemsTransposeTest.row(2, UnionDropLateItemsTransposeTest.timestamp(2L))});
    }

    @Ignore(value="This rule is disabled; introduce it and implement DropLateItemsP in correct way.")
    @Test
    public void when_unionAndDropItemsRelTransposes_then_transposes() {
        String sql = "SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(b), INTERVAL '0.001' SECOND)) UNION ALL SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream2, DESCRIPTOR(b), INTERVAL '0.001' SECOND))UNION ALL SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream3, DESCRIPTOR(y), INTERVAL '0.001' SECOND))";
        UnionDropLateItemsTransposeTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(0));
        UnionDropLateItemsTransposeTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(1));
        UnionDropLateItemsTransposeTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(2));
        HazelcastTable streamingTable1 = UnionDropLateItemsTransposeTest.streamingTable((Table)this.resolver.getTables().get(0), 1L);
        HazelcastTable streamingTable2 = UnionDropLateItemsTransposeTest.streamingTable((Table)this.resolver.getTables().get(1), 1L);
        HazelcastTable streamingTable3 = UnionDropLateItemsTransposeTest.streamingTable((Table)this.resolver.getTables().get(2), 1L);
        RelNode node = this.preOptimize(sql, streamingTable1, streamingTable2, streamingTable3);
        UnionDropLateItemsTransposeTest.assertPlan(node, UnionDropLateItemsTransposeTest.plan(UnionDropLateItemsTransposeTest.planRow(0, LogicalUnion.class), UnionDropLateItemsTransposeTest.planRow(1, LogicalTableFunctionScan.class), UnionDropLateItemsTransposeTest.planRow(2, LogicalTableScan.class), UnionDropLateItemsTransposeTest.planRow(1, LogicalTableFunctionScan.class), UnionDropLateItemsTransposeTest.planRow(2, LogicalTableScan.class), UnionDropLateItemsTransposeTest.planRow(1, LogicalTableFunctionScan.class), UnionDropLateItemsTransposeTest.planRow(2, LogicalTableScan.class)));
        LogicalRel logicalRel = this.optimizeLogical(sql, streamingTable1, streamingTable2, streamingTable3);
        UnionDropLateItemsTransposeTest.assertPlan((RelNode)logicalRel, UnionDropLateItemsTransposeTest.plan(UnionDropLateItemsTransposeTest.planRow(0, DropLateItemsLogicalRel.class), UnionDropLateItemsTransposeTest.planRow(1, UnionLogicalRel.class), UnionDropLateItemsTransposeTest.planRow(2, FullScanLogicalRel.class), UnionDropLateItemsTransposeTest.planRow(2, FullScanLogicalRel.class), UnionDropLateItemsTransposeTest.planRow(2, FullScanLogicalRel.class)));
        UnionDropLateItemsTransposeTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(0, UnionDropLateItemsTransposeTest.timestamp(0L)), new SqlTestSupport.Row(1, UnionDropLateItemsTransposeTest.timestamp(1L)), new SqlTestSupport.Row(2, UnionDropLateItemsTransposeTest.timestamp(2L))));
    }
}

