/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlIssue24162Test
extends OptimizerTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        SqlIssue24162Test.initialize((int)1, null);
    }

    @Test
    public void test() {
        NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)SqlIssue24162Test.instance());
        TableResolverImpl resolver = new TableResolverImpl((NodeEngine)nodeEngine, new RelationsStorage((NodeEngine)nodeEngine), new SqlConnectorCache((NodeEngine)nodeEngine));
        String stream = "s1";
        TestStreamSqlConnector.create(SqlIssue24162Test.instance().getSql(), stream, Collections.singletonList("a"), Collections.singletonList(QueryDataTypeFamily.BIGINT), new Object[][]{SqlIssue24162Test.row(1L)});
        String stream2 = "s2";
        TestStreamSqlConnector.create(SqlIssue24162Test.instance().getSql(), stream2, Collections.singletonList("b"), Collections.singletonList(QueryDataTypeFamily.BIGINT), new Object[][]{SqlIssue24162Test.row(1L)});
        SqlIssue24162Test.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, resolver.getTables().get(0));
        SqlIssue24162Test.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, resolver.getTables().get(1));
        HazelcastTable table = SqlIssue24162Test.streamingTable((Table)resolver.getTables().get(0), 1L);
        HazelcastTable table2 = SqlIssue24162Test.streamingTable((Table)resolver.getTables().get(1), 1L);
        String sql = "SELECT * FROM ( SELECT window_end, AVG(a) AS price1 FROM     TABLE(HOP((SELECT * FROM TABLE(IMPOSE_ORDER(TABLE s1, DESCRIPTOR(a), 1))), DESCRIPTOR(a), 4, 1))    GROUP BY window_end, a) s_1  RIGHT JOIN ( SELECT window_end, AVG(b) AS price2 FROM     TABLE(HOP((SELECT * FROM TABLE(IMPOSE_ORDER(TABLE s2, DESCRIPTOR(b), 1))), DESCRIPTOR(b), 4, 1))    GROUP BY window_end, b) s_2 ON s_1.window_end = s_2.window_end";
        PhysicalRel optPhysicalRel = this.optimizePhysical(sql, Collections.singletonList(QueryDataType.BIGINT), table, table2).getPhysical();
        SqlIssue24162Test.assertPlan((RelNode)optPhysicalRel, SqlIssue24162Test.plan(SqlIssue24162Test.planRow(0, CalcPhysicalRel.class), SqlIssue24162Test.planRow(1, StreamToStreamJoinPhysicalRel.class), SqlIssue24162Test.planRow(2, SlidingWindowAggregatePhysicalRel.class), SqlIssue24162Test.planRow(3, CalcPhysicalRel.class), SqlIssue24162Test.planRow(4, FullScanPhysicalRel.class), SqlIssue24162Test.planRow(2, SlidingWindowAggregatePhysicalRel.class), SqlIssue24162Test.planRow(3, CalcPhysicalRel.class), SqlIssue24162Test.planRow(4, FullScanPhysicalRel.class)));
        Assertions.assertThat((boolean)OptUtils.isUnbounded((RelNode)optPhysicalRel)).isTrue();
        FullScanPhysicalRel leftSource = (FullScanPhysicalRel)optPhysicalRel.getInput(0).getInput(0).getInput(0).getInput(0);
        FullScanPhysicalRel rightSource = (FullScanPhysicalRel)optPhysicalRel.getInput(0).getInput(1).getInput(0).getInput(0);
        Assertions.assertThat((Object)leftSource).isNotEqualTo((Object)rightSource);
        RelOptTable leftTable = leftSource.getTable();
        RelOptTable rightTable = rightSource.getTable();
        Assertions.assertThat((Object)leftTable).isNotEqualTo((Object)rightTable);
    }
}

