/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JavaVersion;
import com.hazelcast.jet.sql.impl.inject.HazelcastJsonUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class HazelcastJsonUpsertTargetTest {
    @Test
    public void test_set() {
        HazelcastJsonUpsertTarget target = new HazelcastJsonUpsertTarget();
        UpsertInjector nullInjector = target.createInjector("null", QueryDataType.OBJECT);
        UpsertInjector objectInjector = target.createInjector("object", QueryDataType.OBJECT);
        UpsertInjector stringInjector = target.createInjector("string", QueryDataType.VARCHAR);
        UpsertInjector booleanInjector = target.createInjector("boolean", QueryDataType.BOOLEAN);
        UpsertInjector byteInjector = target.createInjector("byte", QueryDataType.TINYINT);
        UpsertInjector shortInjector = target.createInjector("short", QueryDataType.SMALLINT);
        UpsertInjector intInjector = target.createInjector("int", QueryDataType.INT);
        UpsertInjector longInjector = target.createInjector("long", QueryDataType.BIGINT);
        UpsertInjector floatInjector = target.createInjector("float", QueryDataType.REAL);
        UpsertInjector doubleInjector = target.createInjector("double", QueryDataType.DOUBLE);
        UpsertInjector decimalInjector = target.createInjector("decimal", QueryDataType.DECIMAL);
        UpsertInjector timeInjector = target.createInjector("time", QueryDataType.TIME);
        UpsertInjector dateInjector = target.createInjector("date", QueryDataType.DATE);
        UpsertInjector timestampInjector = target.createInjector("timestamp", QueryDataType.TIMESTAMP);
        UpsertInjector timestampTzInjector = target.createInjector("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        target.init();
        nullInjector.set(null);
        objectInjector.set((Object)new JsonObject());
        stringInjector.set((Object)"string");
        booleanInjector.set((Object)true);
        byteInjector.set((Object)127);
        shortInjector.set((Object)Short.MAX_VALUE);
        intInjector.set((Object)Integer.MAX_VALUE);
        longInjector.set((Object)Long.MAX_VALUE);
        floatInjector.set((Object)Float.valueOf(1.234568E9f));
        doubleInjector.set((Object)1.234512345678901E14);
        decimalInjector.set((Object)new BigDecimal("9223372036854775.123"));
        timeInjector.set((Object)LocalTime.of(12, 23, 34));
        dateInjector.set((Object)LocalDate.of(2020, 9, 9));
        timestampInjector.set((Object)LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000));
        timestampTzInjector.set((Object)OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Object hazelcastJson = target.conclude();
        String expectedJson = JavaVersion.isAtLeast((JavaVersion)JavaVersion.JAVA_19) ? "{\"null\":null,\"object\":{},\"string\":\"string\",\"boolean\":true,\"byte\":127,\"short\":32767,\"int\":2147483647,\"long\":9223372036854775807,\"float\":1.234568E9,\"double\":1.234512345678901E14,\"decimal\":\"9223372036854775.123\",\"time\":\"12:23:34\",\"date\":\"2020-09-09\",\"timestamp\":\"2020-09-09T12:23:34.100\",\"timestampTz\":\"2020-09-09T12:23:34.200Z\"}" : "{\"null\":null,\"object\":{},\"string\":\"string\",\"boolean\":true,\"byte\":127,\"short\":32767,\"int\":2147483647,\"long\":9223372036854775807,\"float\":1.23456794E9,\"double\":1.234512345678901E14,\"decimal\":\"9223372036854775.123\",\"time\":\"12:23:34\",\"date\":\"2020-09-09\",\"timestamp\":\"2020-09-09T12:23:34.100\",\"timestampTz\":\"2020-09-09T12:23:34.200Z\"}";
        Assertions.assertThat((Object)hazelcastJson).isEqualTo((Object)new HazelcastJsonValue(expectedJson));
    }

    private Object[] values() {
        String expectedFloat = JavaVersion.isAtLeast((JavaVersion)JavaVersion.JAVA_19) ? "1.234568E9" : "1.23456794E9";
        return new Object[]{new Object[]{null, "null"}, new Object[]{new JsonObject(), "{}"}, new Object[]{"string", "\"string\""}, new Object[]{true, "true"}, new Object[]{(byte)127, "127"}, new Object[]{(short)Short.MAX_VALUE, "32767"}, new Object[]{Integer.MAX_VALUE, "2147483647"}, new Object[]{Long.MAX_VALUE, "9223372036854775807"}, new Object[]{Float.valueOf(1.234568E9f), expectedFloat}, new Object[]{1.234512345678901E14, "1.234512345678901E14"}, new Object[]{new BigDecimal("9223372036854775.123"), "\"9223372036854775.123\""}, new Object[]{LocalTime.of(12, 23, 34), "\"12:23:34\""}, new Object[]{LocalDate.of(2020, 9, 9), "\"2020-09-09\""}, new Object[]{LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000), "\"2020-09-09T12:23:34.100\""}, new Object[]{OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC), "\"2020-09-09T12:23:34.200Z\""}};
    }

    @Test
    @Parameters(method="values")
    public void when_typeIsObject_then_allValuesAreAllowed(Object value, String expected) {
        HazelcastJsonUpsertTarget target = new HazelcastJsonUpsertTarget();
        UpsertInjector injector = target.createInjector("object", QueryDataType.OBJECT);
        target.init();
        injector.set(value);
        Object hazelcastJson = target.conclude();
        Assertions.assertThat((Object)hazelcastJson).isEqualTo((Object)new HazelcastJsonValue("{\"object\":" + expected + "}"));
    }
}

