/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CompactUpsertTargetDescriptorTest {
    private static final InternalSerializationService SERIALIZATION_SERVICE = new DefaultSerializationServiceBuilder().build();

    @Test
    public void test_create() {
        CompactUpsertTargetDescriptor descriptor = new CompactUpsertTargetDescriptor(new SchemaWriter("test").build());
        UpsertTarget target = descriptor.create((ExpressionEvalContext)Mockito.mock((Object[])new ExpressionEvalContext[0]));
        Assertions.assertThat((Object)target).isInstanceOf(CompactUpsertTarget.class);
    }

    @Test
    public void test_serialization() {
        SchemaWriter schemaWriter = new SchemaWriter("test");
        schemaWriter.addField(new FieldDescriptor("int", FieldKind.INT32));
        schemaWriter.addField(new FieldDescriptor("long", FieldKind.INT64));
        CompactUpsertTargetDescriptor original = new CompactUpsertTargetDescriptor(schemaWriter.build());
        CompactUpsertTargetDescriptor serialized = (CompactUpsertTargetDescriptor)SERIALIZATION_SERVICE.toObject((Object)SERIALIZATION_SERVICE.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

