/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AvroUpsertTargetDescriptorTest {
    private static final InternalSerializationService SERIALIZATION_SERVICE = new DefaultSerializationServiceBuilder().build();
    private static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"name").fields().name("name").type().stringType().noDefault().endRecord();

    @Test
    public void test_create() {
        AvroUpsertTargetDescriptor descriptor = new AvroUpsertTargetDescriptor(SCHEMA);
        UpsertTarget target = descriptor.create((ExpressionEvalContext)Mockito.mock((Object[])new ExpressionEvalContext[0]));
        Assertions.assertThat((Object)target).isInstanceOf(AvroUpsertTarget.class);
    }

    @Test
    public void test_serialization() {
        AvroUpsertTargetDescriptor original = new AvroUpsertTargetDescriptor(SCHEMA);
        AvroUpsertTargetDescriptor serialized = (AvroUpsertTargetDescriptor)SERIALIZATION_SERVICE.toObject((Object)SERIALIZATION_SERVICE.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

