/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.SubstringFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SubstringFunctionIntegrationTest
extends ExpressionTestSupport {
    @Parameterized.Parameter
    public boolean useFunctionalSyntax;

    @Parameterized.Parameters(name="useFunctionalSyntax:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testLogic() {
        this.putAndCheckValue("abcde", this.sql2("null", "1"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("null", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "1"), SqlColumnType.VARCHAR, "abcde", new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "2"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "5"), SqlColumnType.VARCHAR, "e", new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "6"), SqlColumnType.VARCHAR, "", new Object[0]);
        this.putAndCheckValue("abcde", this.sql2("this", "7"), SqlColumnType.VARCHAR, "", new Object[0]);
        this.putAndCheckFailure("abcde", this.sql2("this", "0"), 2000, "SUBSTRING \"start\" operand must be positive", new Object[0]);
        this.putAndCheckFailure("abcde", this.sql2("this", "-1"), 2000, "SUBSTRING \"start\" operand must be positive", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "null", "1"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "null", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("null", "null", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "0"), SqlColumnType.VARCHAR, "", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "1"), SqlColumnType.VARCHAR, "a", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "2"), SqlColumnType.VARCHAR, "ab", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "5"), SqlColumnType.VARCHAR, "abcde", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "1", "6"), SqlColumnType.VARCHAR, "abcde", new Object[0]);
        this.putAndCheckValue("abcde", this.sql3("this", "5", "6"), SqlColumnType.VARCHAR, "e", new Object[0]);
        this.putAndCheckFailure("abcde", this.sql3("this", "1", "-1"), 2000, "SUBSTRING \"length\" operand cannot be negative", new Object[0]);
    }

    @Test
    public void testArg1() {
        this.putAndCheckValue("abcde", this.sql2("this", "2"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.putAndCheckValue(Character.valueOf('a'), this.sql2("this", "1"), SqlColumnType.VARCHAR, "a", new Object[0]);
        this.putAndCheckFailure(true, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure((byte)1, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.TINYINT, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure((short)1, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.SMALLINT, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(1, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.INTEGER, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(1L, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.BIGINT, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.REAL, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(1.0, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DOUBLE, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DATE, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.TIME, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, this.sql2("this", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, this.sql2("field1", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.OBJECT, SqlColumnType.INTEGER), new Object[0]);
        this.checkValue0(this.sql2("null", "1"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0(this.sql2("'abcde'", "2"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.checkFailure0(this.sql2("true", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), new Object[0]);
        this.checkFailure0(this.sql2("1", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.TINYINT, SqlColumnType.INTEGER), new Object[0]);
        this.checkFailure0(this.sql2("1.1", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL, SqlColumnType.INTEGER), new Object[0]);
        this.checkFailure0(this.sql2("1.1E1", "1"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.DOUBLE, SqlColumnType.INTEGER), new Object[0]);
        this.checkValue0(this.sql2("?", "1"), SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkValue0(this.sql2("?", "2"), SqlColumnType.VARCHAR, "bcde", "abcde");
        this.checkValue0(this.sql2("?", "1"), SqlColumnType.VARCHAR, "a", Character.valueOf('a'));
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN), true);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TINYINT), (byte)1);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.SMALLINT), (short)1);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.INTEGER), 1);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.BIGINT), 1L);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DOUBLE), 1.0);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(this.sql2("?", "1"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testArg2() {
        this.putAndCheckFailure(true, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckValue((byte)2, this.sql2("'abcde'", "this"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.putAndCheckValue((short)2, this.sql2("'abcde'", "this"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.putAndCheckValue(2, this.sql2("'abcde'", "this"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.putAndCheckFailure(2L, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(2.0, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, this.sql2("'abcde'", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.OBJECT), new Object[0]);
        this.checkValue0(this.sql2("'abcde'", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkFailure0(this.sql2("'abcde'", "true"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql2("'abcde'", "'2'"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.checkValue0(this.sql2("'abcde'", "2"), SqlColumnType.VARCHAR, "bcde", new Object[0]);
        this.checkFailure0(this.sql2("'abcde'", "2.2"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure0(this.sql2("'abcde'", "2.2E2"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.DOUBLE), new Object[0]);
        this.checkValue0(this.sql2("'abcde'", "?"), SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), true);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), "2");
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), Character.valueOf('2'));
        this.checkValue0(this.sql2("'abcde'", "?"), SqlColumnType.VARCHAR, "bcde", (byte)2);
        this.checkValue0(this.sql2("'abcde'", "?"), SqlColumnType.VARCHAR, "bcde", (short)2);
        this.checkValue0(this.sql2("'abcde'", "?"), SqlColumnType.VARCHAR, "bcde", 2);
        this.checkValue0(this.sql2("'abcde'", "?"), SqlColumnType.VARCHAR, "bcde", 2L);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.REAL), Float.valueOf(2.0f));
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DOUBLE), 2.0);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(this.sql2("'abcde'", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testArg3() {
        this.putAndCheckFailure(true, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckValue((byte)2, this.sql3("'abcde'", "2", "this"), SqlColumnType.VARCHAR, "bc", new Object[0]);
        this.putAndCheckValue((short)2, this.sql3("'abcde'", "2", "this"), SqlColumnType.VARCHAR, "bc", new Object[0]);
        this.putAndCheckValue(2, this.sql3("'abcde'", "2", "this"), SqlColumnType.VARCHAR, "bc", new Object[0]);
        this.putAndCheckFailure(2L, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(2.0, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, this.sql3("'abcde'", "2", "this"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.OBJECT), new Object[0]);
        this.checkValue0(this.sql3("'abcde'", "2", "null"), SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkFailure0(this.sql3("'abcde'", "2", "true"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql3("'abcde'", "2", "'2'"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), new Object[0]);
        this.checkValue0(this.sql3("'abcde'", "2", "2"), SqlColumnType.VARCHAR, "bc", new Object[0]);
        this.checkFailure0(this.sql3("'abcde'", "2", "2.2"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure0(this.sql3("'abcde'", "2", "2.2E2"), 1008, SubstringFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR, SqlColumnType.INTEGER, SqlColumnType.DOUBLE), new Object[0]);
        this.checkValue0(this.sql3("'abcde'", "2", "?"), SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), true);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), "2");
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), Character.valueOf('2'));
        this.checkValue0(this.sql3("'abcde'", "2", "?"), SqlColumnType.VARCHAR, "bc", (byte)2);
        this.checkValue0(this.sql3("'abcde'", "2", "?"), SqlColumnType.VARCHAR, "bc", (short)2);
        this.checkValue0(this.sql3("'abcde'", "2", "?"), SqlColumnType.VARCHAR, "bc", 2);
        this.checkValue0(this.sql3("'abcde'", "2", "?"), SqlColumnType.VARCHAR, "bc", 2L);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.REAL), Float.valueOf(2.0f));
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DOUBLE), 2.0);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(this.sql3("'abcde'", "2", "?"), 2000, SubstringFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private String sql2(String inputOperand, String fromOperand) {
        if (this.useFunctionalSyntax) {
            return "SELECT SUBSTRING(" + inputOperand + ", " + fromOperand + ") FROM map";
        }
        return "SELECT SUBSTRING(" + inputOperand + " FROM " + fromOperand + ") FROM map";
    }

    private String sql3(String inputOperand, String fromOperand, String forOperand) {
        if (this.useFunctionalSyntax) {
            return "SELECT SUBSTRING(" + inputOperand + ", " + fromOperand + ", " + forOperand + ") FROM map";
        }
        return "SELECT SUBSTRING(" + inputOperand + " FROM " + fromOperand + " FOR " + forOperand + ") FROM map";
    }

    @Test
    public void testEquals() {
        ConstantExpression input1 = ConstantExpression.create((Object)"a", (QueryDataType)QueryDataType.VARCHAR);
        ConstantExpression input2 = ConstantExpression.create((Object)"b", (QueryDataType)QueryDataType.VARCHAR);
        ConstantExpression start1 = ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT);
        ConstantExpression start2 = ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT);
        ConstantExpression length1 = ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT);
        ConstantExpression length2 = ConstantExpression.create((Object)20, (QueryDataType)QueryDataType.INT);
        SubstringFunction function = SubstringFunction.create((Expression)input1, (Expression)start1, (Expression)length1);
        SubstringFunctionIntegrationTest.checkEquals(function, SubstringFunction.create((Expression)input1, (Expression)start1, (Expression)length1), true);
        SubstringFunctionIntegrationTest.checkEquals(function, SubstringFunction.create((Expression)input2, (Expression)start1, (Expression)length1), false);
        SubstringFunctionIntegrationTest.checkEquals(function, SubstringFunction.create((Expression)input1, (Expression)start2, (Expression)length1), false);
        SubstringFunctionIntegrationTest.checkEquals(function, SubstringFunction.create((Expression)input1, (Expression)start1, (Expression)length2), false);
    }

    @Test
    public void testSerialization() {
        SubstringFunction original = SubstringFunction.create((Expression)ConstantExpression.create((Object)"a", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT));
        SubstringFunction restored = (SubstringFunction)SubstringFunctionIntegrationTest.serializeAndCheck(original, 64);
        SubstringFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private static String signatureError(SqlColumnType ... columnTypes) {
        return SubstringFunctionIntegrationTest.signatureErrorFunction("SUBSTRING", columnTypes);
    }
}

