/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.ReplaceFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ReplaceFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test() {
        this.put("xyz");
        this.check(this.sql("this", "'x'", "'X'"), "Xyz");
        this.check(this.sql("this", "'x'", "'XX'"), "XXyz");
        this.check(this.sql("this", "'none'", "'xxx'"), "xyz");
    }

    @Test
    public void testEmptyString() {
        this.put("yyy");
        this.check(this.sql("this", "''", "'Y'"), "yyy");
        this.check(this.sql("this", "'y'", "''"), "");
        this.put("");
        this.check(this.sql("this", "''", "'Y'"), "");
        this.check(this.sql("this", "''", "''"), "");
    }

    @Test
    public void testNull() {
        this.put("xyz");
        this.check(this.sql("NULL", "NULL", "NULL"), null);
        this.check(this.sql("NULL", "'x'", "'X'"), null);
        this.check(this.sql("NULL", "NULL", "'x'"), null);
        this.check(this.sql("NULL", "'x'", "NULL"), null);
        this.check(this.sql("this", "NULL", "'X'"), null);
        this.check(this.sql("this", "'x'", "NULL"), null);
        this.check(this.sql("this", "NULL", "NULL"), null);
    }

    @Test
    public void testMultipleMatch() {
        this.put("xyzx");
        this.check(this.sql("this", "'x'", "'X'"), "XyzX");
        this.check(this.sql("this", "'x'", "''"), "yz");
    }

    @Test
    public void testFailure() {
        this.put(123);
        this.checkFail(this.sql("this", "123", "333"));
        this.checkFail(this.sql("this", "123", "'333'"));
        this.checkFail(this.sql("this", "'123'", "333"));
        this.put(true);
        this.checkFail(this.sql("this", "123", "333"));
        this.checkFail(this.sql("this", "123", "'333'"));
        this.checkFail(this.sql("this", "'123'", "333"));
        this.put("123");
        this.checkFail(this.sql("this", "123", "333"));
    }

    @Test
    public void testEquals() {
        ReplaceFunction f = this.createFunction("xyz", "x", "X");
        ReplaceFunctionIntegrationTest.checkEquals(f, this.createFunction("xyz", "x", "X"), true);
        ReplaceFunctionIntegrationTest.checkEquals(f, this.createFunction("xyz", "x", "Y"), false);
    }

    @Test
    public void testSerialization() {
        ReplaceFunction f = this.createFunction("xyz", "x", "X");
        ReplaceFunction deserialized = (ReplaceFunction)ReplaceFunctionIntegrationTest.serializeAndCheck(f, 68);
        ReplaceFunctionIntegrationTest.checkEquals(f, deserialized, true);
    }

    private void check(String sql, String expectedResult) {
        List<SqlRow> rows = ReplaceFunctionIntegrationTest.execute(sql, new Object[0]);
        ReplaceFunctionIntegrationTest.assertGreaterOrEquals((String)"size must be greater than 0", (long)rows.size(), (long)0L);
        SqlRow row = rows.get(0);
        Assert.assertEquals((Object)SqlColumnType.VARCHAR, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)expectedResult, (Object)row.getObject(0));
    }

    private void checkFail(String sql) {
        try {
            ReplaceFunctionIntegrationTest.execute(sql, new Object[0]);
            Assert.fail((String)"Test should have been failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof HazelcastSqlException));
        }
    }

    private String name() {
        return "REPLACE";
    }

    private String sql(Object original, Object from, Object to) {
        return String.format("SELECT %s(%s, %s, %s) FROM map", this.name(), original, from, to);
    }

    private ReplaceFunction createFunction(String original, String from, String to) {
        return ReplaceFunction.create((Expression)ConstantExpression.create((Object)original, (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)from, (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)to, (QueryDataType)QueryDataType.VARCHAR));
    }
}

