/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.ConcatFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ConcatFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        for (ExpressionType<?> type1 : ExpressionTypes.all()) {
            for (ExpressionType<?> type2 : ExpressionTypes.all()) {
                Class<? extends ExpressionBiValue> clazz = ExpressionBiValue.createBiClass(type1.typeName(), type2.typeName());
                this.checkColumns((ExpressionBiValue)ExpressionBiValue.createBiValue(clazz, 0, type1.valueFrom(), type2.valueFrom()), String.valueOf(type1.valueFrom()) + String.valueOf(type2.valueFrom()));
                this.checkColumns((ExpressionBiValue)ExpressionBiValue.createBiValue(clazz, 0, null, type2.valueFrom()), null);
                this.checkColumns((ExpressionBiValue)ExpressionBiValue.createBiValue(clazz, 0, type1.valueFrom(), null), null);
                this.checkColumns((ExpressionBiValue)ExpressionBiValue.createBiValue(clazz, 0, null, null), null);
            }
        }
    }

    @Test
    public void testLiteral() {
        this.put("1");
        this.check("this || 2", "12", new Object[0]);
        this.check("this || '2'", "12", new Object[0]);
        this.check("this || 2e0", "12E0", new Object[0]);
        this.check("this || true", "1true", new Object[0]);
        this.check("this || null", null, new Object[0]);
        this.check("null || null", null, new Object[0]);
        this.check("1 || 2", "12", new Object[0]);
        this.check("'1' || '2'", "12", new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put("1");
        this.check("this || ?", "12", "2");
        this.check("this || ?", "12", Character.valueOf('2'));
        this.check("this || ?", null, new Object[]{null});
        this.check("this || ?", "12", 2);
        this.check("this || ?", "1" + String.valueOf(LOCAL_DATE_VAL), LOCAL_DATE_VAL);
        this.check("this || ?", "1" + String.valueOf(LOCAL_TIME_VAL), LOCAL_TIME_VAL);
        this.check("this || ?", "1" + String.valueOf(LOCAL_DATE_TIME_VAL), LOCAL_DATE_TIME_VAL);
        this.check("this || ?", "1" + String.valueOf(OFFSET_DATE_TIME_VAL), OFFSET_DATE_TIME_VAL);
        this.check("? || this", "21", "2");
        this.check("? || this", "21", Character.valueOf('2'));
        this.check("? || this", null, new Object[]{null});
        this.check("? || ?", "12", "1", "2");
        this.check("? || ?", null, "1", null);
        this.check("? || ?", null, null, "2");
        this.check("? || ?", null, null, null);
        this.check("? || null", null, "1");
        this.check("null || ?", null, "1");
    }

    @Test
    public void testThreeOperands() {
        this.put(1, new ExpressionBiValue.StringStringVal().fields("2", "3"));
        this.check("__key || field1 || field2", "123", new Object[0]);
    }

    @Test
    public void testEquals() {
        ConcatFunction function = ConcatFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR));
        ConcatFunctionIntegrationTest.checkEquals(function, ConcatFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), true);
        ConcatFunctionIntegrationTest.checkEquals(function, ConcatFunction.create((Expression)ConstantExpression.create((Object)"10", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
        ConcatFunctionIntegrationTest.checkEquals(function, ConcatFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)"20", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        ConcatFunction original = ConcatFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR));
        ConcatFunction restored = (ConcatFunction)ConcatFunctionIntegrationTest.serializeAndCheck(original, 62);
        ConcatFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private void checkColumns(ExpressionBiValue value, String expectedResult) {
        this.put(value);
        this.check("field1 || field2", expectedResult, new Object[0]);
    }

    private void check(String operands, String expectedResult, Object ... params) {
        String sql = "SELECT " + operands + " FROM map";
        this.checkValue0(sql, SqlColumnType.VARCHAR, expectedResult, params);
    }
}

