/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.IsNotNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNullPredicate;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IsNullPredicateIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        this.checkColumn(ExpressionTypes.BOOLEAN);
        this.checkColumn(ExpressionTypes.BYTE);
        this.checkColumn(ExpressionTypes.SHORT);
        this.checkColumn(ExpressionTypes.INTEGER);
        this.checkColumn(ExpressionTypes.LONG);
        this.checkColumn(ExpressionTypes.BIG_INTEGER);
        this.checkColumn(ExpressionTypes.BIG_DECIMAL);
        this.checkColumn(ExpressionTypes.FLOAT);
        this.checkColumn(ExpressionTypes.DOUBLE);
        this.checkColumn(ExpressionTypes.STRING);
        this.checkColumn(ExpressionTypes.CHARACTER);
        this.checkColumn(ExpressionTypes.LOCAL_DATE);
        this.checkColumn(ExpressionTypes.LOCAL_TIME);
        this.checkColumn(ExpressionTypes.LOCAL_DATE_TIME);
        this.checkColumn(ExpressionTypes.OFFSET_DATE_TIME);
        this.checkColumn(ExpressionTypes.OBJECT);
    }

    private void checkColumn(ExpressionType<?> type) {
        Class<? extends ExpressionValue> clazz = ExpressionValue.createClass(type);
        int keyNull = 0;
        int keyNotNull = 1;
        HashMap<Integer, Object> entries = new HashMap<Integer, Object>();
        entries.put(keyNull, ExpressionValue.create(clazz, keyNull, null));
        entries.put(keyNotNull, ExpressionValue.create(clazz, keyNotNull, type.valueFrom()));
        this.putAll(entries);
        this.checkColumn("IS NULL", IsNullPredicateIntegrationTest.set(keyNull));
        this.checkColumn("IS NOT NULL", IsNullPredicateIntegrationTest.set(keyNotNull));
    }

    private void checkColumn(String function, Set<Integer> expectedKeys) {
        String expression = "field1 " + function;
        String sql = "SELECT key, " + expression + " FROM map WHERE " + expression;
        List<SqlRow> rows = IsNullPredicateIntegrationTest.execute(sql, new Object[0]);
        Assert.assertEquals((long)expectedKeys.size(), (long)rows.size());
        for (SqlRow row : rows) {
            Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(1).getType());
            int key = (Integer)row.getObject(0);
            boolean value = (Boolean)row.getObject(1);
            Assert.assertTrue((String)("Key is not returned: " + key), (boolean)expectedKeys.contains(key));
            Assert.assertTrue((boolean)value);
        }
    }

    @Test
    public void testLiteral() {
        Class<? extends ExpressionValue> clazz = ExpressionValue.createClass(ExpressionTypes.INTEGER);
        int key = 0;
        Object value = ExpressionValue.create(clazz, 0, 1);
        this.put(key, value);
        this.checkLiteral("null", true);
        this.checkLiteral("true", false);
        this.checkLiteral("false", false);
        this.checkLiteral("1", false);
        this.checkLiteral("1.1", false);
        this.checkLiteral("1.1E1", false);
        this.checkLiteral("'a'", false);
    }

    private void checkLiteral(String literal, boolean expectedResult) {
        this.checkLiteral(literal, "IS NULL", expectedResult);
        this.checkLiteral(literal, "IS NOT NULL", !expectedResult);
    }

    private void checkLiteral(String literal, String function, boolean expectedResult) {
        String expression = literal + " " + function;
        String sql = "SELECT " + expression + " FROM map WHERE " + expression;
        List<SqlRow> rows = IsNullPredicateIntegrationTest.execute(sql, new Object[0]);
        if (expectedResult) {
            Assert.assertEquals((long)1L, (long)rows.size());
            SqlRow row = rows.get(0);
            Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(0).getType());
            Assert.assertTrue((boolean)((Boolean)row.getObject(0)));
        } else {
            Assert.assertEquals((long)0L, (long)rows.size());
        }
    }

    @Test
    public void testParameter() {
        Class<? extends ExpressionValue> clazz = ExpressionValue.createClass(ExpressionTypes.INTEGER);
        int key = 0;
        Object value = ExpressionValue.create(clazz, 0, 1);
        this.put(key, value);
        Assert.assertEquals(IsNullPredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NULL", new Object[]{null}));
        Assert.assertEquals(IsNullPredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS NOT NULL", new Object[]{null}));
        this.checkParameter(key, ExpressionTypes.BOOLEAN);
        this.checkParameter(key, ExpressionTypes.BYTE);
        this.checkParameter(key, ExpressionTypes.SHORT);
        this.checkParameter(key, ExpressionTypes.INTEGER);
        this.checkParameter(key, ExpressionTypes.LONG);
        this.checkParameter(key, ExpressionTypes.BIG_INTEGER);
        this.checkParameter(key, ExpressionTypes.BIG_DECIMAL);
        this.checkParameter(key, ExpressionTypes.FLOAT);
        this.checkParameter(key, ExpressionTypes.DOUBLE);
        this.checkParameter(key, ExpressionTypes.STRING);
        this.checkParameter(key, ExpressionTypes.CHARACTER);
        this.checkParameter(key, ExpressionTypes.LOCAL_DATE);
        this.checkParameter(key, ExpressionTypes.LOCAL_TIME);
        this.checkParameter(key, ExpressionTypes.LOCAL_DATE_TIME);
        this.checkParameter(key, ExpressionTypes.OFFSET_DATE_TIME);
        this.checkParameter(key, ExpressionTypes.OBJECT);
    }

    private void checkParameter(int key, ExpressionType<?> type) {
        Object parameter = type.valueFrom();
        Assert.assertNotNull(parameter);
        Assert.assertEquals(IsNullPredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS NULL", parameter));
        Assert.assertEquals(IsNullPredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NOT NULL", parameter));
    }

    private Set<Integer> keys(String sql, Object ... params) {
        List<SqlRow> rows = IsNullPredicateIntegrationTest.execute(sql, params);
        if (rows.isEmpty()) {
            return Collections.emptySet();
        }
        Assert.assertEquals((long)1L, (long)rows.get(0).getMetadata().getColumnCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (SqlRow row : rows) {
            int key = (Integer)row.getObject(0);
            boolean added = keys.add(key);
            Assert.assertTrue((String)("Key is not unique: " + key), (boolean)added);
        }
        return keys;
    }

    private static Set<Integer> set(Integer ... values) {
        HashSet<Integer> res = new HashSet<Integer>();
        if (values != null) {
            res.addAll(Arrays.asList(values));
        }
        return res;
    }

    @Test
    public void testEquality_isNull() {
        ColumnExpression column1 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT);
        ColumnExpression column2 = ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT);
        IsNullPredicateIntegrationTest.checkEquals(IsNullPredicate.create((Expression)column1), IsNullPredicate.create((Expression)column1), true);
        IsNullPredicateIntegrationTest.checkEquals(IsNullPredicate.create((Expression)column1), IsNullPredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isNull() {
        IsNullPredicate original = IsNullPredicate.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT));
        IsNullPredicate restored = (IsNullPredicate)IsNullPredicateIntegrationTest.serializeAndCheck(original, 33);
        IsNullPredicateIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testEquality_isNotNull() {
        ColumnExpression column1 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT);
        ColumnExpression column2 = ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT);
        IsNullPredicateIntegrationTest.checkEquals(IsNotNullPredicate.create((Expression)column1), IsNotNullPredicate.create((Expression)column1), true);
        IsNullPredicateIntegrationTest.checkEquals(IsNotNullPredicate.create((Expression)column1), IsNotNullPredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isNotNull() {
        IsNotNullPredicate original = IsNotNullPredicate.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT));
        IsNotNullPredicate restored = (IsNotNullPredicate)IsNullPredicateIntegrationTest.serializeAndCheck(original, 50);
        IsNullPredicateIntegrationTest.checkEquals(original, restored, true);
    }
}

